/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.repository.CustomResource;
import com.sun.enterprise.repository.ExternalJndiResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceCollectionImpl;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.MailResource;
import com.sun.enterprise.repository.PMFResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASJ2EEResourceFactoryImpl
implements J2EEResourceFactory {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise");
    static final String JMS_QUEUE = "javax.jms.Queue";
    static final String JMS_TOPIC = "javax.jms.Topic";
    static final String JMS_QUEUE_CONNECTION_FACTORY = "javax.jms.QueueConnectionFactory";
    static final String JMS_TOPIC_CONNECTION_FACTORY = "javax.jms.TopicConnectionFactory";
    public static final String CUSTOM_RES_TYPE = "custom-resource";
    public static final String EXT_JNDI_RES_TYPE = "external-jndi-resource";
    public static final String JDBC_RES_TYPE = "jdbc-resource";
    public static final String MAIL_RES_TYPE = "mail-resource";
    public static final String JMS_RES_TYPE = "jms-resource";
    public static final String PMF_RES_TYPE = "persistence-manager-factory-resource";
    public static final String JDBC_CONN_POOL_RES_TYPE = "jdbc-connection-pool";
    public static final String CONNECTOR_CONN_POOL_TYPE = "connector-connection-pool";
    private ConfigContext ctx = null;
    private Resources rBean = null;
    private String serverName = null;
    private volatile J2EEResourceCollection resources = null;

    public J2EEResourceCollection loadDefaultResourceCollection() throws J2EEResourceException {
        if (this.resources != null) {
            return this.resources;
        }
        return this.loadResourceCollection(null);
    }

    public synchronized J2EEResourceCollection loadResourceCollection(String resourcesURL) throws J2EEResourceException {
        this.resources = new J2EEResourceCollectionImpl();
        ServerContext sc = ApplicationServer.getServerContext();
        if (sc == null) {
            _logger.log(Level.FINE, "Not Running in server. Returning empty resources...");
            return this.resources;
        }
        this.serverName = sc.getInstanceName();
        try {
            this.ctx = sc.getConfigContext();
            this.rBean = ServerBeansFactory.getDomainBean(this.ctx).getResources();
            if (this.rBean == null) {
                this.rBean = new Resources();
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "enterprise.empty_resource", ce);
            _logger.log(Level.FINE, "Error initializing context. Returning empty resources...");
            return this.resources;
        }
        try {
            _logger.log(Level.FINE, "Loading PMF Resource==========");
            this.loadPMFResource(this.resources);
            _logger.log(Level.FINE, "Loading Custom Resource==========");
            this.loadCustomResource(this.resources);
            _logger.log(Level.FINE, "Loading External Jndi Resource==========");
            this.loadExternalJndiResource(this.resources);
            _logger.log(Level.FINE, "Loading Mail Resource==========");
            this.loadMailResource(this.resources);
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "enterprise.config_exception", ce);
            _logger.log(Level.FINE, "Error Loading resources: " + ce.getMessage());
            throw new J2EEResourceException(ce);
        }
        return this.resources;
    }

    public void storeDefaultResourceCollection(J2EEResourceCollection resources) throws J2EEResourceException {
        this.storeResourceCollection(resources, null);
    }

    public void storeResourceCollection(J2EEResourceCollection resources, String resourcesURL) throws J2EEResourceException {
    }

    public J2EEResource createResource(int type, String name) {
        J2EEResourceBase resource = null;
        switch (type) {
            case 9: {
                resource = new PMFResource(name);
                break;
            }
            case 11: {
                resource = new CustomResource(name);
                break;
            }
            case 10: {
                resource = new ExternalJndiResource(name);
                break;
            }
            case 12: {
                resource = new MailResource(name);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return resource;
    }

    public ResourceProperty createProperty(String name) {
        return new ResourcePropertyImpl(name);
    }

    private boolean isReferenced(String resourceName) throws ConfigException {
        return ServerHelper.serverReferencesResource(this.ctx, this.serverName, resourceName);
    }

    private void loadCustomResource(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.CustomResource[] jBeanSet = this.rBean.getCustomResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.CustomResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping Custom Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), CUSTOM_RES_TYPE);
                continue;
            }
            J2EEResource jr = IASJ2EEResourceFactoryImpl.toCustomJ2EEResource(next);
            resources.addResource(jr);
        }
    }

    public static J2EEResource toCustomJ2EEResource(com.sun.enterprise.config.serverbeans.CustomResource rbean) throws ConfigException {
        CustomResource jr = new CustomResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next.getName(), next.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    public static J2EEResource toExternalJndiJ2EEResource(com.sun.enterprise.config.serverbeans.ExternalJndiResource rbean) throws ConfigException {
        ExternalJndiResource jr = new ExternalJndiResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setJndiLookupName(rbean.getJndiLookupName());
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next.getName(), next.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    private void loadExternalJndiResource(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.ExternalJndiResource[] jBeanSet = this.rBean.getExternalJndiResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.ExternalJndiResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping External JNDI Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), EXT_JNDI_RES_TYPE);
                continue;
            }
            J2EEResource jr = IASJ2EEResourceFactoryImpl.toExternalJndiJ2EEResource(next);
            resources.addResource(jr);
        }
    }

    private void loadPMFResource(J2EEResourceCollection resources) throws ConfigException {
        PersistenceManagerFactoryResource[] jBeanSet = this.rBean.getPersistenceManagerFactoryResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            PersistenceManagerFactoryResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping PMF Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), PMF_RES_TYPE);
                continue;
            }
            resources.addResource(IASJ2EEResourceFactoryImpl.toPMFJ2EEResource(next));
        }
    }

    public static J2EEResource toPMFJ2EEResource(PersistenceManagerFactoryResource rbean) throws ConfigException {
        PMFResource jr = new PMFResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setFactoryClass(rbean.getFactoryClass());
        jr.setJdbcResourceJndiName(rbean.getJdbcResourceJndiName());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next1 = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next1.getName(), next1.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    public static J2EEResource toMailJ2EEResource(com.sun.enterprise.config.serverbeans.MailResource rbean) throws ConfigException {
        MailResource jr = new MailResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setStoreProtocol(rbean.getStoreProtocol());
        jr.setStoreProtocolClass(rbean.getStoreProtocolClass());
        jr.setTransportProtocol(rbean.getTransportProtocol());
        jr.setTransportProtocolClass(rbean.getTransportProtocolClass());
        jr.setMailHost(rbean.getHost());
        jr.setUsername(rbean.getUser());
        jr.setMailFrom(rbean.getFrom());
        jr.setDebug(rbean.isDebug());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next.getName(), next.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    private void loadMailResource(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.MailResource[] jBeanSet = this.rBean.getMailResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.MailResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping Mail Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), MAIL_RES_TYPE);
                continue;
            }
            J2EEResource jr = IASJ2EEResourceFactoryImpl.toMailJ2EEResource(next);
            resources.addResource(jr);
        }
    }

    private void logMessageIfNotEnabled(String name, String type) {
        _logger.log(Level.INFO, "enterprise.resource_disabled", new Object[]{name, type});
    }
}

