/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceManagerImpl;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class LazyEnlistableResourceManagerImpl
extends ResourceManagerImpl {
    protected void enlist(J2EETransactionManager tm, Transaction tran, ResourceHandle h) {
    }

    public void registerResource(ResourceHandle handle) throws PoolingException {
        handle.setEnlistmentSuspended(true);
        super.registerResource(handle);
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Entering lazyEnlist");
        }
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        Transaction tran = null;
        try {
            tran = tm.getTransaction();
            if (tran == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Transaction null - not enlisting ");
                }
                return;
            }
        }
        catch (SystemException se) {
            ResourceException re = new ResourceException(se.getMessage());
            re.initCause((Throwable)se);
            throw re;
        }
        List invList = Switch.getSwitch().getInvocationManager().getAllInvocations();
        ResourceHandle h = null;
        block4: for (int j = invList.size(); j > 0; --j) {
            ComponentInvocation inv = (ComponentInvocation)invList.get(j - 1);
            Object comp = inv.getInstance();
            List l = ((J2EETransactionManagerImpl)tm).getResourceList(comp, inv);
            ListIterator it = l.listIterator();
            while (it.hasNext()) {
                ResourceHandle hand = (ResourceHandle)it.next();
                ManagedConnection toEnlist = (ManagedConnection)hand.getResource();
                if (!mc.equals(toEnlist)) continue;
                h = hand;
                continue block4;
            }
        }
        if (h != null && h.getResourceState().isUnenlisted()) {
            try {
                h.setEnlistmentSuspended(false);
                tm.enlistResource(tran, h);
                h.setEnlistmentSuspended(true);
            }
            catch (Exception e) {
                PoolManager mgr = Switch.getSwitch().getPoolManager();
                mgr.putbackDirectToPool(h, h.getResourceSpec().getConnectionPoolName());
                _logger.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("rm.enlistResource threw Exception. Returning resource to pool");
                }
                throw new ResourceException((Throwable)e);
            }
        }
    }
}

