/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class Resource {
    protected static final String CUSTOM_RESOURCE = "custom-resource";
    protected static final String JDBC_CONNECTION_POOL = "jdbc-connection-pool";
    protected static final String CONNECTOR_RESOURCE = "connector-resource";
    protected static final String ADMIN_OBJECT_RESOURCE = "admin-object-resource";
    protected static final String JDBC_RESOURCE = "jdbc-resource";
    protected static final String RESOURCE_ADAPTER_CONFIG = "resource-adapter-config";
    protected static final String MAIL_RESOURCE = "mail-resource";
    protected static final String EXTERNAL_JNDI_RESOURCE = "external-jndi-resource";
    protected static final String CONNECTOR_CONNECTION_POOL = "connector-connection-pool";
    protected static final String PERSISTENCE_MANAGER_FACTORY_RESOURCE = "persistence-manager-factory-resource";
    protected static final String CONNECTOR_SECURITY_MAP = "security-map";
    private String resType;
    private AttributeList attrList = new AttributeList();
    private Properties props = new Properties();
    private String sDescription = null;

    public Resource(String type) {
        this.resType = type;
    }

    public String getType() {
        return this.resType;
    }

    public AttributeList getAttributes() {
        return this.attrList;
    }

    public void setAttribute(String name, String value) {
        this.attrList.add(new Attribute(name, value));
    }

    public void setAttribute(String name, String[] value) {
        this.attrList.add(new Attribute(name, value));
    }

    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource r = (Resource)obj;
        return r.getType().equals(this.getType()) && r.getProperties().equals(this.getProperties()) && r.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        return this.getAttributes().hashCode() + this.getProperties().hashCode() + this.getType().hashCode();
    }

    public boolean isAConflict(Resource r) {
        return this.hasSameIdentity(r) && !r.equals(this);
    }

    private boolean hasSameIdentity(Resource r) {
        if (r.getType() != this.getType()) {
            return false;
        }
        String rType = r.getType();
        if (rType.equals(CUSTOM_RESOURCE) || rType.equals(EXTERNAL_JNDI_RESOURCE) || rType.equals(JDBC_RESOURCE) || rType.equals(PERSISTENCE_MANAGER_FACTORY_RESOURCE) || rType.equals(CONNECTOR_RESOURCE) || rType.equals(ADMIN_OBJECT_RESOURCE) || rType.equals(MAIL_RESOURCE)) {
            return this.isEqualAttribute(r, "jndi-name");
        }
        if (rType.equals(JDBC_CONNECTION_POOL) || rType.equals(CONNECTOR_CONNECTION_POOL)) {
            return this.isEqualAttribute(r, "name");
        }
        if (rType.equals(RESOURCE_ADAPTER_CONFIG)) {
            return this.isEqualAttribute(r, RESOURCE_ADAPTER_CONFIG);
        }
        return false;
    }

    private boolean isEqualAttribute(Resource r, String name) {
        return this.getAttribute(r, name).equals(this.getAttribute(this, name));
    }

    private Attribute getAttribute(Resource r, String name) {
        for (Attribute elt : r.getAttributes()) {
            if (!elt.getName().equals(name)) continue;
            return elt;
        }
        return null;
    }

    public String toString() {
        String rType = this.getType();
        String identity = "";
        if (rType.equals(CUSTOM_RESOURCE) || rType.equals(EXTERNAL_JNDI_RESOURCE) || rType.equals(JDBC_RESOURCE) || rType.equals(PERSISTENCE_MANAGER_FACTORY_RESOURCE) || rType.equals(CONNECTOR_RESOURCE) || rType.equals(ADMIN_OBJECT_RESOURCE) || rType.equals(MAIL_RESOURCE)) {
            identity = (String)this.getAttribute(this, "jndi-name").getValue();
        } else if (rType.equals(JDBC_CONNECTION_POOL) || rType.equals(CONNECTOR_CONNECTION_POOL)) {
            identity = (String)this.getAttribute(this, "name").getValue();
        } else if (rType.equals(RESOURCE_ADAPTER_CONFIG)) {
            identity = (String)this.getAttribute(this, RESOURCE_ADAPTER_CONFIG).getValue();
        }
        return identity + " of type " + this.resType;
    }
}

