/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import javax.security.auth.login.LoginException;

public class LDAPLoginModule
extends PasswordLoginModule {
    private LDAPRealm _ldapRealm;

    protected void authenticate() throws LoginException {
        String[] groupListToForward;
        if (!(this._currentRealm instanceof LDAPRealm)) {
            String msg = sm.getString("ldaplm.badrealm");
            throw new LoginException(msg);
        }
        this._ldapRealm = (LDAPRealm)this._currentRealm;
        if (this._password == null || this._password.length() == 0) {
            String msg = sm.getString("ldaplm.emptypassword", this._username);
            throw new LoginException(msg);
        }
        String mode = this._currentRealm.getProperty("mode");
        if ("find-bind".equals(mode)) {
            String[] grpList = this._ldapRealm.findAndBind(this._username, this._password);
            groupListToForward = new String[grpList.length];
            for (int i = 0; i < grpList.length; ++i) {
                groupListToForward[i] = grpList[i];
            }
        } else {
            String msg = sm.getString("ldaplm.badmode", mode);
            throw new LoginException(msg);
        }
        this.commitAuthentication(this._username, this._password, this._currentRealm, groupListToForward);
    }
}

