/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.factory;

import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.security.factory.AbstractSecurityManagerFactory;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

public final class EJBSecurityManagerFactory
extends AbstractSecurityManagerFactory {
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static SecurityManagerFactory _theFactory;
    private Map CONTEXT_ID = new HashMap();

    private EJBSecurityManagerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityManagerFactory getInstance() {
        try {
            rwLock.readLock().lock();
            if (_theFactory != null) {
                SecurityManagerFactory securityManagerFactory = _theFactory;
                return securityManagerFactory;
            }
        }
        finally {
            rwLock.readLock().unlock();
        }
        try {
            rwLock.writeLock().lock();
            if (_theFactory == null) {
                _theFactory = new EJBSecurityManagerFactory();
            }
            SecurityManagerFactory securityManagerFactory = _theFactory;
            return securityManagerFactory;
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    public SecurityManager getSecurityManager(String contextId) {
        if (this._poolHas(contextId)) {
            return this._poolGet(contextId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityManager createSecurityManager(Descriptor descriptor) {
        EJBSecurityManager ejbSM = null;
        String contextId = null;
        String appName = null;
        try {
            ejbSM = EJBSecurityManager.getInstance(descriptor);
            EjbDescriptor ejbdes = (EjbDescriptor)descriptor;
            appName = ejbdes.getApplication().getRegistrationName();
            contextId = EJBSecurityManager.getContextID(ejbdes);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[EJB-Security] EJB Security:Creating EJBSecurityManager for contextId = " + contextId);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "[EJB-Security] FATAl Exception. Unable to create EJBSecurityManager: " + e.getMessage());
            throw new RuntimeException(e);
        }
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            ArrayList<String> lst = (ArrayList<String>)this.CONTEXT_ID.get(appName);
            if (lst == null) {
                lst = new ArrayList<String>();
                this.CONTEXT_ID.put(appName, lst);
            }
            if (!lst.contains(contextId)) {
                lst.add(contextId);
            }
        }
        this._poolPut(contextId, ejbSM);
        return ejbSM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAndRemoveContextIdForEjbAppName(String appName) {
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            List contextId = (List)this.CONTEXT_ID.get(appName);
            if (contextId == null) {
                return null;
            }
            String[] rvalue = new String[contextId.size()];
            rvalue = contextId.toArray(rvalue);
            this.CONTEXT_ID.remove(appName);
            return rvalue;
        }
    }
}

