/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private static final String DEFAULT_PROVIDER_NAME = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String DEFAULT_DS_NAME = "jdbc/__default";
    private static String defaultProvider;
    private static Logger logger;
    private static StringManager localStrings;
    private PersistenceUnitDescriptor persistenceUnitDescriptor;
    private String applicationLocation;
    private File absolutePuRootFile;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private List<URL> jarFiles;
    private InstrumentableClassLoader classLoader;

    public PersistenceUnitInfoImpl(PersistenceUnitDescriptor persistenceUnitDescriptor, String applicationLocation, InstrumentableClassLoader classLoader) {
        this.persistenceUnitDescriptor = persistenceUnitDescriptor;
        this.applicationLocation = applicationLocation;
        this.classLoader = classLoader;
        this.jarFiles = this._getJarFiles();
        this.jtaDataSource = this._getJtaDataSource();
        this.nonJtaDataSource = this._getNonJtaDataSource();
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitDescriptor.getName();
    }

    public String getPersistenceProviderClassName() {
        return PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc(this.persistenceUnitDescriptor);
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.valueOf((String)this.persistenceUnitDescriptor.getTransactionType());
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public URL getPersistenceUnitRootUrl() {
        try {
            return this.getAbsolutePuRootFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getMappingFileNames() {
        return this.persistenceUnitDescriptor.getMappingFiles();
    }

    public List<URL> getJarFileUrls() {
        return this.jarFiles;
    }

    public List<String> getManagedClassNames() {
        return this.persistenceUnitDescriptor.getClasses();
    }

    public boolean excludeUnlistedClasses() {
        return this.persistenceUnitDescriptor.isExcludeUnlistedClasses();
    }

    public Properties getProperties() {
        return this.persistenceUnitDescriptor.getProperties();
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)ClassLoader.class.cast(this.classLoader);
    }

    public void addTransformer(ClassTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    public ClassLoader getNewTempClassLoader() {
        return this.classLoader.copy();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("<persistence-unit>");
        result.append("\n\t<PURoot>" + this.getPersistenceUnitRootUrl() + "</PURoot>");
        result.append("\n\t<name>" + this.getPersistenceUnitName() + "</name>");
        result.append("\n\t<provider>" + this.getPersistenceProviderClassName() + "</provider>");
        result.append("\n\t<transaction-type>" + this.getTransactionType() + "</transaction-type>");
        result.append("\n\t<jta-data-source>" + this.getJtaDataSource() + "</jta-data-source>");
        result.append("\n\t<non-jta-data-source>" + this.getNonJtaDataSource() + "</non-jta-data-source>");
        for (URL jar : this.getJarFileUrls()) {
            result.append("\n\t<jar-file>" + jar + "</jar-file>");
        }
        for (String mappingFile : this.getMappingFileNames()) {
            result.append("\n\t<mapping-file>" + mappingFile + "</mapping-file>");
        }
        for (String clsName : this.getManagedClassNames()) {
            result.append("\n\t<class-name>" + clsName + "</class-name>");
        }
        result.append("\n\t<exclude-unlisted-classes>" + this.excludeUnlistedClasses() + "</exclude-unlisted-classes>");
        result.append("\n\t<properties>" + this.getProperties() + "</properties>");
        result.append("\n\t<class-loader>" + this.getClassLoader() + "</class-loader>");
        result.append("\n</persistence-unit>\n");
        return result.toString();
    }

    protected DataSource _getJtaDataSource() {
        String DSName;
        if (this.getTransactionType() != PersistenceUnitTransactionType.JTA) {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getJtaDataSource", "This PU is configured as non-jta, so jta-data-source is null");
            return null;
        }
        String userSuppliedJTADSName = this.persistenceUnitDescriptor.getJtaDataSource();
        if (!PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedJTADSName)) {
            DSName = userSuppliedJTADSName;
        } else if (PersistenceUnitInfoImpl.isNullOrEmpty(this.persistenceUnitDescriptor.getNonJtaDataSource())) {
            DSName = DEFAULT_DS_NAME;
        } else {
            String msg = localStrings.getString("puinfo.jta-ds-not-configured", new Object[]{this.persistenceUnitDescriptor.getName()});
            throw new RuntimeException(msg);
        }
        try {
            logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "_getJtaDataSource", "JTADSName = {0}", DSName);
            return (DataSource)DataSource.class.cast(this.lookupPMDataSource(DSName));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected DataSource lookupPMDataSource(String DSName) throws NamingException {
        return (DataSource)ConnectorRuntime.getRuntime().lookupPMResource(DSName, false);
    }

    protected DataSource lookupNonJtaDataSource(String DSName) throws NamingException {
        return (DataSource)ConnectorRuntime.getRuntime().lookupNonTxResource(DSName, false);
    }

    protected DataSource _getNonJtaDataSource() {
        String userSuppliedJTADSName;
        String userSuppliedNonJTADSName = this.persistenceUnitDescriptor.getNonJtaDataSource();
        String DSName = !PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedNonJTADSName) ? userSuppliedNonJTADSName : (!PersistenceUnitInfoImpl.isNullOrEmpty(userSuppliedJTADSName = this.persistenceUnitDescriptor.getJtaDataSource()) ? userSuppliedJTADSName : DEFAULT_DS_NAME);
        try {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getNonJtaDataSource", "nonJTADSName = {0}", DSName);
            return (DataSource)DataSource.class.cast(this.lookupNonJtaDataSource(DSName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<URL> _getJarFiles() {
        ArrayList<String> jarFileNames = new ArrayList<String>(this.persistenceUnitDescriptor.getJarFiles());
        ArrayList<URL> jarFiles = new ArrayList<URL>(jarFileNames.size() + 1);
        String absolutePuRoot = this.getAbsolutePuRootFile().getAbsolutePath();
        for (String jarFileName : jarFileNames) {
            String nativeJarFileName = jarFileName.replace('/', File.separatorChar);
            File parentFile = new File(absolutePuRoot).getParentFile();
            File jarFile = new File(parentFile, nativeJarFileName);
            if (!jarFile.exists()) {
                String pathComponent = "";
                String nameComponent = jarFileName;
                if (jarFileName.lastIndexOf("../") != -1) {
                    int separatorIndex = jarFileName.lastIndexOf("../") + 3;
                    pathComponent = jarFileName.substring(0, separatorIndex);
                    nameComponent = jarFileName.substring(separatorIndex);
                }
                logger.fine("For jar-file=" + jarFileName + ", " + "pathComponent=" + pathComponent + ", nameComponent=" + nameComponent);
                File parentPath = new File(parentFile, pathComponent);
                jarFile = new File(parentPath, DeploymentUtils.getRelativeEmbeddedModulePath(parentPath.getAbsolutePath(), nameComponent));
            }
            if (jarFile.exists()) {
                try {
                    jarFiles.add(jarFile.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            String msg = localStrings.getString("puinfo.referenced_jar_not_found", new Object[]{absolutePuRoot, jarFileName, jarFile});
            logger.log(Level.WARNING, msg);
        }
        return jarFiles;
    }

    private File getAbsolutePuRootFile() {
        if (this.absolutePuRootFile == null) {
            this.absolutePuRootFile = new File(this.applicationLocation, this.getAbsolutePuRoot().replace('/', File.separatorChar));
            if (!this.absolutePuRootFile.exists()) {
                throw new RuntimeException(this.absolutePuRootFile.getAbsolutePath() + " does not exist!");
            }
        }
        return this.absolutePuRootFile;
    }

    private String getAbsolutePuRoot() {
        RootDeploymentDescriptor rootDD = this.persistenceUnitDescriptor.getParent().getParent();
        String puRoot = this.persistenceUnitDescriptor.getPuRoot();
        if (rootDD.isApplication()) {
            return puRoot;
        }
        ModuleDescriptor module = ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).getModuleDescriptor();
        if (module.isStandalone()) {
            return puRoot;
        }
        String moduleLocation = DeploymentUtils.getRelativeEmbeddedModulePath(this.applicationLocation, module.getArchiveUri());
        return moduleLocation + '/' + puRoot;
    }

    private static String getDefaultprovider() {
        String DEFAULT_PERSISTENCE_PROVIDER_PROPERTY = "com.sun.persistence.defaultProvider";
        if (defaultProvider == null) {
            defaultProvider = System.getProperty("com.sun.persistence.defaultProvider", DEFAULT_PROVIDER_NAME);
        }
        return defaultProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createJar(String sourcePath, String destinationPath) throws IOException {
        FileArchive source = new FileArchive();
        OutputJarArchive destination = new OutputJarArchive();
        try {
            source.open(sourcePath);
            destination.create(destinationPath);
            Enumeration entries = source.entries();
            while (entries.hasMoreElements()) {
                String entry = (String)String.class.cast(entries.nextElement());
                InputStream is = null;
                OutputStream os = null;
                try {
                    is = source.getEntry(entry);
                    os = destination.putNextEntry(entry);
                    ArchivistUtils.copyWithoutClose(is, os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    destination.closeEntry();
                }
            }
        }
        finally {
            source.close();
            destination.close();
        }
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String getPersistenceProviderClassNameForPuDesc(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String provider = persistenceUnitDescriptor.getProvider();
        if (PersistenceUnitInfoImpl.isNullOrEmpty(provider)) {
            provider = PersistenceUnitInfoImpl.getDefaultprovider();
        }
        return provider;
    }

    static {
        logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
        localStrings = StringManager.getManager("com.sun.enterprise.server");
    }
}

