/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Set;

public class ASEjbRef
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        boolean oneWarning;
        boolean oneFailed;
        Object jndiName;
        String ejbName;
        ComponentNameConstructor compName;
        Result result;
        block17: {
            result = this.getInitializedResult();
            compName = this.getVerifierContext().getComponentNameConstructor();
            ejbName = null;
            jndiName = null;
            oneFailed = false;
            boolean notApplicable = false;
            oneWarning = false;
            try {
                ejbName = descriptor.getName();
                Set<EjbReference> ejbRefs = descriptor.getEjbReferenceDescriptors();
                if (ejbRefs.size() > 0) {
                    for (EjbReferenceDescriptor ejbReferenceDescriptor : ejbRefs) {
                        String refJndiName = this.getXPathValue("/sun-ejb-jar/enterprise-beans/ejb/ejb-ref[ejb-ref-name=\"" + ejbReferenceDescriptor.getName() + "\"]/jndi-name");
                        String refName = ejbReferenceDescriptor.getName();
                        String type = ejbReferenceDescriptor.getType();
                        if (!ejbReferenceDescriptor.isLocal()) {
                            if (type == null || !type.equals("Session") && !type.equals("Entity")) {
                                oneFailed = true;
                                this.addErrorDetails(result, compName);
                                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-EJB ejb-ref] ejb-ref-name has an invalid type in ejb-jar.xml. Type should be Session or Entity only"));
                            } else {
                                this.addGoodDetails(result, compName);
                                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-EJB ejb-ref] ejb-ref-name [{0}] is valid", new Object[]{refName}));
                            }
                        } else {
                            this.addNaDetails(result, compName);
                            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} Does not define any ejb references", new Object[]{ejbName}));
                            return result;
                        }
                        if (refJndiName != null) {
                            if (refJndiName.length() == 0) {
                                oneFailed = true;
                                this.addErrorDetails(result, compName);
                                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-EJB ejb-ref] : jndi-name cannot be an empty string", new Object[]{refName}));
                            } else if (!refJndiName.startsWith("ejb/")) {
                                oneWarning = true;
                                this.addWarningDetails(result, compName);
                                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB ejb-ref] JNDI name should start with ejb/ for an ejb reference", new Object[]{refName}));
                            }
                        } else {
                            oneFailed = true;
                            this.addErrorDetails(result, compName);
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-EJB ejb-ref] : jndi-name cannot be an empty string", new Object[]{refName}));
                        }
                        if (oneFailed) continue;
                        this.addGoodDetails(result, compName);
                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-EJB ejb-ref] : ejb-ref-Name is {0} and jndi-name is {1}", new Object[]{refName, refJndiName}));
                    }
                    break block17;
                }
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} Does not define any ejb references", new Object[]{ejbName}));
                return result;
            }
            catch (Exception ex) {
                oneFailed = true;
                this.addErrorDetails(result, compName);
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create descriptor object"));
                return result;
            }
        }
        if (oneFailed) {
            result.setStatus(1);
        } else if (oneWarning) {
            result.setStatus(2);
        } else {
            this.addErrorDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB] :  {0} ejb refernce is verified", new Object[]{ejbName, jndiName}));
        }
        return result;
    }
}

