/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.transaction.TransactionImport;
import java.rmi.RemoteException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;

public class TransactionManagerHelper
implements TransactionManager,
TransactionImport {
    private static TransactionManagerHelper tmHelper = new TransactionManagerHelper();

    public void begin() throws NotSupportedException, SystemException {
        this.getTransactionManagerImpl().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getTransactionManagerImpl().commit();
    }

    public int getStatus() throws SystemException {
        return this.getTransactionManagerImpl().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.getTransactionManagerImpl().getTransaction();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.getTransactionManagerImpl().resume(tobj);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getTransactionManagerImpl().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransactionManagerImpl().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getTransactionManagerImpl().setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        return this.getTransactionManagerImpl().suspend();
    }

    public static TransactionManager getTransactionManager() {
        return tmHelper;
    }

    public void recreate(Xid xid, long timeout) {
        J2EETransactionManager tm = this.getTransactionManagerImpl();
        try {
            tm.recreate(xid, timeout);
        }
        catch (WorkException ex) {
            throw new IllegalStateException(ex);
        }
        this.servletPreInvokeTx();
    }

    public void release(Xid xid) {
        Object rethrow = null;
        J2EETransactionManager tm = this.getTransactionManagerImpl();
        this.servletPostInvokeTx(false);
        try {
            tm.release(xid);
        }
        catch (WorkException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (tm instanceof J2EETransactionManagerOpt) {
                ((J2EETransactionManagerOpt)tm).clearThreadTx();
            }
            if (rethrow != null) {
                throw rethrow;
            }
        }
    }

    public XATerminator getXATerminator() {
        return this.getTransactionManagerImpl().getXATerminator();
    }

    public void servletPreInvokeTx() {
        ComponentInvocation inv = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
        if (inv != null && inv.getInvocationType() == 0) {
            try {
                this.getTransactionManagerImpl().enlistComponentResources();
            }
            catch (RemoteException re) {
                throw new IllegalStateException(re);
            }
        }
    }

    public void servletPostInvokeTx(boolean suspend) {
        ComponentInvocation inv = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
        if (inv != null && inv.getInvocationType() == 0) {
            try {
                this.getTransactionManagerImpl().delistComponentResources(suspend);
            }
            catch (RemoteException re) {
                throw new IllegalStateException(re);
            }
            finally {
                inv.setTransaction(null);
            }
        }
    }

    public int getTransactionRemainingTimeout() throws SystemException {
        int timeout = 0;
        Transaction txn = this.getTransaction();
        if (txn == null) {
            throw new IllegalStateException("no current transaction");
        }
        if (txn instanceof J2EETransaction) {
            timeout = ((J2EETransaction)txn).getRemainingTimeout();
        }
        return timeout;
    }

    private J2EETransactionManager getTransactionManagerImpl() {
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        if (tm != null) {
            return tm;
        }
        new UserTransactionImpl();
        tm = Switch.getSwitch().getTransactionManager();
        return tm;
    }
}

