/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class StreamFlusher
extends Thread {
    private InputStream _input = null;
    private OutputStream _output = null;
    private String _logFile = null;

    public StreamFlusher(InputStream input, OutputStream output) {
        this(input, output, null);
    }

    public StreamFlusher(InputStream input, OutputStream output, String logFile) {
        this._input = input;
        this._output = output;
        this._logFile = logFile;
    }

    public void run() {
        if (this._input == null) {
            return;
        }
        PrintStream printStream = null;
        if (this._logFile != null) {
            try {
                if (this.createFileStructure(this._logFile)) {
                    printStream = new PrintStream(new FileOutputStream(this._logFile, true), true);
                } else {
                    this._logFile = null;
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
                this._logFile = null;
            }
        }
        try {
            int byteCnt = 0;
            byte[] buffer = new byte[4096];
            while ((byteCnt = this._input.read(buffer)) != -1) {
                if (this._output != null && byteCnt > 0) {
                    this._output.write(buffer, 0, byteCnt);
                    this._output.flush();
                    if (this._logFile != null) {
                        printStream.write(buffer, 0, byteCnt);
                        printStream.flush();
                    }
                }
                StreamFlusher.yield();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean createFileStructure(String logFile) {
        boolean bRet = false;
        File outputFile = new File(logFile);
        try {
            File parentFile = new File(outputFile.getParent());
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            if (outputFile.canWrite()) {
                bRet = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bRet;
    }
}

