/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.comet;

import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.TaskBase;
import com.sun.enterprise.web.connector.grizzly.comet.CometEvent;
import com.sun.enterprise.web.connector.grizzly.comet.CometHandler;
import com.sun.enterprise.web.connector.grizzly.comet.NotificationHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNotificationHandler
implements NotificationHandler {
    protected Pipeline pipeline;
    protected boolean blockingNotification = false;

    protected void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public boolean isBlockingNotification() {
        return this.blockingNotification;
    }

    @Override
    public void setBlockingNotification(boolean blockingNotification) {
        this.blockingNotification = blockingNotification;
    }

    @Override
    public void notify(final CometEvent cometEvent, final Iterator<CometHandler> iteratorHandlers) throws IOException {
        if (this.blockingNotification || this.pipeline == null) {
            this.notify0(cometEvent, iteratorHandlers);
        } else {
            this.pipeline.addTask(new TaskBase(){

                public void doTask() throws IOException {
                    DefaultNotificationHandler.this.notify0(cometEvent, iteratorHandlers);
                }
            });
        }
    }

    protected void notify0(CometEvent cometEvent, Iterator<CometHandler> iteratorHandlers) throws IOException {
        ArrayList<Throwable> exceptions = null;
        while (iteratorHandlers.hasNext()) {
            try {
                this.notify0(cometEvent, iteratorHandlers.next());
            }
            catch (Throwable ex) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Throwable>();
                }
                exceptions.add(ex);
            }
        }
        if (exceptions != null) {
            StringBuffer errorMsg = new StringBuffer();
            for (Throwable t : exceptions) {
                errorMsg.append(t.getMessage());
            }
            throw new IOException(errorMsg.toString());
        }
    }

    @Override
    public void notify(final CometEvent cometEvent, final CometHandler cometHandler) throws IOException {
        if (this.blockingNotification || this.pipeline == null) {
            this.notify0(cometEvent, cometHandler);
        } else {
            final ArrayList exceptions = new ArrayList();
            this.pipeline.addTask(new TaskBase(){

                public void doTask() throws IOException {
                    try {
                        DefaultNotificationHandler.this.notify0(cometEvent, cometHandler);
                    }
                    catch (Throwable ex) {
                        exceptions.add(ex);
                    }
                    if (exceptions.size() > 0) {
                        StringBuffer errorMsg = new StringBuffer();
                        for (Throwable t : exceptions) {
                            errorMsg.append(t.getMessage());
                        }
                        throw new IOException(errorMsg.toString());
                    }
                }
            });
        }
    }

    protected void notify0(CometEvent cometEvent, CometHandler cometHandler) throws IOException {
        switch (cometEvent.getType()) {
            case 0: {
                cometHandler.onInterrupt(cometEvent);
                break;
            }
            case 1: {
                cometHandler.onEvent(cometEvent);
                break;
            }
            case 4: {
                cometHandler.onEvent(cometEvent);
                break;
            }
            case 5: {
                cometHandler.onEvent(cometEvent);
                break;
            }
            case 2: {
                cometHandler.onInitialize(cometEvent);
                break;
            }
            case 3: {
                cometHandler.onTerminate(cometEvent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

