/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class StatsUtil {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");

    static Object getStatistic(MBeanServer server, ObjectName on, String attrName) {
        Object resultObj = null;
        try {
            resultObj = server.getAttribute(on, attrName);
        }
        catch (Throwable t) {
            String msg = _logger.getResourceBundle().getString("webcontainer.mbeanQueryError");
            msg = MessageFormat.format(msg, attrName, on);
            _logger.log(Level.WARNING, msg, t);
        }
        return resultObj;
    }

    static int getConstant(MBeanServer server, ObjectName on, String attrName) {
        int result = 0;
        Iterator<ObjectName> iter = server.queryNames(on, null).iterator();
        if (iter.hasNext()) {
            Object obj = StatsUtil.getStatistic(server, iter.next(), attrName);
            result = StatsUtil.getIntValue(obj);
        }
        return result;
    }

    static int getAggregateStatistic(MBeanServer server, ObjectName on, String attrName) {
        int result = 0;
        Iterator<ObjectName> iter = server.queryNames(on, null).iterator();
        while (iter.hasNext()) {
            Object obj = StatsUtil.getStatistic(server, iter.next(), attrName);
            if (obj == null) continue;
            result += StatsUtil.getIntValue(obj);
        }
        return result;
    }

    static long getAggregateLongStatistic(MBeanServer server, ObjectName on, String attrName) {
        long result = 0L;
        Iterator<ObjectName> iter = server.queryNames(on, null).iterator();
        while (iter.hasNext()) {
            Object obj = StatsUtil.getStatistic(server, iter.next(), attrName);
            if (obj == null) continue;
            result += StatsUtil.getLongValue(obj);
        }
        return result;
    }

    static int getMaxStatistic(MBeanServer server, ObjectName on, String attrName) {
        int max = 0;
        Iterator<ObjectName> iter = server.queryNames(on, null).iterator();
        while (iter.hasNext()) {
            Object obj = StatsUtil.getStatistic(server, iter.next(), attrName);
            int result = StatsUtil.getIntValue(obj);
            if (result <= max) continue;
            max = result;
        }
        return max;
    }

    static int getAverageStatistic(MBeanServer server, ObjectName on, String attrName) {
        int total = 0;
        int num = 0;
        Iterator<ObjectName> iter = server.queryNames(on, null).iterator();
        while (iter.hasNext()) {
            Object obj = StatsUtil.getStatistic(server, iter.next(), attrName);
            if (obj == null) continue;
            total += StatsUtil.getIntValue(obj);
            ++num;
        }
        return total / num;
    }

    static int getIntValue(Object resultObj) {
        int result = 0;
        if (resultObj instanceof Integer) {
            Integer countObj = (Integer)resultObj;
            result = countObj;
        }
        return result;
    }

    static long getLongValue(Object resultObj) {
        long result = 0L;
        if (resultObj instanceof Long) {
            result = (Long)resultObj;
        } else if (resultObj instanceof Integer) {
            result = ((Integer)resultObj).intValue();
        }
        return result;
    }

    static long getMaxLongStatistic(MBeanServer server, ObjectName on, String attrName) {
        long max = 0L;
        Iterator<ObjectName> iter = server.queryNames(on, null).iterator();
        while (iter.hasNext()) {
            Object obj = StatsUtil.getStatistic(server, iter.next(), attrName);
            long result = StatsUtil.getLongValue(obj);
            if (result <= max) continue;
            max = result;
        }
        return max;
    }
}

