/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.webservice.SOAPMessageContextImpl;
import com.sun.enterprise.webservice.ServiceEngineUtil;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.HttpResponseInfoImpl;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.enterprise.webservice.monitoring.ThreadLocalInfo;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitoringPipe
extends AbstractFilterPipeImpl {
    private final SEIModel seiModel;
    private final WSDLPort wsdlModel;
    private final WSEndpoint owner;
    private final WebServiceEndpoint endpoint;
    private final WebServiceEngineImpl wsEngine;

    public MonitoringPipe(ServerPipeAssemblerContext ctxt, Pipe tail, WebServiceEndpoint ep) {
        super(tail);
        this.endpoint = ep;
        this.seiModel = ctxt.getSEIModel();
        this.wsdlModel = ctxt.getWsdlModel();
        this.owner = ctxt.getEndpoint();
        this.wsEngine = WebServiceEngineImpl.getInstance();
    }

    public MonitoringPipe(MonitoringPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.endpoint = that.endpoint;
        this.seiModel = that.seiModel;
        this.wsdlModel = that.wsdlModel;
        this.owner = that.owner;
        this.wsEngine = WebServiceEngineImpl.getInstance();
    }

    public final Pipe copy(PipeCloner cloner) {
        return new MonitoringPipe(this, cloner);
    }

    public Packet process(Packet request) {
        Endpoint endpt;
        if (ServiceEngineUtil.isJBIRequest(request.webServiceContextDelegate.getClass().getName())) {
            return this.next.process(request);
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            return this.next.process(request);
        }
        SOAPMessageContextImpl ctxt = new SOAPMessageContextImpl(request);
        HttpServletRequest httpRequest = (HttpServletRequest)request.get((Object)"javax.xml.ws.servlet.request");
        HttpServletResponse httpResponse = (HttpServletResponse)request.get((Object)"javax.xml.ws.servlet.response");
        String messageId = null;
        if (this.wsEngine.getGlobalMessageListener() != null && (messageId = this.wsEngine.preProcessRequest(endpt = this.endpoint.implementedByWebComponent() ? this.wsEngine.getEndpoint(httpRequest.getServletPath()) : this.wsEngine.getEndpoint(httpRequest.getRequestURI()))) != null) {
            ctxt.put("MONITORING_MESSAGE_ID", messageId);
            ThreadLocalInfo config = new ThreadLocalInfo(messageId, httpRequest);
            this.wsEngine.getThreadLocal().set(config);
        }
        endpt = null;
        try {
            if (this.wsEngine.getGlobalMessageListener() != null) {
                endpt = this.endpoint.implementedByWebComponent() ? (JAXWSEndpointImpl)this.wsEngine.getEndpoint(httpRequest.getServletPath()) : (JAXWSEndpointImpl)this.wsEngine.getEndpoint(httpRequest.getRequestURI());
                ((JAXWSEndpointImpl)endpt).processRequest(ctxt);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Packet pipeResponse = this.next.process(request);
        ctxt.setPacket(pipeResponse);
        try {
            if (endpt != null) {
                ((JAXWSEndpointImpl)endpt).processResponse(ctxt);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (messageId != null) {
            HttpResponseInfoImpl info = new HttpResponseInfoImpl(httpResponse);
            this.wsEngine.postProcessResponse(messageId, info);
        }
        return pipeResponse;
    }
}

