/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class DMManagedConnectionFactory
extends ManagedConnectionFactory {
    Properties props;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private boolean debug = false;

    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        try {
            Thread.currentThread().getContextClassLoader().loadClass(this.spec.getDetail(20));
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_cnfe", cnfe);
            throw new ResourceException("The driver could not be loaded: " + this.spec.getDetail(20));
        }
        Connection dsConn = null;
        Properties driverProps = this.getPropertiesObj();
        try {
            if (cxRequestInfo != null) {
                driverProps.setProperty("user", pc.getUserName());
                driverProps.setProperty("password", new String(pc.getPassword()));
            }
            dsConn = DriverManager.getConnection(this.spec.getDetail(3), driverProps);
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_create_mc", sqle);
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage());
        }
        ManagedConnection mc = this.constructManagedConnection(null, dsConn, pc, this);
        this.setIsolation(mc);
        this.isValid(mc);
        return mc;
    }

    private Properties getPropertiesObj() throws ResourceException {
        if (this.props != null) {
            return this.props;
        }
        this.props = new Properties();
        this.props.setProperty("user", this.getUser());
        this.props.setProperty("password", this.getPassword());
        String driverProps = this.spec.getDetail(19);
        String delimiter = this.spec.getDetail(21);
        if (driverProps != null && !driverProps.trim().equals("")) {
            if (delimiter == null || delimiter.equals("")) {
                throw new ResourceException("Invalid driver properties string - delimiter not properly set!!");
            }
            StringTokenizer st = new StringTokenizer(driverProps, delimiter);
            while (st.hasMoreTokens()) {
                String value;
                String key;
                block16: {
                    int indexOfEqualsSign;
                    String keyValuePair;
                    block15: {
                        block14: {
                            keyValuePair = null;
                            try {
                                keyValuePair = st.nextToken();
                            }
                            catch (NoSuchElementException nsee) {
                                throw new ResourceException("Invalid driver properties string - Key value pair not available: " + nsee.getMessage());
                            }
                            indexOfEqualsSign = -1;
                            try {
                                indexOfEqualsSign = keyValuePair.indexOf("=");
                                if (indexOfEqualsSign == -1) {
                                    throw new ResourceException("Invalid driver properties string - Key value pair should be of the form key = value");
                                }
                            }
                            catch (NullPointerException npe) {
                                if (!this.debug) break block14;
                                _logger.log(Level.FINE, "jdbc.exc_caught_ign", npe.getMessage());
                            }
                        }
                        key = null;
                        try {
                            key = keyValuePair.substring(0, indexOfEqualsSign).trim();
                        }
                        catch (IndexOutOfBoundsException iobe) {
                            if (!this.debug) break block15;
                            _logger.log(Level.FINE, "jdbc.exc_caught_ign", iobe.getMessage());
                        }
                    }
                    if (key.equals("")) {
                        throw new ResourceException("Invalid driver properties string - Key cannot be an empty string");
                    }
                    value = null;
                    try {
                        value = keyValuePair.substring(indexOfEqualsSign + 1).trim();
                    }
                    catch (IndexOutOfBoundsException iobe) {
                        if (!this.debug) break block16;
                        _logger.log(Level.FINE, "jdbc.exc_caught_ign", iobe.getMessage());
                    }
                }
                this.props.setProperty(key, value);
            }
        }
        return this.props;
    }

    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof DMManagedConnectionFactory) {
            DMManagedConnectionFactory otherMCF = (DMManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    public void setLoginTimeOut(String loginTimeOut) {
        block2: {
            int timeOut = 0;
            try {
                timeOut = Integer.valueOf(loginTimeOut);
                DriverManager.setLoginTimeout(timeOut);
                this.spec.setDetail(4, loginTimeOut);
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                _logger.log(Level.FINE, "jdbc.exc_caught_ign", e.getMessage());
            }
        }
    }

    public void setConnectionURL(String url) {
        this.spec.setDetail(3, url);
    }

    public String getConnectionURL() {
        return this.spec.getDetail(3);
    }

    public Object getDataSource() throws ResourceException {
        return null;
    }
}

