/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import java.io.IOException;
import java.io.PrintStream;
import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.tomcat.util.log.CaptureLog;

public class SystemLogHandler
extends PrintStream {
    protected PrintStream out = null;
    protected static final ThreadLocal logs = new ThreadLocal();
    protected static final Stack reuse = new Stack();

    public SystemLogHandler(PrintStream wrapped) {
        super(wrapped);
        this.out = wrapped;
    }

    public static void startCapture() {
        Stack<CaptureLog> stack;
        CaptureLog log = null;
        if (!reuse.isEmpty()) {
            try {
                log = (CaptureLog)reuse.pop();
            }
            catch (EmptyStackException e) {
                log = new CaptureLog();
            }
        } else {
            log = new CaptureLog();
        }
        if ((stack = (Stack<CaptureLog>)logs.get()) == null) {
            stack = new Stack<CaptureLog>();
            logs.set(stack);
        }
        stack.push(log);
    }

    public static String stopCapture() {
        Stack stack = (Stack)logs.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        CaptureLog log = (CaptureLog)stack.pop();
        if (log == null) {
            return null;
        }
        String capture = log.getCapture();
        log.reset();
        reuse.push(log);
        return capture;
    }

    protected PrintStream findStream() {
        PrintStream ps;
        CaptureLog log;
        Stack stack = (Stack)logs.get();
        if (stack != null && !stack.isEmpty() && (log = (CaptureLog)stack.peek()) != null && (ps = log.getStream()) != null) {
            return ps;
        }
        return this.out;
    }

    public void flush() {
        this.findStream().flush();
    }

    public void close() {
        this.findStream().close();
    }

    public boolean checkError() {
        return this.findStream().checkError();
    }

    protected void setError() {
    }

    public void write(int b) {
        this.findStream().write(b);
    }

    public void write(byte[] b) throws IOException {
        this.findStream().write(b);
    }

    public void write(byte[] buf, int off, int len) {
        this.findStream().write(buf, off, len);
    }

    public void print(boolean b) {
        this.findStream().print(b);
    }

    public void print(char c) {
        this.findStream().print(c);
    }

    public void print(int i) {
        this.findStream().print(i);
    }

    public void print(long l) {
        this.findStream().print(l);
    }

    public void print(float f) {
        this.findStream().print(f);
    }

    public void print(double d) {
        this.findStream().print(d);
    }

    public void print(char[] s) {
        this.findStream().print(s);
    }

    public void print(String s) {
        this.findStream().print(s);
    }

    public void print(Object obj) {
        this.findStream().print(obj);
    }

    public void println() {
        this.findStream().println();
    }

    public void println(boolean x) {
        this.findStream().println(x);
    }

    public void println(char x) {
        this.findStream().println(x);
    }

    public void println(int x) {
        this.findStream().println(x);
    }

    public void println(long x) {
        this.findStream().println(x);
    }

    public void println(float x) {
        this.findStream().println(x);
    }

    public void println(double x) {
        this.findStream().println(x);
    }

    public void println(char[] x) {
        this.findStream().println(x);
    }

    public void println(String x) {
        this.findStream().println(x);
    }

    public void println(Object x) {
        this.findStream().println(x);
    }
}

