/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.Util;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;

public abstract class Generator
implements sun.rmi.rmic.Generator,
Constants {
    protected boolean alwaysGenerate = false;
    protected BatchEnvironment env = null;
    protected ContextStack contextStack = null;
    private boolean trace = false;
    protected boolean idl = false;

    public boolean parseArgs(String[] argv, Main main) {
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i] == null) continue;
            if (argv[i].equalsIgnoreCase("-always") || argv[i].equalsIgnoreCase("-alwaysGenerate")) {
                this.alwaysGenerate = true;
                argv[i] = null;
                continue;
            }
            if (!argv[i].equalsIgnoreCase("-xtrace")) continue;
            this.trace = true;
            argv[i] = null;
        }
        return true;
    }

    protected abstract boolean parseNonConforming(ContextStack var1);

    protected abstract CompoundType getTopType(ClassDefinition var1, ContextStack var2);

    protected abstract OutputType[] getOutputTypesFor(CompoundType var1, HashSet var2);

    protected abstract String getFileNameExtensionFor(OutputType var1);

    protected abstract void writeOutputFor(OutputType var1, HashSet var2, IndentingWriter var3) throws IOException;

    protected abstract boolean requireNewInstance();

    public boolean requiresGeneration(File target, Type theType) {
        boolean result = this.alwaysGenerate;
        if (!result) {
            String className;
            ClassPath path = this.env.getClassPath();
            ClassFile baseFile = path.getFile((className = theType.getQualifiedName().replace('.', File.separatorChar)) + ".source");
            if (baseFile == null) {
                baseFile = path.getFile(className + ".class");
            }
            if (baseFile != null) {
                long targetFileMod;
                long baseFileMod = baseFile.lastModified();
                String targetName = IDLNames.replace(target.getName(), ".java", ".class");
                String parentPath = target.getParent();
                File targetFile = new File(parentPath, targetName);
                result = targetFile.exists() ? (targetFileMod = targetFile.lastModified()) < baseFileMod : true;
            } else {
                result = true;
            }
        }
        return result;
    }

    protected Generator newInstance() {
        Generator result = null;
        try {
            result = (Generator)this.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected Generator() {
    }

    public void generate(sun.rmi.rmic.BatchEnvironment env, ClassDefinition cdef, File destDir) {
        this.env = (BatchEnvironment)env;
        this.contextStack = new ContextStack(this.env);
        this.contextStack.setTrace(this.trace);
        this.env.setParseNonConforming(this.parseNonConforming(this.contextStack));
        CompoundType topType = this.getTopType(cdef, this.contextStack);
        if (topType != null) {
            Generator generator = this;
            if (this.requireNewInstance()) {
                generator = this.newInstance();
            }
            generator.generateOutputFiles(topType, this.env, destDir);
        }
    }

    protected void generateOutputFiles(CompoundType topType, BatchEnvironment env, File destDir) {
        HashSet alreadyChecked = env.alreadyChecked;
        OutputType[] types = this.getOutputTypesFor(topType, alreadyChecked);
        for (int i = 0; i < types.length; ++i) {
            OutputType current = types[i];
            String className = current.getName();
            File file = this.getFileFor(current, destDir);
            boolean sourceFile = false;
            if (this.requiresGeneration(file, current.getType())) {
                if (file.getName().endsWith(".java") && (sourceFile = this.compileJavaSourceFile(current))) {
                    env.addGeneratedFile(file);
                }
                try {
                    IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)), 4, Integer.MAX_VALUE);
                    long startTime = 0L;
                    if (env.verbose()) {
                        startTime = System.currentTimeMillis();
                    }
                    this.writeOutputFor(types[i], alreadyChecked, out);
                    out.close();
                    if (env.verbose()) {
                        long duration = System.currentTimeMillis() - startTime;
                        env.output(Main.getText("rmic.generated", file.getPath(), Long.toString(duration)));
                    }
                    if (!sourceFile) continue;
                    env.parseFile(new ClassFile(file));
                    continue;
                }
                catch (IOException e) {
                    env.error(0L, "cant.write", file.toString());
                    return;
                }
            }
            if (!env.verbose()) continue;
            env.output(Main.getText("rmic.previously.generated", file.getPath()));
        }
    }

    protected File getFileFor(OutputType outputType, File destinationDir) {
        Identifier id = this.getOutputId(outputType);
        File packageDir = null;
        packageDir = this.idl ? Util.getOutputDirectoryForIDL(id, destinationDir, this.env) : Util.getOutputDirectoryForStub(id, destinationDir, this.env);
        String classFileName = outputType.getName() + this.getFileNameExtensionFor(outputType);
        return new File(packageDir, classFileName);
    }

    protected Identifier getOutputId(OutputType outputType) {
        return outputType.getType().getIdentifier();
    }

    protected boolean compileJavaSourceFile(OutputType outputType) {
        return true;
    }

    public class OutputType {
        private String name;
        private Type type;

        public OutputType(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

