/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors.handler;

import com.sun.jsftemplating.layout.descriptors.handler.ApplicationAttributeOutputType;
import com.sun.jsftemplating.layout.descriptors.handler.OutputType;
import com.sun.jsftemplating.layout.descriptors.handler.PageAttributeOutputType;
import com.sun.jsftemplating.layout.descriptors.handler.RequestAttributeOutputType;
import com.sun.jsftemplating.layout.descriptors.handler.SessionAttributeOutputType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputTypeManager {
    private static Map<String, OutputType> _outputTypes = new HashMap<String, OutputType>(8);
    private static Map<String, OutputTypeManager> _instances = new HashMap<String, OutputTypeManager>(2);
    private static OutputTypeManager _defaultInstance = new OutputTypeManager();
    public static final String OUTPUT_TYPE_MANAGER_KEY = "outputTypeManagerImpl";
    public static final String REQUEST_ATTRIBUTE_TYPE = "attribute";
    public static final String PAGE_ATTRIBUTE_TYPE = "page";
    public static final String PAGE_ATTRIBUTE_TYPE2 = "pageSession";
    public static final String SESSION_ATTRIBUTE_TYPE = "session";
    public static final String APP_ATTRIBUTE_TYPE = "application";

    protected OutputTypeManager() {
    }

    public static OutputTypeManager getInstance() {
        return _defaultInstance;
    }

    public static OutputTypeManager getManager(FacesContext context) {
        if (context == null) {
            return _defaultInstance;
        }
        String className = null;
        Map initParams = context.getExternalContext().getInitParameterMap();
        if (initParams.containsKey(OUTPUT_TYPE_MANAGER_KEY)) {
            className = (String)initParams.get(OUTPUT_TYPE_MANAGER_KEY);
        }
        return OutputTypeManager.getManager(className);
    }

    public static OutputTypeManager getManager(String className) {
        if (className == null) {
            return _defaultInstance;
        }
        OutputTypeManager ldm = _instances.get(className);
        if (ldm == null) {
            try {
                ldm = (OutputTypeManager)Class.forName(className).getMethod("getInstance", null).invoke((Object)null, (Object[])null);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            catch (NullPointerException ex) {
                throw new RuntimeException(ex);
            }
            catch (ClassCastException ex) {
                throw new RuntimeException(ex);
            }
            _instances.put(className, ldm);
        }
        return ldm;
    }

    public List<OutputType> getOutputTypes() {
        return new ArrayList<OutputType>(_outputTypes.values());
    }

    public OutputType getOutputType(String name) {
        return _outputTypes.get(name);
    }

    public void setOutputType(String name, OutputType outputType) {
        _outputTypes.put(name, outputType);
    }

    static {
        _outputTypes.put(REQUEST_ATTRIBUTE_TYPE, new RequestAttributeOutputType());
        PageAttributeOutputType pageType = new PageAttributeOutputType();
        _outputTypes.put(PAGE_ATTRIBUTE_TYPE, pageType);
        _outputTypes.put(PAGE_ATTRIBUTE_TYPE2, pageType);
        _outputTypes.put(SESSION_ATTRIBUTE_TYPE, new SessionAttributeOutputType());
        _outputTypes.put(APP_ATTRIBUTE_TYPE, new ApplicationAttributeOutputType());
    }
}

