/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.template;

import com.sun.jsftemplating.layout.SyntaxException;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutStaticText;
import com.sun.jsftemplating.layout.template.CustomParserCommand;
import com.sun.jsftemplating.layout.template.ProcessingContext;
import com.sun.jsftemplating.layout.template.ProcessingContextEnvironment;
import com.sun.jsftemplating.layout.template.TemplateParser;
import com.sun.jsftemplating.layout.template.TemplateReader;
import com.sun.jsftemplating.util.LayoutElementUtil;
import com.sun.jsftemplating.util.Util;
import java.io.IOException;

public class BaseProcessingContext
implements ProcessingContext {
    public void beginComponent(ProcessingContextEnvironment env, String content) throws IOException {
        TemplateReader reader = env.getReader();
        TemplateParser parser = reader.getTemplateParser();
        parser.skipCommentsAndWhiteSpace(" \t\r\n");
        LayoutElement parent = env.getParent();
        LayoutComponent child = reader.createLayoutComponent(parent, env.isNested(), content);
        parent.addChildLayoutElement(child);
        boolean single = false;
        int ch = parser.nextChar();
        if (ch == 47) {
            ch = parser.nextChar();
            single = true;
            reader.popTag();
        }
        if (ch != 62) {
            throw new SyntaxException("Expected '>' found '" + (char)ch + "'.");
        }
        if (single) {
            this.endComponent(env, content);
        } else {
            reader.process(TemplateReader.LAYOUT_COMPONENT_CONTEXT, child, true);
        }
    }

    public void endComponent(ProcessingContextEnvironment env, String content) throws IOException {
    }

    public void beginSpecial(ProcessingContextEnvironment env, String content) throws IOException {
        CustomParserCommand command = TemplateReader.getCustomParserCommand(content);
        if (command == null) {
            command = TemplateReader.EVENT_PARSER_COMMAND;
        }
        command.process(this, env, content);
    }

    public void endSpecial(ProcessingContextEnvironment env, String content) throws IOException {
    }

    public void staticText(ProcessingContextEnvironment env, String content) throws IOException {
        LayoutElement parent = env.getParent();
        LayoutStaticText child = new LayoutStaticText(parent, LayoutElementUtil.getGeneratedId("txt", env.getReader().getNextIdNumber()), content);
        child.addOption("value", content);
        child.setNested(env.isNested());
        TemplateReader.checkForFacetChild(parent, child);
        parent.addChildLayoutElement(child);
    }

    public void escapedStaticText(ProcessingContextEnvironment env, String content) throws IOException {
        this.staticText(env, Util.htmlEscape(content));
    }

    public void handleDefault(ProcessingContextEnvironment env, String content) throws IOException {
        env.getReader().getTemplateParser().nextChar();
    }
}

