/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.faces.context.FacesContext;

public class FileUtil {
    private static final Class[] REALPATH_ARGS = new Class[]{String.class};
    private static final Class[] GET_RES_ARGS = new Class[]{String.class};

    public static String getRealPath(Object ctx, String relativePath) {
        String path = null;
        Method method = null;
        try {
            method = ctx.getClass().getMethod("getRealPath", REALPATH_ARGS);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        try {
            path = (String)method.invoke(ctx, relativePath);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return path;
    }

    public static URL getResource(String relPath) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        Object ctx = facesContext.getExternalContext().getContext();
        URL url = null;
        Method method = null;
        try {
            method = ctx.getClass().getMethod("getResource", GET_RES_ARGS);
        }
        catch (NoSuchMethodException ex) {
            throw new LayoutDefinitionException("Unable to find 'getResource' method in this environment!", ex);
        }
        try {
            url = (URL)method.invoke(ctx, "/" + relPath);
        }
        catch (IllegalAccessException ex) {
            throw new LayoutDefinitionException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new LayoutDefinitionException(ex);
        }
        return url;
    }

    public static URL searchForFile(String relPath, String defSuff) {
        ClassLoader loader;
        while (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        URL url = FileUtil.getResource(relPath);
        if (url == null && (url = (loader = Util.getClassLoader(relPath)).getResource(relPath)) == null && (url = loader.getResource("/" + relPath)) == null && (url = loader.getResource("META-INF/" + relPath)) == null && defSuff != null) {
            int idx = relPath.lastIndexOf(46);
            if (idx != -1) {
                String ext = relPath.substring(idx);
                if (!ext.equalsIgnoreCase(defSuff)) {
                    return FileUtil.searchForFile(relPath.substring(0, idx) + defSuff, null);
                }
            } else {
                return FileUtil.searchForFile(relPath + defSuff, null);
            }
        }
        return url;
    }
}

