/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.sourcemodel;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.ws.policy.sourcemodel.PolicyReferenceData;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModelContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicySourceModel
implements Cloneable {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicySourceModel.class);
    private static final Map<String, String> defaultNamespaceToPrefixMap = new HashMap<String, String>();
    private ModelNode rootNode;
    private String policyId;
    private String policyName;
    private final List<ModelNode> references = new LinkedList<ModelNode>();
    private boolean expanded = false;

    public static PolicySourceModel createPolicySourceModel() {
        return new PolicySourceModel();
    }

    public static PolicySourceModel createPolicySourceModel(String policyId, String policyName) {
        return new PolicySourceModel(policyId, policyName);
    }

    private PolicySourceModel() {
        this.rootNode = ModelNode.createRootPolicyNode(this);
    }

    private PolicySourceModel(String policyId, String policyName) {
        this();
        this.policyId = policyId;
        this.policyName = policyName;
    }

    public ModelNode getRootNode() {
        return this.rootNode;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    Map<String, String> getNamespaceToPrefixMapping() {
        HashMap<String, String> nsToPrefixMap = new HashMap<String, String>();
        Collection<String> namespaces = this.getUsedNamespaces();
        for (String namespace : namespaces) {
            String prefix = this.getDefaultPrefix(namespace);
            if (prefix == null) continue;
            nsToPrefixMap.put(namespace, prefix);
        }
        return nsToPrefixMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolicySourceModel)) {
            return false;
        }
        boolean result = true;
        PolicySourceModel that = (PolicySourceModel)obj;
        boolean bl = result && (this.policyId == null ? that.policyId == null : this.policyId.equals(that.policyId)) ? true : (result = false);
        result = result && (this.policyName == null ? that.policyName == null : this.policyName.equals(that.policyName));
        result = result && this.rootNode.equals(that.rootNode);
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.policyId == null ? 0 : this.policyId.hashCode());
        result = 37 * result + (this.policyName == null ? 0 : this.policyName.hashCode());
        result = 37 * result + this.rootNode.hashCode();
        return result;
    }

    public String toString() {
        String innerIndent = PolicyUtils.Text.createIndent(1);
        StringBuffer buffer = new StringBuffer(60);
        buffer.append("Policy source model {").append(PolicyUtils.Text.NEW_LINE);
        buffer.append(innerIndent).append("policy id = '").append(this.policyId).append('\'').append(PolicyUtils.Text.NEW_LINE);
        buffer.append(innerIndent).append("policy name = '").append(this.policyName).append('\'').append(PolicyUtils.Text.NEW_LINE);
        this.rootNode.toString(1, buffer).append(PolicyUtils.Text.NEW_LINE).append('}');
        return buffer.toString();
    }

    protected PolicySourceModel clone() throws CloneNotSupportedException {
        PolicySourceModel clone = (PolicySourceModel)super.clone();
        clone.rootNode = this.rootNode.clone();
        try {
            clone.rootNode.setParentModel(this);
        }
        catch (IllegalAccessException e) {
            throw LOGGER.logSevereException(new CloneNotSupportedException(LocalizationMessages.WSP_0013_UNABLE_TO_SET_PARENT_MODEL_ON_ROOT()), e);
        }
        return clone;
    }

    public boolean containsPolicyReferences() {
        return !this.references.isEmpty();
    }

    private boolean isExpanded() {
        return this.references.isEmpty() || this.expanded;
    }

    public synchronized void expand(PolicySourceModelContext context) throws PolicyException {
        if (!this.isExpanded()) {
            for (ModelNode reference : this.references) {
                PolicyReferenceData refData = reference.getPolicyReferenceData();
                String digest = refData.getDigest();
                PolicySourceModel referencedModel = digest == null ? context.retrieveModel(refData.getReferencedModelUri()) : context.retrieveModel(refData.getReferencedModelUri(), refData.getDigestAlgorithmUri(), digest);
                reference.setReferencedModel(referencedModel);
            }
            this.expanded = true;
        }
    }

    void addNewPolicyReference(ModelNode node) {
        if (node.getType() != ModelNode.Type.POLICY_REFERENCE) {
            throw new IllegalArgumentException(LocalizationMessages.WSP_0042_POLICY_REFERENCE_NODE_EXPECTED_INSTEAD_OF((Object)node.getType()));
        }
        this.references.add(node);
    }

    private Collection<String> getUsedNamespaces() {
        ModelNode processedNode;
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (this.policyId != null) {
            namespaces.add("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        LinkedList<ModelNode> nodesToBeProcessed = new LinkedList<ModelNode>();
        nodesToBeProcessed.add(this.rootNode);
        while ((processedNode = (ModelNode)nodesToBeProcessed.poll()) != null) {
            for (ModelNode child : processedNode.getContent()) {
                if (child.hasChildren()) {
                    nodesToBeProcessed.offer(child);
                }
                if (!child.isAssertionRelatedNode()) continue;
                AssertionData nodeData = child.getNodeData();
                namespaces.add(nodeData.getName().getNamespaceURI());
                if (nodeData.isPrivateAttributeSet()) {
                    namespaces.add("http://java.sun.com/xml/ns/wsit/policy");
                }
                for (Map.Entry<QName, String> attribute : nodeData.getAttributesSet()) {
                    namespaces.add(attribute.getKey().getNamespaceURI());
                }
            }
        }
        return namespaces;
    }

    private String getDefaultPrefix(String namespace) {
        return defaultNamespaceToPrefixMap.get(namespace);
    }

    static {
        defaultNamespaceToPrefixMap.put("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
        defaultNamespaceToPrefixMap.put("http://java.sun.com/xml/ns/wsit/policy", "sunwsp");
        defaultNamespaceToPrefixMap.put("http://java.sun.com/xml/ns/wsit/2006/09/policy/encoding/client", "cenc");
        defaultNamespaceToPrefixMap.put("http://java.sun.com/xml/ns/wsit/2006/09/policy/fastinfoset/service", "fi");
        defaultNamespaceToPrefixMap.put("http://schemas.xmlsoap.org/ws/2005/02/trust", "wst");
        defaultNamespaceToPrefixMap.put("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "sp");
        defaultNamespaceToPrefixMap.put("http://docs.oasis-open.org/wss/2004/01/oasis- 200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        defaultNamespaceToPrefixMap.put("http://schemas.sun.com/2006/03/wss/client", "csp");
        defaultNamespaceToPrefixMap.put("http://schemas.sun.com/2006/03/wss/server", "ssp");
        defaultNamespaceToPrefixMap.put("http://schemas.sun.com/ws/2006/05/trust/client", "ctp");
        defaultNamespaceToPrefixMap.put("http://schemas.sun.com/ws/2006/05/trust/server", "stp");
        defaultNamespaceToPrefixMap.put("http://schemas.sun.com/ws/2006/05/sc/client", "cscp");
        defaultNamespaceToPrefixMap.put("http://schemas.sun.com/ws/2006/05/sc/server", "sscp");
        defaultNamespaceToPrefixMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "wsrmp");
        defaultNamespaceToPrefixMap.put("http://schemas.microsoft.com/net/2005/02/rm/policy", "msrmp");
        defaultNamespaceToPrefixMap.put("http://sun.com/2006/03/rm", "sunrmp");
        defaultNamespaceToPrefixMap.put("http://sun.com/2006/03/rm/client", "sunrmcp");
        defaultNamespaceToPrefixMap.put("http://java.sun.com/xml/ns/wsit/2006/09/policy/soaptcp/service", "soaptcpsvc");
        defaultNamespaceToPrefixMap.put("http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client", "transport");
        defaultNamespaceToPrefixMap.put("http://java.sun.com/xml/ns/wsit/2006/09/policy/soaptcp", "soaptcp");
        defaultNamespaceToPrefixMap.put(AddressingVersion.MEMBER.policyNsUri, "wsap");
        defaultNamespaceToPrefixMap.put(AddressingVersion.MEMBER.nsUri, "wsa");
        defaultNamespaceToPrefixMap.put(AddressingVersion.W3C.policyNsUri, "wsapw3c");
        defaultNamespaceToPrefixMap.put(AddressingVersion.W3C.nsUri, "wsaw3c");
        defaultNamespaceToPrefixMap.put("http://schemas.xmlsoap.org/ws/2004/10/wsat", "wsat");
    }
}

