/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm;

import com.sun.xml.ws.rm.BufferFullException;
import com.sun.xml.ws.rm.DuplicateMessageException;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.Messages;
import com.sun.xml.ws.rm.RMConstants;
import java.util.ArrayList;

public class Sequence {
    protected String id;
    protected ArrayList<Message> list = new ArrayList();
    protected int nextIndex = 1;
    protected boolean last = false;
    protected int maxMessages = -1;
    protected int storedMessages = 0;
    protected long lastActivityTime;
    protected boolean allowDuplicates;
    protected RMConstants rmConstants;
    protected int firstKnownGap;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Sequence() {
        this.list.add(null);
        this.allowDuplicates = false;
        this.firstKnownGap = 1;
        this.resetLastActivityTime();
    }

    public synchronized int getNextIndex() {
        return this.nextIndex;
    }

    public synchronized Message get(int index) throws InvalidMessageNumberException {
        if (index >= this.nextIndex) {
            throw new InvalidMessageNumberException(Messages.INVALID_INDEX_MESSAGE.format(index));
        }
        return this.list.get(index);
    }

    public synchronized int set(int i, Message m) throws InvalidMessageNumberException, BufferFullException, DuplicateMessageException {
        m.setMessageNumber(i);
        m.setSequence(this);
        if (i <= 0) {
            throw new InvalidMessageNumberException();
        }
        if (this.storedMessages == this.maxMessages) {
            throw new BufferFullException(this);
        }
        if (i < this.nextIndex) {
            Message mess = null;
            mess = this.list.get(i);
            if (null != mess && !this.allowDuplicates) {
                throw new DuplicateMessageException(mess);
            }
            this.list.set(i, m);
        } else if (i == this.nextIndex) {
            this.list.add(m);
            ++this.nextIndex;
        } else {
            for (int j = this.nextIndex; j < i; ++j) {
                this.list.add(null);
            }
            this.list.add(m);
            this.nextIndex = i + 1;
        }
        ++this.storedMessages;
        return i;
    }

    public synchronized void setLast() {
        this.last = true;
    }

    public synchronized boolean isLast() {
        return this.last;
    }

    public void resetLastActivityTime() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    protected long getLastActivityTime() {
        return this.lastActivityTime;
    }

    protected boolean isGettingClose(long elapsedTime, long timeLimit) {
        return elapsedTime > timeLimit / 2L;
    }
}

