/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientOutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.Messages;
import com.sun.xml.ws.rm.jaxws.runtime.client.RetryTimer;
import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMSource
extends RMProvider<ClientInboundSequence, ClientOutboundSequence> {
    private static final Logger logger = Logger.getLogger(RMSource.class.getName());
    private static RMSource rmSource = new RMSource();
    private long retryInterval = 2000L;
    private RetryTimer retryTimer = new RetryTimer(this);

    public static RMSource getRMSource() {
        return rmSource;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public synchronized void terminateSequence(ClientOutboundSequence seq) throws RMException {
        String id = seq.getId();
        if (seq != null && this.outboundMap.keySet().contains(id)) {
            seq.disconnect();
            this.removeOutboundSequence(id);
        }
    }

    public synchronized void addOutboundSequence(ClientOutboundSequence seq) {
        logger.fine(Messages.ADDING_SEQUENCE_MESSAGE.format(seq.getId()));
        boolean firstSequence = this.outboundMap.isEmpty();
        this.outboundMap.put(seq.getId(), seq);
        ClientInboundSequence iseq = (ClientInboundSequence)seq.getInboundSequence();
        String iseqid = null;
        if (iseq != null && null != (iseqid = iseq.getId())) {
            this.inboundMap.put(iseqid, iseq);
        }
        if (firstSequence) {
            this.retryTimer.start();
        }
    }

    public synchronized void removeOutboundSequence(ClientOutboundSequence seq) {
        logger.fine(Messages.REMOVING_SEQUENCE_MESSAGE.format(seq.getId()));
        String id = seq.getId();
        ClientInboundSequence iseq = (ClientInboundSequence)seq.getInboundSequence();
        String iseqid = null;
        if (iseq != null && null != (iseqid = iseq.getId())) {
            this.inboundMap.remove(iseqid);
        }
        this.outboundMap.remove(id);
        if (this.outboundMap.isEmpty()) {
            this.retryTimer.stop();
        }
    }

    private void removeOutboundSequence(String id) {
        ClientOutboundSequence seq = (ClientOutboundSequence)this.outboundMap.get(id);
        if (seq == null) {
            String message = Messages.NO_SUCH_OUTBOUND_SEQUENCE.format(id);
            IllegalArgumentException e = new IllegalArgumentException(message);
            logger.log(Level.FINE, message, e);
            throw e;
        }
        this.removeOutboundSequence(seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMaintenanceTasks() throws RMException {
        for (String key : this.outboundMap.keySet()) {
            ClientOutboundSequence seq;
            ClientOutboundSequence clientOutboundSequence = seq = (ClientOutboundSequence)this.getOutboundSequence(key);
            synchronized (clientOutboundSequence) {
                seq.doMaintenanceTasks();
            }
        }
    }

    public ClientOutboundSequence createSequence(Service service, QName portName) {
        Dispatch disp = service.createDispatch(portName, Source.class, Service.Mode.PAYLOAD, new WebServiceFeature[]{new RespectBindingFeature()});
        byte[] bytes = "<sun:createSequence xmlns:sun=\"http://com.sun/createSequence\"/>".getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        StreamSource source = new StreamSource(stream);
        try {
            disp.invoke((Object)source);
        }
        catch (Exception e) {
            // empty catch block
        }
        ClientOutboundSequence seq = (ClientOutboundSequence)disp.getRequestContext().get("com.sun.xml.ws.sequence");
        seq.setService(service);
        return seq;
    }

    public ClientOutboundSequence createSequence(Service service, QName portName, String sequenceID, String companionSequenceID) {
        ClientOutboundSequence seq = this.createSequence(service, portName);
        if (seq == null) {
            return null;
        }
        try {
            seq.disconnect(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        seq.setId(sequenceID);
        ClientInboundSequence iseq = (ClientInboundSequence)seq.getInboundSequence();
        if (companionSequenceID != null) {
            if (iseq == null || iseq.getId() == null) {
                String message = Messages.NO_TWO_WAY_OPERATION.format(new Object[0]);
                IllegalArgumentException e = new IllegalArgumentException(message);
                logger.log(Level.FINE, message, e);
                throw e;
            }
            iseq.setId(companionSequenceID);
        } else if (iseq != null && iseq.getId() != null) {
            String message = Messages.NO_INBOUND_SEQUENCE_ID_SPECIFIED.format(new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(message);
            logger.log(Level.FINE, message, e);
            throw e;
        }
        if (this.outboundMap.get(sequenceID) != null) {
            String message = Messages.SEQUENCE_ALREADY_EXISTS.format(sequenceID);
            IllegalArgumentException e = new IllegalArgumentException(message);
            logger.log(Level.FINE, message, e);
            throw e;
        }
        if (companionSequenceID != null && this.inboundMap.get(companionSequenceID) != null) {
            String message = Messages.SEQUENCE_ALREADY_EXISTS.format(companionSequenceID);
            IllegalArgumentException e = new IllegalArgumentException(message);
            logger.log(Level.FINE, message, e);
            throw e;
        }
        this.addOutboundSequence(seq);
        return seq;
    }
}

