/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.server;

import com.sun.xml.ws.rm.InvalidSequenceException;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerOutboundSequence;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMDestination
extends RMProvider<ServerInboundSequence, ServerOutboundSequence> {
    private static RMDestination rmDestination = new RMDestination();
    private SequenceReaper reaper;

    public static RMDestination getRMDestination() {
        return rmDestination;
    }

    private RMDestination() {
        this.reaper = new SequenceReaper(5000L, this.inboundMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSequence(String id) throws InvalidSequenceException {
        String outid;
        ServerInboundSequence seq = (ServerInboundSequence)this.getInboundSequence(id);
        if (seq == null) {
            throw new InvalidSequenceException(String.format("The message contains an unknown sequence id,  %s ", id), id);
        }
        ServerOutboundSequence out = (ServerOutboundSequence)seq.getOutboundSequence();
        RMDestination rMDestination = this;
        synchronized (rMDestination) {
            if (seq != null) {
                this.inboundMap.remove(id);
            }
            if (this.inboundMap.isEmpty()) {
                this.reaper.stop();
            }
        }
        if (out != null && (outid = out.getId()) != null) {
            this.outboundMap.remove(outid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInboundSequence createSequence(URI acksTo, String inboundId, String outboundId, SequenceConfig config) throws RMException {
        ServerInboundSequence seq = new ServerInboundSequence(acksTo, inboundId, outboundId, config);
        RMDestination rMDestination = this;
        synchronized (rMDestination) {
            this.inboundMap.put(seq.getId(), seq);
            if (this.inboundMap.size() == 1) {
                this.reaper.start();
            }
        }
        ServerOutboundSequence outbound = (ServerOutboundSequence)seq.getOutboundSequence();
        String id = outbound.getId();
        if (id != null) {
            this.outboundMap.put(id, outbound);
        }
        return seq;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SequenceReaper
    extends Timer {
        private long frequency;
        private Map<String, ServerInboundSequence> map;
        private TimerTask timerTask;

        public void start() {
            this.timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    HashSet<String> keysToRemove = new HashSet<String>();
                    for (String key : SequenceReaper.this.map.keySet()) {
                        ServerInboundSequence sis;
                        ServerInboundSequence serverInboundSequence = sis = (ServerInboundSequence)SequenceReaper.this.map.get(key);
                        synchronized (serverInboundSequence) {
                            if (sis.isExpired()) {
                                System.out.println("Terminating expired sequence " + sis.getId());
                                keysToRemove.add(key);
                            }
                        }
                    }
                    for (String str : keysToRemove) {
                        try {
                            RMDestination.this.terminateSequence(str);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            this.schedule(this.timerTask, new Date(System.currentTimeMillis() + this.frequency), this.frequency);
        }

        public void stop() {
            this.timerTask.cancel();
        }

        public SequenceReaper(long frequency, Map<String, ServerInboundSequence> map) {
            super(true);
            this.map = map;
            this.frequency = frequency;
        }
    }
}

