/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Token;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509Token
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.X509Token,
Cloneable,
SecurityAssertionValidator {
    private static QName itQname = new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeToken");
    private String includeToken = Token.INCLUDE_ALWAYS;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private String tokenType = null;
    private HashSet<String> referenceType = null;
    private String id = null;
    private boolean reqDK = false;
    private boolean isServer = false;

    public X509Token() {
        UUID uid = UUID.randomUUID();
        this.id = uid.toString();
        this.referenceType = new HashSet();
    }

    public X509Token(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        UUID uid = UUID.randomUUID();
        this.id = uid.toString();
        this.referenceType = new HashSet();
    }

    public void addTokenReferenceType(String tokenRefType) {
        this.referenceType.add(tokenRefType);
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    @Override
    public Set getTokenRefernceType() {
        this.populate();
        return this.referenceType;
    }

    @Override
    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        this.includeToken = type;
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.reqDK;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(itQname) != null) {
                this.includeToken = this.getAttributeValue(itQname);
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isTokenReferenceType(assertion)) {
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (PolicyUtil.isTokenType(assertion)) {
                    this.tokenType = assertion.getName().getLocalPart();
                    continue;
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion)) {
                    this.reqDK = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "X509Token");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Fix me");
    }
}

