/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.tcp.grizzly.GrizzlyTCPConnector;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.TCPContext;
import com.sun.xml.ws.transport.tcp.server.TCPResourceLoader;
import com.sun.xml.ws.transport.tcp.server.TCPStandaloneContext;
import com.sun.xml.ws.transport.tcp.server.WSTCPConnector;
import com.sun.xml.ws.transport.tcp.server.WSTCPDelegate;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSTCP {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    private static final String JAXWS_RI_RUNTIME = "WEB-INF/sun-jaxws.xml";
    private final TCPContext context;
    private final ClassLoader initClassLoader;
    private WSTCPDelegate delegate;
    private WSTCPConnector connector;
    private final String contextPath;

    public WSTCP(@NotNull TCPContext context, @NotNull ClassLoader initClassLoader, @NotNull String contextPath) {
        this.context = context;
        this.initClassLoader = initClassLoader;
        this.contextPath = contextPath;
    }

    @NotNull
    public List<TCPAdapter> parseDeploymentDescriptor() throws IOException {
        DeploymentDescriptorParser<TCPAdapter> parser = new DeploymentDescriptorParser<TCPAdapter>(this.initClassLoader, new TCPResourceLoader(this.context), null, TCPAdapter.FACTORY);
        URL sunJaxWsXml = this.context.getResource(JAXWS_RI_RUNTIME);
        return parser.parse(sunJaxWsXml.toExternalForm(), sunJaxWsXml.openStream());
    }

    @NotNull
    public WSTCPConnector initialize() throws IOException {
        List<TCPAdapter> adapters = this.parseDeploymentDescriptor();
        this.delegate = new WSTCPDelegate();
        this.delegate.registerAdapters(this.contextPath, adapters);
        TCPAdapter adapter = adapters.get(0);
        URI uri = adapter.getEndpoint().getPort().getAddress().getURI();
        WSTCPURI tcpURI = WSTCPURI.parse(uri);
        GrizzlyTCPConnector connector = new GrizzlyTCPConnector(tcpURI.host, tcpURI.port, this.delegate);
        connector.listen();
        return connector;
    }

    public void process() throws IOException {
        this.connector = this.initialize();
    }

    public void close() {
        if (this.connector != null) {
            this.connector.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println(MessagesMessages.STANDALONE_RUN());
            System.exit(0);
        }
        String contextPath = args[0];
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        TCPStandaloneContext context = new TCPStandaloneContext(classloader);
        WSTCP wsTCP = new WSTCP(context, classloader, contextPath);
        try {
            wsTCP.process();
            System.out.println(MessagesMessages.STANDALONE_EXIT());
            System.in.read();
        }
        catch (Exception e) {
        }
        finally {
            wsTCP.close();
        }
    }
}

