/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.ConvertValue;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;

public class DirectStreamPacket
extends DirectPacket
implements StreamMessage {
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private boolean writePerformed = false;
    private boolean byteArrayReadState = false;
    private ByteArrayInputStream byteArrayFieldInputStream = null;
    private Object notYetProcessedPrimitiveObject = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectStreamPacket";

    public DirectStreamPacket(DirectSession directSession, JMSService jMSService) throws JMSException {
        super(directSession, jMSService);
        if (_logFINE) {
            Object[] objectArray = new Object[]{directSession, jMSService};
            _loggerOC.entering(_className, "constructor()", objectArray);
        }
        this._initializeOutputStreams();
    }

    public DirectStreamPacket(JMSPacket jMSPacket, long l, DirectSession directSession, JMSService jMSService) throws JMSException {
        super(jMSPacket, l, directSession, jMSService);
        this._getMessageBodyFromPacket();
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.messageBody = null;
        this._initializeOutputStreams();
    }

    public boolean readBoolean() throws JMSException {
        Object object = this._readPrimitiveObject("readBoolean()");
        return ConvertValue.toBoolean(object);
    }

    public byte readByte() throws JMSException {
        Object object = this._readPrimitiveObject("readByte()");
        try {
            byte by = ConvertValue.toByte(object);
            return by;
        }
        catch (NumberFormatException numberFormatException) {
            this.notYetProcessedPrimitiveObject = object;
            throw numberFormatException;
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        Object object;
        int n = -1;
        if (this.messageBody == null) {
            this.checkForWriteOnlyMessageBody("readBytes(byte[])");
            return -1;
        }
        if (!this.byteArrayReadState) {
            Object object2 = this._readPrimitiveObject("readBytes(byte[])");
            if (object2 == null) {
                return -1;
            }
            if (!(object2 instanceof byte[])) {
                String string = "Exception:StreamMessage:readBytes():Object read is not byte[]:Actual type=" + object2.getClass().getName();
                throw new MessageFormatException(string);
            }
            object = (byte[])object2;
            if (((byte[])object).length == 0) {
                return 0;
            }
            this.byteArrayFieldInputStream = new ByteArrayInputStream((byte[])object);
            this.byteArrayReadState = true;
        }
        if ((n = this.byteArrayFieldInputStream.read(byArray, 0, byArray.length)) < byArray.length) {
            this.byteArrayReadState = false;
            try {
                this.byteArrayFieldInputStream.close();
                this.byteArrayFieldInputStream = null;
            }
            catch (IOException iOException) {
                object = (Object)new JMSException("Exception:StreamMessage:readBytes()" + iOException.getMessage());
                object.initCause((Throwable)iOException);
                throw object;
            }
        }
        return n;
    }

    public char readChar() throws JMSException {
        Object object = this._readPrimitiveObject("readChar()");
        return ConvertValue.toChar(object);
    }

    public double readDouble() throws JMSException {
        Object object = this._readPrimitiveObject("readDouble()");
        return ConvertValue.toDouble(object);
    }

    public float readFloat() throws JMSException {
        Object object = this._readPrimitiveObject("readFloat()");
        return ConvertValue.toFloat(object);
    }

    public int readInt() throws JMSException {
        Object object = this._readPrimitiveObject("readInt()");
        return ConvertValue.toInt(object);
    }

    public long readLong() throws JMSException {
        Object object = this._readPrimitiveObject("readLong()");
        return ConvertValue.toLong(object);
    }

    public Object readObject() throws JMSException {
        Object object = this._readPrimitiveObject("readObject()");
        return object;
    }

    public short readShort() throws JMSException {
        Object object = this._readPrimitiveObject("readShort()");
        return ConvertValue.toShort(object);
    }

    public String readString() throws JMSException {
        Object object = this._readPrimitiveObject("readString()");
        return ConvertValue.toString(object);
    }

    public void reset() throws JMSException {
        String string = "reset()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this._reset(string);
    }

    public void writeBoolean(boolean bl) throws JMSException {
        this._writePrimitiveObject(bl, "writeBoolean()");
    }

    public void writeByte(byte by) throws JMSException {
        this._writePrimitiveObject(by, "writeByte()");
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this._writePrimitiveObject(byArray, "writeBytes(byte[])");
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this._writePrimitiveObject(byArray2, "writeBytes(byte[], offset, length)");
    }

    public void writeChar(char c) throws JMSException {
        this._writePrimitiveObject(Character.valueOf(c), "writeChar()");
    }

    public void writeDouble(double d) throws JMSException {
        this._writePrimitiveObject(d, "writeDouble()");
    }

    public void writeFloat(float f) throws JMSException {
        this._writePrimitiveObject(Float.valueOf(f), "writeFloat()");
    }

    public void writeInt(int n) throws JMSException {
        this._writePrimitiveObject(n, "writeInt()");
    }

    public void writeLong(long l) throws JMSException {
        this._writePrimitiveObject(l, "writeLong()");
    }

    public void writeObject(Object object) throws JMSException {
        this._checkValidObjectType(object, "writeObject()");
        this._writePrimitiveObject(object, "writeObject()");
    }

    public void writeShort(short s) throws JMSException {
        this._writePrimitiveObject(s, "writeShort()");
    }

    public void writeString(String string) throws JMSException {
        this._writePrimitiveObject(string, "writeString()");
    }

    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(4);
    }

    protected void _setBodyToPacket() throws JMSException {
        this._reset("_setBodyToPacket");
        if (this.messageBody != null) {
            try {
                super._setMessageBodyOfPacket(this.messageBody, 0, this.messageBody.length);
            }
            catch (Exception exception) {
                String string = "MQJMSRA_DM4001: :ERROR setting StreamMessage body:Exception=" + exception.getMessage();
                _loggerJM.severe(string);
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)exception);
                throw jMSException;
            }
        }
    }

    protected void _getMessageBodyFromPacket() throws JMSException {
        this.messageBody = super._getMessageBodyByteArray();
        this._reset("_getMessageBodyFromPacket");
    }

    private void _reset(String string) throws JMSException {
        super._setReadOnlyBody(true);
        try {
            if (this.writePerformed) {
                this.objectOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.toByteArray();
                this.objectOutputStream.close();
                this.byteArrayOutputStream.close();
                this.writePerformed = false;
            }
            if (this.messageBody != null) {
                this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
                this.objectInputStream = new ObjectInputStream(this.byteArrayInputStream);
            }
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:StreamMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.byteArrayReadState = false;
        this.notYetProcessedPrimitiveObject = null;
    }

    private Object _readPrimitiveObject(String string) throws JMSException {
        Object object = null;
        this.checkForWriteOnlyMessageBody(string);
        this._checkReadBytesState(string);
        try {
            if (this.notYetProcessedPrimitiveObject != null) {
                object = this.notYetProcessedPrimitiveObject;
                this.notYetProcessedPrimitiveObject = null;
            } else {
                object = this.objectInputStream.readObject();
            }
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException("Unexpected EOFException" + eOFException.getMessage());
            throw messageEOFException;
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException("Exception on readObject:" + exception.getMessage());
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return object;
    }

    private void _writePrimitiveObject(Object object, String string) throws JMSException {
        this.checkForReadOnlyMessageBody(string);
        try {
            this.objectOutputStream.writeObject(object);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:StreamMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    private void _checkReadBytesState(String string) throws MessageFormatException {
        if (this.byteArrayReadState) {
            throw new MessageFormatException("MessageFormatException on" + string);
        }
    }

    private void _initializeOutputStreams() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException("Exception:StreamMessage:initializing output streams:" + exception.getMessage());
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    private void _checkValidObjectType(Object object, String string) throws MessageFormatException {
        if (object == null) {
            return;
        }
        if (!(object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof byte[])) {
            String string2 = "MQJMSRA_DM4001: :StreamMessage:setObject():Invalid type:name=" + string + ":type=" + object.getClass().getName();
            _loggerJM.severe(string2);
            MessageFormatException messageFormatException = new MessageFormatException(string2);
            throw messageFormatException;
        }
    }
}

