/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jms.IllegalStateException;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.ResourceAdapter;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class SessionAdapter
implements Session,
QueueSession,
TopicSession {
    private ConnectionAdapter ca = null;
    private XAConnectionImpl xac = null;
    private XASessionImpl xas = null;
    private boolean queueSession = false;
    private boolean topicSession = false;
    private boolean closed = false;
    private static final transient String _className = "com.sun.messaging.jms.ra.SessionAdapter";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient String _lgrNameJMSSession = "javax.jms.Session.mqjmsra";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient Logger _loggerJS = Logger.getLogger("javax.jms.Session.mqjmsra");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_SA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_SA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_SA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_SA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_SA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_SA4001: ";

    public SessionAdapter(ConnectionAdapter connectionAdapter, XAConnectionImpl xAConnectionImpl, XASessionImpl xASessionImpl) {
        Object[] objectArray = new Object[]{connectionAdapter, xAConnectionImpl, xASessionImpl};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.ca = connectionAdapter;
        this.xac = xAConnectionImpl;
        this.xas = xASessionImpl;
    }

    public XAConnectionImpl getXAConnection() {
        return this.xac;
    }

    public XASessionImpl getXASession() {
        return this.xas;
    }

    public void setQueueSession() {
        this.queueSession = true;
    }

    public void setTopicSession() {
        this.topicSession = true;
    }

    public void setConnectionAdapter(ConnectionAdapter connectionAdapter) {
        this.ca = connectionAdapter;
    }

    protected void startLocalTransaction() throws javax.jms.JMSException {
        this.xas._startLocalTransaction();
    }

    protected void closeAdapter() {
        if (this.closed) {
            return;
        }
        try {
            this.xas.close();
            this.closed = true;
        }
        catch (javax.jms.JMSException jMSException) {
            System.err.println("MQRA:SA:closeAdapter:Exception-" + jMSException.getMessage());
            jMSException.printStackTrace();
        }
    }

    public BytesMessage createBytesMessage() throws javax.jms.JMSException {
        return this.xas.createBytesMessage();
    }

    public MapMessage createMapMessage() throws javax.jms.JMSException {
        return this.xas.createMapMessage();
    }

    public Message createMessage() throws javax.jms.JMSException {
        return this.xas.createMessage();
    }

    public ObjectMessage createObjectMessage() throws javax.jms.JMSException {
        return this.xas.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws javax.jms.JMSException {
        return this.xas.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws javax.jms.JMSException {
        return this.xas.createStreamMessage();
    }

    public TextMessage createTextMessage() throws javax.jms.JMSException {
        return this.xas.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws javax.jms.JMSException {
        return this.xas.createTextMessage(string);
    }

    public MessageProducer createProducer(Destination destination) throws javax.jms.JMSException {
        return this.xas.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws javax.jms.JMSException {
        return this.xas.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws javax.jms.JMSException {
        return this.xas.createConsumer(destination, string);
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws javax.jms.JMSException {
        return this.xas.createConsumer(destination, string, bl);
    }

    public QueueReceiver createReceiver(Queue queue) throws javax.jms.JMSException {
        return this.xas.createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws javax.jms.JMSException {
        return this.xas.createReceiver(queue, string);
    }

    public QueueSender createSender(Queue queue) throws javax.jms.JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createSender() disallowed on TopicSession");
        }
        return this.xas.createSender(queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws javax.jms.JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createBrowser() disallowed on TopicSession");
        }
        return this.xas.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws javax.jms.JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createBrowser() disallowed on TopicSession");
        }
        return this.xas.createBrowser(queue, string);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws javax.jms.JMSException {
        return this.xas.createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws javax.jms.JMSException {
        ResourceAdapter resourceAdapter = null;
        boolean bl2 = false;
        String string2 = null;
        if (this.ca != null && (resourceAdapter = this.ca.getResourceAdapter()) != null && (bl2 = resourceAdapter.getInClusteredContainer())) {
            try {
                string2 = this.xac.getClientID();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || "".equals(string2)) {
                JMSException jMSException = new JMSException("MQJMSRA_SA4001: createSubscriber:Exception:Require non-null, non-empty clientId for clustered non-durable subscription:cId=" + string2);
                _loggerJS.severe(jMSException.getMessage());
                throw jMSException;
            }
        }
        return this.xas.createSubscriber(topic, string, bl);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws javax.jms.JMSException {
        return this.xas.createDurableSubscriber(topic, string);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws javax.jms.JMSException {
        return this.xas.createDurableSubscriber(topic, string, string2, bl);
    }

    public TopicPublisher createPublisher(Topic topic) throws javax.jms.JMSException {
        return this.xas.createPublisher(topic);
    }

    public void unsubscribe(String string) throws javax.jms.JMSException {
        if (this.queueSession) {
            throw new javax.jms.IllegalStateException("MQRA:unsubscribe() disallowed on QueueSession");
        }
        this.xas.unsubscribe(string);
    }

    public Topic createTopic(String string) throws javax.jms.JMSException {
        return this.xas.createTopic(string);
    }

    public Queue createQueue(String string) throws javax.jms.JMSException {
        return this.xas.createQueue(string);
    }

    public TemporaryTopic createTemporaryTopic() throws javax.jms.JMSException {
        if (this.queueSession) {
            throw new javax.jms.IllegalStateException("MQRA:createTemporaryTopic() disallowed on QueueSession");
        }
        return this.xas.createTemporaryTopic();
    }

    public TemporaryQueue createTemporaryQueue() throws javax.jms.JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createTemporaryQueue() disallowed on TopicSession");
        }
        return this.xas.createTemporaryQueue();
    }

    public void setMessageListener(MessageListener messageListener) throws javax.jms.JMSException {
        this.xas.setMessageListener(messageListener);
    }

    public MessageListener getMessageListener() throws javax.jms.JMSException {
        return this.xas.getMessageListener();
    }

    public void run() {
        _loggerJS.entering(_className, "run()");
        throw new UnsupportedOperationException("MQRA:SA:Disallowed - Session.run()");
    }

    public void commit() throws javax.jms.JMSException {
        this.xas.commit();
    }

    public void rollback() throws javax.jms.JMSException {
        this.xas.rollback();
    }

    public void recover() throws javax.jms.JMSException {
        this.xas.recover();
    }

    public void close() throws javax.jms.JMSException {
        _loggerJS.entering(_className, "close()");
        if (this.closed) {
            return;
        }
        this.ca.removeSessionAdapter(this);
        this.xas.close();
        this.closed = true;
    }

    public int getAcknowledgeMode() throws javax.jms.JMSException {
        return this.xas.getAcknowledgeMode();
    }

    public boolean getTransacted() throws javax.jms.JMSException {
        return this.xas.getTransacted();
    }

    protected void checkClosed() throws javax.jms.JMSException {
        if (this.closed) {
            throw new IllegalStateException("MQRA:SA:IllegalState-Session is closed");
        }
    }
}

