/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.mfwk.agent.appserv.delegate.BaseHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class TotalInboundAssociationsHandler
extends BaseHandler {
    public Object handleAttribute(ObjectName peer, String attribute, MBeanServerConnection mbs) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        Set<ObjectName> objectNames;
        long totalInboundAssociations = 0L;
        try {
            String serverName = peer.getKeyProperty("name");
            ObjectName connectionManagerPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=connection-manager,server=" + serverName);
            objectNames = mbs.queryNames(connectionManagerPattern, null);
            Iterator<ObjectName> iterator = objectNames.iterator();
            HashSet<ObjectName> totalInboundConnections = new HashSet<ObjectName>();
            ObjectName connectionManager = null;
            String connectionManagerName = null;
            while (iterator.hasNext()) {
                connectionManager = iterator.next();
                connectionManagerName = connectionManager.getKeyProperty("name");
                if (!connectionManagerName.startsWith("orb.Connections.Inbound")) continue;
                totalInboundConnections.add(connectionManager);
            }
            totalInboundAssociations = Utils.getAttributeSum(mbs, totalInboundConnections, "totalconnections-current");
            ObjectName connectionQueuePattern = new ObjectName("com.sun.appserv:*,category=monitor,type=connection-queue,server=" + serverName);
            objectNames = mbs.queryNames(connectionQueuePattern, null);
        }
        catch (Exception exception) {
            Utils.log(Level.SEVERE, "Error while getting Total Inbound Associations", exception);
            throw new HandlerException(exception);
        }
        return new Long(totalInboundAssociations += Utils.getAttributeSum(mbs, objectNames, "counttotalqueued-count"));
    }
}

