/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.mfwk.agent.appserv.delegate.BaseHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class TotalOutboundAssociationsHandler
extends BaseHandler {
    public Object handleAttribute(ObjectName peer, String attribute, MBeanServerConnection mbs) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        Set<ObjectName> objectNames;
        long totalOutboundAssociations = 0L;
        try {
            String serverName = peer.getKeyProperty("name");
            ObjectName connectionManagerPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=connection-manager,server=" + serverName);
            objectNames = mbs.queryNames(connectionManagerPattern, null);
            Iterator<ObjectName> iterator = objectNames.iterator();
            HashSet<ObjectName> totalOutboundConnections = new HashSet<ObjectName>();
            ObjectName connectionManager = null;
            String connectionManagerName = null;
            while (iterator.hasNext()) {
                connectionManager = iterator.next();
                connectionManagerName = connectionManager.getKeyProperty("name");
                if (!connectionManagerName.startsWith("orb.Connections.Outbound")) continue;
                totalOutboundConnections.add(connectionManager);
            }
            totalOutboundAssociations = Utils.getAttributeSum(mbs, totalOutboundConnections, "totalconnections-current");
            ObjectName connectorConnectionPoolPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=connector-connection-pool,server=" + serverName);
            objectNames = mbs.queryNames(connectorConnectionPoolPattern, null);
            totalOutboundAssociations += Utils.getAttributeSum(mbs, objectNames, "numconncreated-count");
            ObjectName jdbcConnectionPoolPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=jdbc-connection-pool,server=" + serverName);
            objectNames = mbs.queryNames(jdbcConnectionPoolPattern, null);
        }
        catch (Exception exception) {
            Utils.log(Level.SEVERE, "Error while getting Total Outbound Associations", exception);
            throw new HandlerException(exception);
        }
        return new Long(totalOutboundAssociations += Utils.getAttributeSum(mbs, objectNames, "numconncreated-count"));
    }
}

