/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.JBICommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class JBIListCommands
extends JBICommand {
    private static final String LIST_BINDING_COMPONENTS = "list-jbi-binding-components";
    private static final String LIST_SERVICE_ENGINES = "list-jbi-service-engines";
    private static final String LIST_SHARED_LIBRARIES = "list-jbi-shared-libraries";
    private static final String LIST_SERVICE_ASSEMBLIES = "list-jbi-service-assemblies";

    public void runCommand() throws CommandException, CommandValidationException {
        String result = "";
        try {
            if (this.preRunInit()) {
                String targetName = this.getOption("target");
                String libraryName = this.getOption("libraryname");
                String assemblyName = this.getOption("assemblyname");
                String lifecycleState = this.getOption("lifecyclestate", validStates);
                String componentName = this.getOption("componentname");
                if (this.name.equals(LIST_BINDING_COMPONENTS)) {
                    result = this.mJbiAdminCommands.listBindingComponents(lifecycleState, libraryName, assemblyName, targetName);
                    this.processJBIAdminComponentListResult(result);
                } else if (this.name.equals(LIST_SERVICE_ENGINES)) {
                    result = this.mJbiAdminCommands.listServiceEngines(lifecycleState, libraryName, assemblyName, targetName);
                    this.processJBIAdminComponentListResult(result);
                } else if (this.name.equals(LIST_SHARED_LIBRARIES)) {
                    result = this.mJbiAdminCommands.listSharedLibraries(componentName, targetName);
                    this.processJBIAdminComponentListResult(result);
                } else if (this.name.equals(LIST_SERVICE_ASSEMBLIES)) {
                    result = this.mJbiAdminCommands.listServiceAssemblies(lifecycleState, componentName, targetName);
                    this.processJBIAdminAsseblyListResult(result);
                }
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
            }
        }
        catch (Exception e) {
            this.processTaskException(e);
        }
    }
}

