/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.commands.monitor.ConnectionManagerMonitorTask;
import com.sun.enterprise.cli.commands.monitor.ConnectionQueueMonitorTask;
import com.sun.enterprise.cli.commands.monitor.ConnectorPoolMonitorTask;
import com.sun.enterprise.cli.commands.monitor.EntityBeanMonitorTask;
import com.sun.enterprise.cli.commands.monitor.FileCacheMonitorTask;
import com.sun.enterprise.cli.commands.monitor.HttpListenerMonitorTask;
import com.sun.enterprise.cli.commands.monitor.HttpServiceVirtualServerMonitorTask;
import com.sun.enterprise.cli.commands.monitor.JDBCPoolMonitorTask;
import com.sun.enterprise.cli.commands.monitor.JVMMonitorTask;
import com.sun.enterprise.cli.commands.monitor.KeepAliveMonitorTask;
import com.sun.enterprise.cli.commands.monitor.MessageDrivenBeanMonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.commands.monitor.ServletMonitorTask;
import com.sun.enterprise.cli.commands.monitor.StatefulSessionBeanMonitorTask;
import com.sun.enterprise.cli.commands.monitor.StatelessSessionBeanMonitorTask;
import com.sun.enterprise.cli.commands.monitor.ThreadPoolMonitorTask;
import com.sun.enterprise.cli.commands.monitor.WebModuleVirtualServerMonitorTask;
import com.sun.enterprise.cli.commands.monitor.WebServiceEndpointMonitorTask;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.File;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServerConnection;

public class MonitorCommand
extends S1ASCommand {
    private static final String MONITOR_TYPE = "type";
    private static final String INTERVAL = "interval";
    private static final String FILTER = "filter";
    private static final String FILENAME = "filename";
    public static String[] validTypes = new String[]{"httplistener", "keepalive", "filecache", "connectionqueue", "jdbcpool", "jvm", "threadpool", "servlet", "connection", "connectorpool", "endpoint", "entitybean", "messagedriven", "statefulsession", "statelesssession", "httpservice", "webmodule"};

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String host = this.getHost();
        int port = this.getPort();
        String user = this.getUser();
        String password = this.getPassword();
        boolean verbose = !this.getBooleanOption("terse");
        String monitorType = this.getOption(MONITOR_TYPE);
        long interval = Long.parseLong(this.getOption(INTERVAL)) * 1000L;
        String instanceName = (String)this.getOperands().get(0);
        String filter = this.getOption(FILTER);
        File fileName = this.getFileName();
        this.go(user, password, host, port, verbose, fileName, monitorType, interval, instanceName, filter);
    }

    private void go(String user, String password, String host, int port, boolean verbose, File fileName, String monitorType, long interval, String instanceName, String filterName) throws CommandException {
        Timer timer = new Timer();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(host, port, user, password);
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            this.verifyTargetInstance(domainRoot, instanceName);
            ServerRootMonitor srm = this.getServerRootMonitor(domainRoot, instanceName);
            MonitorTask monitorTask = this.getTask(monitorType, srm, filterName, timer, verbose, fileName);
            timer.scheduleAtFixedRate((TimerTask)monitorTask, 0L, interval);
            boolean done = false;
            while (!done) {
                char c = new CliUtil().getKeyboardInput();
                String str = Character.toString(c);
                if (str.equals("q") || str.equals("Q")) {
                    timer.cancel();
                    done = true;
                    continue;
                }
                if (!str.equals("h") && !str.equals("H")) continue;
                monitorTask.displayDetails();
            }
        }
        catch (MonitorTaskException mte) {
            timer.cancel();
            this.displayExceptionMessage(mte);
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private File getFileName() {
        File fileName = null;
        if (this.getOption(FILENAME) != null && (fileName = new File(this.getOption(FILENAME))).isDirectory()) {
            File tempFile = fileName;
            fileName = new File(tempFile, "monitor.log");
        }
        return fileName;
    }

    private void verifyTargetInstance(DomainRoot domainRoot, String instanceName) throws CommandException {
        boolean isServer = false;
        isServer = domainRoot.getDomainConfig().getStandaloneServerConfigMap().keySet().contains(instanceName);
        if (!isServer) {
            throw new CommandException(this.getLocalizedString("TargetNotAnInstance", new Object[]{instanceName}));
        }
    }

    private ServerRootMonitor getServerRootMonitor(DomainRoot domainRoot, String instanceName) throws CommandException {
        Map serverRootMonitorMap = domainRoot.getMonitoringRoot().getServerRootMonitorMap();
        ServerRootMonitor serverRootMonitor = (ServerRootMonitor)serverRootMonitorMap.get(instanceName);
        if (serverRootMonitor == null) {
            throw new CommandException("Unable to monitoring" + instanceName);
        }
        return serverRootMonitor;
    }

    private MonitorTask getTask(String type, ServerRootMonitor srm, String filterName, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        MonitorTask monitorTask = null;
        if (type.equals("jvm")) {
            monitorTask = new JVMMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("jdbcpool")) {
            monitorTask = new JDBCPoolMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("connectorpool")) {
            monitorTask = new ConnectorPoolMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("threadpool")) {
            monitorTask = new ThreadPoolMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("connectionqueue")) {
            monitorTask = new ConnectionQueueMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("filecache")) {
            monitorTask = new FileCacheMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("keepalive")) {
            monitorTask = new KeepAliveMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("httplistener")) {
            monitorTask = new HttpListenerMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("httpservice")) {
            monitorTask = new HttpServiceVirtualServerMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("connection")) {
            monitorTask = new ConnectionManagerMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("webmodule")) {
            monitorTask = new WebModuleVirtualServerMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("servlet")) {
            monitorTask = new ServletMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("endpoint")) {
            monitorTask = new WebServiceEndpointMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("entitybean")) {
            monitorTask = new EntityBeanMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("messagedriven")) {
            monitorTask = new MessageDrivenBeanMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("statefulsession")) {
            monitorTask = new StatefulSessionBeanMonitorTask(srm, filterName, timer, verbose, fileName);
        } else if (type.equals("statelesssession")) {
            monitorTask = new StatelessSessionBeanMonitorTask(srm, filterName, timer, verbose, fileName);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getLocalizedString("InvalidMonitorType", new Object[]{type}));
            for (String validType : validTypes) {
                if (validType.equals(validTypes[0])) {
                    sb.append(" " + validType);
                    continue;
                }
                sb.append(", " + validType);
            }
            sb.append(".");
            throw new MonitorTaskException(sb.toString());
        }
        return monitorTask;
    }
}

