/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.CLIProcessExecutor;
import com.sun.enterprise.cli.commands.DatabaseCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;

public final class StartDatabaseCommand
extends DatabaseCommand {
    private static final String DB_HOME = "dbhome";
    private static final String DATABASE_DIR_NAME = "databases";
    private String dbHome;

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public String[] startDatabaseCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "start", this.dbHost, this.dbPort, "true", this.dbHome};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "start", this.dbHost, this.dbPort, "true", this.dbHome};
    }

    public String[] sysinfoCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
    }

    private String getDatabaseHomeDir() {
        if (this.getOption(DB_HOME) != null) {
            return this.getOption(DB_HOME);
        }
        String currentDir = System.getProperty("user.dir");
        if (new File(currentDir, "derby.log").exists()) {
            return currentDir;
        }
        String domainPath = System.getProperty("com.sun.aas.domainsRoot");
        File installPath = new File(domainPath).getParentFile();
        if (installPath != null) {
            File dbDir = new File(installPath, DATABASE_DIR_NAME);
            dbDir.mkdir();
            try {
                return dbDir.getCanonicalPath();
            }
            catch (IOException ioe) {
                return dbDir.getAbsolutePath();
            }
        }
        return null;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        CLIProcessExecutor cpe = new CLIProcessExecutor();
        String dbLog = "";
        try {
            this.prepareProcessExecutor();
            this.dbHome = this.getDatabaseHomeDir();
            if (this.dbHome != null) {
                dbLog = this.dbHome + File.separator + "derby.log";
            }
            CLILogger.getInstance().printDebugMessage("Ping Database");
            cpe.execute(this.pingDatabaseCmd(true), true);
            if (cpe.exitValue() > 0) {
                CLILogger.getInstance().printDebugMessage("Start Database");
                cpe.execute(this.startDatabaseCmd(), false);
                if (cpe.exitValue() != 0) {
                    throw new CommandException(this.getLocalizedString("UnableToStartDatabase", new Object[]{dbLog}));
                }
            } else {
                if (cpe.exitValue() < 0) {
                    throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}));
                }
                CLILogger.getInstance().printMessage(this.getLocalizedString("StartDatabaseStatus", new Object[]{this.dbHost, this.dbPort}));
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
            }
        }
        catch (IllegalThreadStateException ite) {
            if (!this.getBooleanOption("terse")) {
                try {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("database.info.msg", new Object[]{this.dbHost, this.dbPort}));
                    CLILogger.getInstance().printDebugMessage("Database SysInfo");
                    new CLIProcessExecutor().execute(this.sysinfoCmd(), true);
                }
                catch (Exception e) {
                    throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
                }
            }
            CLILogger.getInstance().printMessage(this.getLocalizedString("DatabaseStartMsg"));
            if (new File(dbLog).canWrite()) {
                CLILogger.getInstance().printMessage(this.getLocalizedString("LogRedirectedTo", new Object[]{dbLog}));
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }
}

