/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventListener;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.BaseProcessor;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.CMPProcessor;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.PersistenceProcessor;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.database.DatabaseConstants;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Properties;
import java.util.ResourceBundle;

public class DeploymentEventListenerImpl
implements DeploymentEventListener,
DatabaseConstants {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.ejb.ejbc.Bundle", DeploymentEventListenerImpl.class.getClassLoader());
    private static Logger logger = LogHelperSQLStore.getLogger();

    DeploymentEventListenerImpl() {
    }

    public void notifyDeploymentEvent(DeploymentEvent event) {
        int type = event.getEventType();
        switch (type) {
            case 2: {
                this.processEvent(event.getEventInfo(), true);
                break;
            }
            case 1: 
            case 3: {
                this.processEvent(event.getEventInfo(), false);
                break;
            }
        }
    }

    private void processEvent(DeploymentEventInfo info, boolean create) {
        Application application;
        String cliCreateTables = null;
        String cliDropTables = null;
        DeploymentRequest request = info.getDeploymentRequest();
        if (this.isDeploy(request) && !create) {
            return;
        }
        Properties cliOverrides = request.getOptionalArguments();
        String cliDropAndCreateTables = cliOverrides.getProperty("CmpInfo.DROP_AND_CREATE_TABLES", "undefined");
        if (create) {
            cliCreateTables = cliOverrides.getProperty("CmpInfo.CREATE_TABLES", "undefined");
            if (cliCreateTables.equals("undefined")) {
                cliCreateTables = cliDropAndCreateTables;
            }
        } else {
            cliDropTables = cliOverrides.getProperty("CmpInfo.DROP_TABLES", "undefined");
        }
        if ((application = info.getApplicationDescriptor()) == null) {
            return;
        }
        this.processApplication(request, info, create, cliCreateTables, cliDropAndCreateTables, cliDropTables);
    }

    private void processApplication(DeploymentRequest request, DeploymentEventInfo info, boolean create, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        if (logger.isLoggable(500)) {
            logger.fine("ejb.DeploymentEventListenerImpl.processingevent", this.isRedeploy(request) ? "redeploy" : (create ? "deploy" : "undeploy"), info.getApplicationDescriptor().getRegistrationName());
        }
        DeploymentStatus status = request.getCurrentDeploymentStatus();
        status.setStageStatus(2);
        status.setStageStatusMessage("");
        BaseProcessor processor = new CMPProcessor(info, create, cliCreateTables, cliDropAndCreateTables, cliDropTables);
        processor.processApplication();
        processor = new PersistenceProcessor(info, create, cliCreateTables, cliDropAndCreateTables, cliDropTables);
        processor.processApplication();
    }

    private boolean isRedeploy(DeploymentRequest request) {
        boolean redeploy = false;
        try {
            if (request != null) {
                redeploy = request.isReDeploy();
            }
        }
        catch (IASDeploymentException iASDeploymentException) {
            // empty catch block
        }
        return redeploy;
    }

    private boolean isDeploy(DeploymentRequest request) {
        boolean deploy = false;
        try {
            if (request != null) {
                deploy = request.isDeploy();
            }
        }
        catch (IASDeploymentException iASDeploymentException) {
            // empty catch block
        }
        return deploy;
    }

    static {
        DeploymentEventManager.addListener((DeploymentEventListener)new DeploymentEventListenerImpl());
    }
}

