/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.state;

import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.state.AutoPersistentNew;
import com.sun.jdo.spi.persistence.support.sqlstore.state.AutoPersistentNewDeleted;
import com.sun.jdo.spi.persistence.support.sqlstore.state.AutoPersistentNewFlushed;
import com.sun.jdo.spi.persistence.support.sqlstore.state.AutoPersistentNewFlushedDeleted;
import com.sun.jdo.spi.persistence.support.sqlstore.state.AutoPersistentNewFlushedPending;
import com.sun.jdo.spi.persistence.support.sqlstore.state.AutoPersistentNewPending;
import com.sun.jdo.spi.persistence.support.sqlstore.state.Hollow;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentClean;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentDeleted;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentDeletedFlushed;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentDirty;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentNew;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentNewDeleted;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentNewFlushed;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentNewFlushedDeleted;
import com.sun.jdo.spi.persistence.support.sqlstore.state.PersistentNonTransactional;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ResourceBundle;

public abstract class LifeCycleState {
    protected static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", LifeCycleState.class.getClassLoader());
    protected boolean isPersistent;
    protected boolean isAutoPersistent;
    protected boolean isPersistentInDataStore;
    protected boolean isTransactional;
    protected boolean isDirty;
    protected boolean isNew;
    protected boolean isDeleted;
    protected boolean isFlushed;
    protected boolean isNavigable;
    protected boolean isRefreshable;
    protected boolean isBeforeImageUpdatable;
    protected boolean needsRegister;
    protected boolean needsReload;
    protected boolean needsRestoreOnRollback;
    protected boolean needMerge = true;
    protected int updateAction;
    protected int stateType;
    protected static final int NO_OP = 0;
    protected static final int INSERT_OP = 1;
    protected static final int UPDATE_OP = 2;
    protected static final int DELETE_OP = 3;
    public static final int HOLLOW = 0;
    public static final int P_NON_TX = 1;
    public static final int P_CLEAN = 2;
    public static final int P_DIRTY = 3;
    public static final int P_NEW = 4;
    public static final int P_NEW_FLUSHED = 5;
    public static final int P_NEW_FLUSHED_DELETED = 6;
    public static final int P_NEW_DELETED = 7;
    public static final int P_DELETED = 8;
    public static final int P_DELETED_FLUSHED = 9;
    public static final int AP_NEW = 10;
    public static final int AP_NEW_PENDING = 11;
    public static final int AP_NEW_FLUSHED = 12;
    public static final int AP_NEW_FLUSHED_PENDING = 13;
    public static final int AP_NEW_FLUSHED_DELETED = 14;
    public static final int AP_NEW_DELETED = 15;
    public static final int TRANSIENT = 16;
    public static final int TOTAL = 17;
    private static LifeCycleState[] stateTypes;
    private static Logger logger;

    protected static void initLifeCycleState() {
        stateTypes = new LifeCycleState[17];
        LifeCycleState.stateTypes[0] = new Hollow();
        LifeCycleState.stateTypes[1] = new PersistentNonTransactional();
        LifeCycleState.stateTypes[2] = new PersistentClean();
        LifeCycleState.stateTypes[3] = new PersistentDirty();
        LifeCycleState.stateTypes[4] = new PersistentNew();
        LifeCycleState.stateTypes[5] = new PersistentNewFlushed();
        LifeCycleState.stateTypes[7] = new PersistentNewDeleted();
        LifeCycleState.stateTypes[6] = new PersistentNewFlushedDeleted();
        LifeCycleState.stateTypes[8] = new PersistentDeleted();
        LifeCycleState.stateTypes[9] = new PersistentDeletedFlushed();
        LifeCycleState.stateTypes[10] = new AutoPersistentNew();
        LifeCycleState.stateTypes[11] = new AutoPersistentNewPending();
        LifeCycleState.stateTypes[12] = new AutoPersistentNewFlushed();
        LifeCycleState.stateTypes[13] = new AutoPersistentNewFlushedPending();
        LifeCycleState.stateTypes[14] = new AutoPersistentNewFlushedDeleted();
        LifeCycleState.stateTypes[15] = new AutoPersistentNewDeleted();
        LifeCycleState.stateTypes[16] = null;
    }

    public static LifeCycleState getLifeCycleState(int state) {
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.state.lifecyclestate.initial", stateTypes[state]);
        }
        return stateTypes[state];
    }

    public int stateType() {
        return this.stateType;
    }

    public LifeCycleState transitionMakePersistent() {
        return this;
    }

    public LifeCycleState transitionDeletePersistent() {
        return this;
    }

    public LifeCycleState transitionRefreshPersistent() {
        return this;
    }

    public LifeCycleState transitionReload(boolean transactionActive) {
        return this;
    }

    public LifeCycleState transitionCommit(boolean retainValues) {
        return this;
    }

    public LifeCycleState transitionRollback(boolean retainValues) {
        return this;
    }

    public LifeCycleState transitionFlushed() {
        return this;
    }

    public LifeCycleState transitionMakePending() {
        return this;
    }

    public LifeCycleState transitionReadField(boolean optimisitic, boolean nontransactionalRead, boolean transactionActive) {
        if (!nontransactionalRead) {
            this.assertTransaction(transactionActive);
        }
        return this;
    }

    public LifeCycleState transitionWriteField(boolean transactionActive) {
        this.assertTransaction(transactionActive);
        return this;
    }

    protected void assertTransaction(boolean transactionActive) {
        if (!transactionActive) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.lifecycle.xactnotactive"));
        }
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isAutoPersistent() {
        return this.isAutoPersistent;
    }

    public boolean isPersistentInDataStore() {
        return this.isPersistentInDataStore;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean needsRegister() {
        return this.needsRegister;
    }

    public boolean isNavigable() {
        return this.isNavigable;
    }

    public boolean isRefreshable() {
        return this.isRefreshable;
    }

    public boolean isBeforeImageUpdatable() {
        return this.isBeforeImageUpdatable;
    }

    public boolean needsReload(boolean optimistic, boolean nontransactionalRead, boolean transactionActive) {
        return this.needsReload;
    }

    public boolean needsRestoreOnRollback(boolean retainValues) {
        if (retainValues) {
            return true;
        }
        return this.needsRestoreOnRollback;
    }

    public boolean needMerge() {
        return this.needMerge;
    }

    public int getUpdateAction() {
        return this.updateAction;
    }

    public LifeCycleState changeState(int newStateType) {
        if (logger.isLoggable(400)) {
            Object[] items = new Object[]{this, stateTypes[newStateType]};
            logger.finer("sqlstore.state.lifecyclestate.changestate", items);
        }
        return stateTypes[newStateType];
    }

    public String toString() {
        switch (this.stateType) {
            case 0: {
                return "HOLLOW";
            }
            case 1: {
                return "P_NON_TX";
            }
            case 2: {
                return "P_CLEAN";
            }
            case 3: {
                return "P_DIRTY";
            }
            case 4: {
                return "P_NEW";
            }
            case 5: {
                return "P_NEW_FLUSHED";
            }
            case 6: {
                return "P_NEW_FLUSHED_DELETED";
            }
            case 7: {
                return "P_NEW_DELETED";
            }
            case 8: {
                return "P_DELETED";
            }
            case 9: {
                return "P_DELETED_FLUSHED";
            }
            case 10: {
                return "AP_NEW";
            }
            case 11: {
                return "AP_NEW_PENDING";
            }
            case 12: {
                return "AP_NEW_FLUSHED";
            }
            case 13: {
                return "AP_NEW_FLUSHED_PENDING";
            }
            case 14: {
                return "AP_NEW_FLUSHED_DELETED";
            }
            case 15: {
                return "AP_NEW_DELETED";
            }
        }
        return null;
    }

    static {
        logger = LogHelperStateManager.getLogger();
        LifeCycleState.initLifeCycleState();
    }
}

