/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.sysnet;

import com.sun.enterprise.registration.RegistrationAccount;
import com.sun.enterprise.registration.RegistrationAccountConfig;
import com.sun.enterprise.registration.RegistrationAccountFactory;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.RegistrationServiceConfig;
import com.sun.enterprise.registration.RegistrationServiceFactory;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.util.RegistrationUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.faces.context.FacesContext;

public class RegisterHandlers {
    public static void showRegistration(HandlerContext handlerCtx) {
        RegistrationService regService = RegisterHandlers.getRegistrationService();
        if (regService == null) {
            System.out.println("========== No RegistrationService available. ===========");
            handlerCtx.setOutputValue("value", (Object)false);
            return;
        }
        if (RegisterHandlers.getRegistrationStatus() == RegistrationService.RegistrationStatus.NOT_REGISTERED && !regService.isRegistrationEnabled()) {
            System.out.println("============ Product is not registered and registration is not Enabled ===========");
            handlerCtx.setOutputValue("value", (Object)false);
            return;
        }
        handlerCtx.setOutputValue("value", (Object)true);
    }

    private static RegistrationService.RegistrationStatus getRegistrationStatus() {
        RegistrationService.RegistrationStatus regStatus = RegistrationService.RegistrationStatus.NOT_REGISTERED;
        try {
            RegistrationService regService = RegisterHandlers.getRegistrationService();
            if (regService != null) {
                regStatus = regService.getRegistrationStatus();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return regStatus;
    }

    private static RegistrationService.RegistrationReminder getRegistrationReminder() {
        try {
            RegistrationService regService = RegisterHandlers.getRegistrationService();
            if (regService.getRegistrationStatus() == RegistrationService.RegistrationStatus.REGISTERED) {
                return RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION;
            }
            if (!regService.isRegistrationEnabled()) {
                return RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION;
            }
            RegistrationService.RegistrationReminder rem = regService.getRegistrationReminder();
            return rem;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION;
        }
    }

    private static void setRegistrationReminder(RegistrationService.RegistrationReminder value) {
        try {
            RegistrationService regService = RegisterHandlers.getRegistrationService();
            regService.setRegistrationReminder(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setRegistrationDontAsk(HandlerContext handlerCtx) {
        RegisterHandlers.setRegistrationReminder(RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION);
        GuiUtil.setSessionValue("dontAskRegistrationInThisSession", Boolean.TRUE);
    }

    public static void setRegistrationRemindLater(HandlerContext handlerCtx) {
        RegisterHandlers.setRegistrationReminder(RegistrationService.RegistrationReminder.REMIND_LATER);
        GuiUtil.setSessionValue("dontAskRegistrationInThisSession", Boolean.TRUE);
    }

    private static RegistrationService getRegistrationService() {
        try {
            File registryFile = RegistrationUtil.getServiceTagRegistry();
            Object[] params = new Object[]{registryFile};
            RegistrationServiceConfig config = new RegistrationServiceConfig("com.sun.enterprise.registration.SysnetRegistrationService", params);
            RegistrationService registrationService = RegistrationServiceFactory.getInstance().getRegistrationService(config);
            return registrationService;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static RegistrationService getRegistrationService(String proxyHost, int proxyPort) {
        try {
            File registryFile = RegistrationUtil.getServiceTagRegistry();
            Object[] params = new Object[]{registryFile, proxyHost, proxyPort};
            RegistrationServiceConfig config = new RegistrationServiceConfig("com.sun.enterprise.registration.SysnetRegistrationService", params);
            RegistrationService registrationService = RegistrationServiceFactory.getInstance().getRegistrationService(config);
            return registrationService;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void askRegistration(HandlerContext handlerCtx) {
        String thisSession = (String)handlerCtx.getInputValue("thisSession");
        if (!GuiUtil.isEmpty(thisSession)) {
            handlerCtx.setOutputValue("askRegistration", (Object)false);
            return;
        }
        RegistrationService.RegistrationReminder reminder = RegisterHandlers.getRegistrationReminder();
        if (reminder == RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION) {
            GuiUtil.setSessionValue("dontAskRegistrationInThisSession", Boolean.TRUE);
            handlerCtx.setOutputValue("askRegistration", (Object)false);
            return;
        }
        if (reminder == RegistrationService.RegistrationReminder.ASK_FOR_REGISTRATION) {
            handlerCtx.setOutputValue("askRegistration", (Object)true);
            return;
        }
        String cookie = (String)handlerCtx.getInputValue("cookie");
        if (GuiUtil.isEmpty(cookie) || cookie.equals("null")) {
            handlerCtx.setOutputValue("askRegistration", (Object)true);
        } else {
            GuiUtil.setSessionValue("dontAskRegistrationInThisSession", Boolean.TRUE);
            handlerCtx.setOutputValue("askRegistration", (Object)false);
        }
    }

    public static void registerAS(HandlerContext handlerCtx) {
        String accountStatus = (String)handlerCtx.getInputValue("accountStatus");
        if ("hasAccount".equals(accountStatus)) {
            String userName = (String)handlerCtx.getInputValue("userName");
            String pswd = (String)handlerCtx.getInputValue("pswd");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userID", userName);
            map.put("password", pswd);
            Object[] accountParams = new Object[]{map};
            try {
                RegistrationAccountConfig accountConfig = new RegistrationAccountConfig("com.sun.enterprise.registration.SOAccount", accountParams);
                RegistrationAccount account = RegistrationAccountFactory.getInstance().getRegistrationAccount(accountConfig);
                String proxy = (String)handlerCtx.getInputValue("proxy");
                String port = (String)handlerCtx.getInputValue("port");
                RegistrationService regService = RegisterHandlers.getRegServiceForRegister(proxy, port);
                if (regService == null) {
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("reg.error.noRegService"));
                    return;
                }
                regService.register(account);
                RegisterHandlers.setNodeText(handlerCtx, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                GuiUtil.handleException(handlerCtx, ex);
                return;
            }
        }
        String emailAdr = (String)handlerCtx.getInputValue("emailAdr");
        String newPswd = (String)handlerCtx.getInputValue("newPswd");
        String screenName = (String)handlerCtx.getInputValue("screenName");
        String firstName = (String)handlerCtx.getInputValue("firstName");
        String lastName = (String)handlerCtx.getInputValue("lastName");
        String country = (String)handlerCtx.getInputValue("country");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", emailAdr);
        map.put("password", newPswd);
        map.put("country", country);
        if (GuiUtil.isEmpty(screenName)) {
            screenName = emailAdr;
        }
        map.put("userID", screenName);
        if (GuiUtil.isEmpty(firstName)) {
            firstName = " ";
        }
        map.put("firstName", firstName);
        if (GuiUtil.isEmpty(lastName)) {
            lastName = " ";
        }
        map.put("lastName", lastName);
        Object[] accountParams = new Object[]{map};
        try {
            String proxy = (String)handlerCtx.getInputValue("newProxy");
            String port = (String)handlerCtx.getInputValue("newPort");
            RegistrationService regService = RegisterHandlers.getRegServiceForRegister(proxy, port);
            if (regService == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("reg.error.noRegService"));
                return;
            }
            RegistrationAccountConfig accountConfig = new RegistrationAccountConfig("com.sun.enterprise.registration.SOAccount", accountParams);
            RegistrationAccount account = RegistrationAccountFactory.getInstance().getRegistrationAccount(accountConfig);
            regService.createRegistrationAccount(account);
            regService.register(account);
            RegisterHandlers.setNodeText(handlerCtx, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.handleException(handlerCtx, ex);
            return;
        }
    }

    private static RegistrationService getRegServiceForRegister(String proxy, String port) {
        if (!GuiUtil.isEmpty(proxy) && !GuiUtil.isEmpty(port)) {
            return RegisterHandlers.getRegistrationService(proxy, Integer.parseInt(port));
        }
        return RegisterHandlers.getRegistrationService();
    }

    public static void getCountryListForRegistration(HandlerContext handlerCtx) {
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        RegistrationService regService = RegisterHandlers.getRegistrationService();
        List countryList = regService.getAvailableCountries(locale);
        handlerCtx.setOutputValue("labels", countryList.get(0));
        handlerCtx.setOutputValue("values", countryList.get(1));
    }

    public static void setRegistrationNodeText(HandlerContext handlerCtx) {
        try {
            RegistrationService regService = RegisterHandlers.getRegistrationService();
            RegistrationService.RegistrationStatus status = regService.getRegistrationStatus();
            RegisterHandlers.setNodeText(handlerCtx, status == RegistrationService.RegistrationStatus.REGISTERED);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RegisterHandlers.setNodeText(handlerCtx, false);
        }
    }

    public static void getSupportImages(HandlerContext handlerCtx) {
        int maxImageCount = 26;
        ArrayList<String> result = new ArrayList<String>();
        int cnt = (Integer)handlerCtx.getInputValue("count");
        Random random = new Random();
        for (int i = 0; i < cnt; ++i) {
            int num;
            String imgName;
            do {
                num = Math.abs(random.nextInt() % maxImageCount);
            } while (result.contains(imgName = "square-" + num + ".gif"));
            result.add(imgName);
        }
        handlerCtx.setOutputValue("imageList", result);
    }

    private static void setNodeText(HandlerContext handlerCtx, boolean registered) {
        if (registered) {
            GuiUtil.setSessionValue("registrationNodeText", GuiUtil.getMessage("tree.support"));
            GuiUtil.setSessionValue("registrationNodePage", "support");
        } else {
            GuiUtil.setSessionValue("registrationNodeText", GuiUtil.getMessage("tree.registration"));
            GuiUtil.setSessionValue("registrationNodePage", "registration");
        }
    }

    public static void getIssueQueryString(HandlerContext handlerCtx) {
        GregorianCalendar current = new GregorianCalendar();
        ((Calendar)current).add(10, -168);
        int month = Integer.parseInt("" + current.get(2)) + 1;
        String startTime = "" + current.get(1) + "-" + month + "-" + current.get(5);
        String query = "https://glassfish.dev.java.net/issues/buglist.cgi?component=glassfish&issue_status=RESOLVED&chfield=issue_status&chfieldto=Now&cmdtype=doit&chfieldfrom=" + startTime;
        handlerCtx.setOutputValue("query", (Object)query);
    }
}

