/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.appserv.server.util.ASURLClassLoader;
import java.io.IOException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderChain
extends SecureClassLoader {
    private List<ClassLoader> classLoaderList = new ArrayList<ClassLoader>();
    private ClassLoader parentCL = null;
    private String nameOfCL;

    public ClassLoaderChain() {
    }

    public ClassLoaderChain(ClassLoader parent) {
        super(parent);
        this.parentCL = parent;
    }

    public void setName(String n) {
        this.nameOfCL = n;
    }

    @Override
    public String getName() {
        return this.nameOfCL;
    }

    public void addToList(ClassLoader cl) {
        this.classLoaderList.add(cl);
    }

    public void removeFromList(ClassLoader cl) {
        this.classLoaderList.remove(cl);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    protected Class loadClass(String name, ClassLoader toSkip) throws ClassNotFoundException {
        for (ClassLoader element : this.classLoaderList) {
            if (element.equals(toSkip)) continue;
            Class<?> clz = null;
            try {
                clz = element.loadClass(name);
                if (clz == null) continue;
                return clz;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(className);
        if (c != null) {
            return c;
        }
        if (this.parentCL != null) {
            try {
                c = this.parentCL.loadClass(className);
                if (c != null && resolve) {
                    this.resolveClass(c);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c != null) {
                return c;
            }
        }
        for (ClassLoader element : this.classLoaderList) {
            if (element == null) continue;
            Class<?> clz = null;
            try {
                clz = element.loadClass(className);
                if (clz == null) continue;
                if (resolve) {
                    this.resolveClass(clz);
                }
                return clz;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader cl : this.classLoaderList) {
            URL res = cl.getResource(name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        for (ClassLoader cl : this.classLoaderList) {
            Enumeration<URL> res = cl.getResources(name);
            ArrayList<URL> al = new ArrayList<URL>();
            while (res.hasMoreElements()) {
                al.add(res.nextElement());
            }
            if (al.size() == 0) continue;
            return new Vector(al).elements();
        }
        return new Vector().elements();
    }

    public String toString() {
        String s = this.nameOfCL + " parentCL :: " + this.parentCL + " constituent CLs :: \n";
        for (ClassLoader cl : this.classLoaderList) {
            String nameofCL1 = null;
            if (cl instanceof ASURLClassLoader) {
                nameofCL1 = ((ASURLClassLoader)cl).getName();
            } else if (cl instanceof ClassLoaderChain) {
                nameofCL1 = ((ClassLoaderChain)cl).getName();
            }
            s = s + " :: " + nameofCL1;
        }
        s = s + "\n";
        return s;
    }
}

