/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASenvPropertyReader {
    private static Logger _logger = null;
    private HashMap _propertyMap = null;
    private String _configDirectory = null;
    private boolean useLogger = true;

    public ASenvPropertyReader(String configDirectory) {
        this._configDirectory = configDirectory;
        this._propertyMap = new HashMap();
        this._propertyMap.put("AS_ANT", "com.sun.aas.antRoot");
        this._propertyMap.put("AS_ANT_LIB", "com.sun.aas.antLib");
        this._propertyMap.put("AS_DERBY_INSTALL", "com.sun.aas.derbyRoot");
        this._propertyMap.put("AS_WEBCONSOLE_LIB", "com.sun.aas.webconsoleLib");
        this._propertyMap.put("AS_WEBCONSOLE_APP", "com.sun.aas.webconsoleApp");
        this._propertyMap.put("AS_JATO_LIB", "com.sun.aas.jatoRoot");
        this._propertyMap.put("AS_WEBSERVICES_LIB", "com.sun.aas.webServicesLib");
        this._propertyMap.put("AS_PERL", "com.sun.aas.perlRoot");
        this._propertyMap.put("AS_NSS", "com.sun.aas.nssRoot");
        this._propertyMap.put("AS_NSS_BIN", "com.sun.aas.nssBin");
        this._propertyMap.put("AS_IMQ_LIB", "com.sun.aas.imqLib");
        this._propertyMap.put("AS_IMQ_BIN", "com.sun.aas.imqBin");
        this._propertyMap.put("AS_CONFIG", "com.sun.aas.configRoot");
        this._propertyMap.put("AS_INSTALL", "com.sun.aas.installRoot");
        this._propertyMap.put("AS_JAVA", "com.sun.aas.javaRoot");
        this._propertyMap.put("AS_ACC_CONFIG", null);
        this._propertyMap.put("AS_JHELP", "com.sun.aas.jhelpRoot");
        this._propertyMap.put("AS_ICU_LIB", "com.sun.aas.icuLib");
        this._propertyMap.put("AS_LOCALE", "com.sun.aas.defaultLocale");
        this._propertyMap.put("AS_DEF_DOMAINS_PATH", "com.sun.aas.domainsRoot");
        this._propertyMap.put("AS_HADB", "com.sun.aas.hadbRoot");
        this._propertyMap.put("AS_NATIVE_LAUNCHER", "com.sun.aas.nativeLauncher");
        this._propertyMap.put("AS_NATIVE_LAUNCHER_LIB_PREFIX", "com.sun.aas.nativeLauncherLibPrefix");
        this._propertyMap.put("AS_JDMK_HOME", "com.sun.aas.jdmkHome");
        this._propertyMap.put("AS_MFWK_HOME", "com.sun.aas.mfwkHome");
    }

    public ASenvPropertyReader(String configDirectory, boolean useLogger) {
        this(configDirectory);
        this.useLogger = useLogger;
    }

    private void setSystemProperty(String line) {
        int pos = line.indexOf("=");
        if (pos > 0) {
            String systemPropertyName;
            String lhs = line.substring(0, pos).trim();
            String rhs = line.substring(pos + 1).trim();
            if (OS.isWindows()) {
                lhs = lhs.substring(3).trim();
            }
            if (OS.isUNIX() && (pos = rhs.indexOf("\"")) != -1 && (pos = (rhs = rhs.substring(pos + 1).trim()).indexOf("\"")) != -1) {
                rhs = rhs.substring(0, pos).trim();
            }
            if ((systemPropertyName = (String)this._propertyMap.get(lhs)) != null && System.getProperty(systemPropertyName) == null) {
                if (_logger != null) {
                    _logger.log(Level.FINE, "System.setProperty " + systemPropertyName + "=" + rhs);
                }
                System.setProperty(systemPropertyName, rhs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemProperties() {
        if (this.useLogger) {
            _logger = LogDomains.getLogger("javax.enterprise.system.util");
        }
        if (System.getProperty("com.sun.aas.hostName") == null) {
            String hostname;
            block25: {
                hostname = "localhost";
                try {
                    hostname = NetUtils.getCanonicalHostName();
                }
                catch (Exception ex) {
                    if (_logger == null) break block25;
                    _logger.log(Level.SEVERE, "property_reader.unknownHost", ex);
                }
            }
            if (_logger != null) {
                _logger.log(Level.FINE, "System.setProperty com.sun.aas.hostName=" + hostname);
            }
            System.setProperty("com.sun.aas.hostName", hostname);
        }
        String fileName = this._configDirectory + File.separatorChar;
        if (OS.isUNIX()) {
            fileName = fileName + "asenv.conf";
        } else if (OS.isWindows()) {
            fileName = fileName + "asenv.bat";
        } else assert (false);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.setSystemProperty(line);
            }
        }
        catch (Exception ex) {
            if (_logger != null) {
                _logger.log(Level.SEVERE, "property_reader.asenvReadError", ex);
            }
        }
        finally {
            block27: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception ex) {
                    if (_logger == null) break block27;
                    _logger.log(Level.WARNING, "property_reader.asenvCloseError", ex);
                }
            }
        }
    }
}

