/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SharedLibrary
implements ComponentInfo,
Serializable {
    private boolean mClassLoaderSelfFirst;
    private ArrayList mClassPathElements;
    private String mDescription;
    private String mInstallRoot;
    private String mName;
    private String mJbiXmlString;
    private transient StringTranslator mTranslator;

    SharedLibrary(String name, String desc, String root, List elementList) {
        this(name, desc, root, false, elementList);
    }

    SharedLibrary(String name, String desc, String root, boolean isSelfFirst, List elementList) {
        this.mTranslator = (StringTranslator)EnvironmentContext.getInstance().getStringTranslatorFor(this);
        if (null == name) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "name"));
        }
        if (null == elementList) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "elementList"));
        }
        if (0 == elementList.size()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_LIST_ARGUMENT", "elementList"));
        }
        this.mName = name;
        this.mDescription = desc;
        this.mInstallRoot = root;
        this.mClassLoaderSelfFirst = isSelfFirst;
        this.mClassPathElements = new ArrayList(elementList);
    }

    SharedLibrary(ComponentInfo slInfo) {
        this.mName = slInfo.getName();
        this.mDescription = slInfo.getDescription();
        this.mInstallRoot = slInfo.getInstallRoot();
        this.mClassLoaderSelfFirst = slInfo.isClassLoaderSelfFirst();
        this.mClassPathElements = new ArrayList<String>(slInfo.getClassPathElements());
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof SharedLibrary)) {
            return false;
        }
        SharedLibrary component = (SharedLibrary)object;
        if (!this.mName.equals(component.getName())) {
            return false;
        }
        if (ComponentType.SHARED_LIBRARY != component.getComponentType()) {
            return false;
        }
        if (null != component.getComponentClassName()) {
            return false;
        }
        if (null != component.getSharedLibraryNames()) {
            return false;
        }
        return this.mClassPathElements.equals(component.getClassPathElements());
    }

    public String getClassPathAsString() {
        String sep = System.getProperty("path.separator");
        Iterator i = this.mClassPathElements.iterator();
        StringBuffer sb = new StringBuffer("");
        boolean first = true;
        while (i.hasNext()) {
            if (!first) {
                sb.append(sep);
            } else {
                first = false;
            }
            sb.append((String)i.next());
        }
        return new String(sb);
    }

    public List getClassPathElements() {
        return this.mClassPathElements;
    }

    public String getComponentClassName() {
        return null;
    }

    public String getInstallRoot() {
        return this.mInstallRoot;
    }

    public ComponentType getComponentType() {
        return ComponentType.SHARED_LIBRARY;
    }

    public String getComponentTypeAsString() {
        return this.mTranslator.getString("SHARED_LIBRARY");
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getName() {
        return this.mName;
    }

    public List getServiceUnitList() {
        return null;
    }

    public List getSharedLibraryNames() {
        return null;
    }

    public ComponentState getStatus() {
        return ComponentState.SHUTDOWN;
    }

    public String getStatusAsString() {
        return ComponentState.SHUTDOWN.toString();
    }

    public String getInstallationDescriptor() {
        return this.mJbiXmlString;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode += this.mName.hashCode();
        hashCode += ComponentType.SHARED_LIBRARY.hashCode();
        return hashCode += this.mClassPathElements.hashCode();
    }

    public boolean isClassLoaderSelfFirst() {
        return this.mClassLoaderSelfFirst;
    }

    public void setClassLoaderSelfFirst(boolean isSelfFirst) {
        this.mClassLoaderSelfFirst = isSelfFirst;
    }

    public void setInstallationDescriptor(String jbiXml) {
        this.mJbiXmlString = jbiXml;
    }

    public String toString() {
        String sep = ",\n";
        StringBuffer b = new StringBuffer();
        b.append("Name = " + this.mName);
        b.append(sep);
        b.append("Description = " + this.mDescription);
        b.append(sep);
        b.append("InstallRoot = " + this.mInstallRoot);
        b.append(sep);
        b.append("ClassLoaderSelfFirst = " + this.mClassLoaderSelfFirst);
        b.append(sep);
        b.append("ClassPathElements = " + this.mClassPathElements);
        return b.toString();
    }

    public String getBootstrapClassName() {
        throw new UnsupportedOperationException();
    }

    public List getBootstrapClassPathElements() {
        throw new UnsupportedOperationException();
    }

    public Map getProperties() {
        throw new UnsupportedOperationException();
    }

    public String getWorkspaceRoot() {
        throw new UnsupportedOperationException();
    }

    public boolean isBootstrapClassLoaderSelfFirst() {
        throw new UnsupportedOperationException();
    }
}

