/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.sun;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.resource.RecoveryResourceListener;
import com.sun.enterprise.resource.RecoveryResourceRegistry;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.framework.JBIFramework;
import com.sun.jbi.framework.sun.RegistryHelper;
import com.sun.jbi.framework.sun.SunASPlatformContext;
import com.sun.jbi.framework.sun.SyncProcessor;
import com.sun.jbi.framework.sun.SystemComponentBootstrap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class SunASJBIFramework
extends JBIFramework
implements LifecycleListener,
Runnable,
RecoveryResourceListener {
    private static final String STRING_TRANSLATOR_NAME = "com.sun.jbi.framework.sun";
    private SunASPlatformContext mPlatform;
    private Thread mSyncThread;
    private RegistryHelper mRegistryHelper;
    private SyncProcessor mSyncProcessor;
    private Logger mLogger;
    private StringTranslator mTranslator;
    private int mLastEvent;
    private boolean mIsActive = true;
    private long mStartTime;
    private int mPhase;
    private static final int PHASE_NONE = 0;
    private static final int PHASE_INIT = 1;
    private static final int PHASE_STARTUP = 2;
    private static final int PHASE_PREPARE = 3;
    private static final int PHASE_READY = 4;
    private static final int PHASE_SHUTDOWN = 5;
    private static final int PHASE_TERMINATE = 6;

    public void handleEvent(LifecycleEvent anEvent) throws ServerLifecycleException {
        try {
            LifecycleEventContext eventContext = anEvent.getLifecycleEventContext();
            if (0 == anEvent.getEventType()) {
                this.mStartTime = System.currentTimeMillis();
                this.mPlatform = new SunASPlatformContext();
                this.mPhase = 0;
                Properties props = (Properties)anEvent.getData();
                RecoveryResourceRegistry.getInstance().addListener((RecoveryResourceListener)this);
                super.init(this.mPlatform, props);
                this.mTranslator = this.getEnvironment().getStringTranslator(STRING_TRANSLATOR_NAME);
                this.mLogger = Logger.getLogger("com.sun.jbi.framework");
                this.mRegistryHelper = new RegistryHelper(this.getEnvironment());
                this.mSyncProcessor = new SyncProcessor(this.getEnvironment(), this.mRegistryHelper);
                this.endPhase(1);
                this.mLogger.fine("JBI:Start Time 0: " + (System.currentTimeMillis() - this.mStartTime));
            } else if (1 == anEvent.getEventType()) {
                if (null != this.getEnvironment()) {
                    long startTime = System.currentTimeMillis();
                    this.mPlatform.setNamingContext(eventContext.getInitialContext());
                    super.startup(this.mPlatform.getNamingContext(), "");
                    this.endPhase(2);
                    this.mLogger.fine("JBI:Start Time 1: " + (System.currentTimeMillis() - this.mStartTime));
                }
            } else if (2 == anEvent.getEventType()) {
                if (null != this.getEnvironment()) {
                    String instanceName = this.mPlatform.getInstanceName();
                    System.setProperty("com.sun.jbi.instanceName", instanceName);
                    Boolean clustered = new Boolean(this.mPlatform.isInstanceClustered(instanceName));
                    System.setProperty("com.sun.jbi.isClustered", clustered.toString());
                    if (clustered.booleanValue()) {
                        String clusterName = this.mPlatform.getTargetName();
                        System.setProperty("com.sun.jbi.clusterName", clusterName);
                    }
                    this.bootstrapSystemComponents();
                    if (this.mRegistryHelper.isActiveStartup()) {
                        if (this.mLastEvent == 1) {
                            this.mLogger.fine("JBI:ActiveStartup");
                            super.prepare();
                            this.endPhase(3);
                        }
                        this.ready();
                        this.endPhase(4);
                    } else {
                        this.enterLazyMode();
                    }
                }
                this.mLogger.fine("JBI:Start Time 2: " + (System.currentTimeMillis() - this.mStartTime));
            } else if (3 == anEvent.getEventType()) {
                this.stopSync();
                if (null != this.getEnvironment()) {
                    super.shutdown();
                }
                this.endPhase(5);
            } else if (4 == anEvent.getEventType()) {
                this.stopSync();
                if (null != this.getEnvironment()) {
                    super.terminate();
                }
                this.endPhase(6);
            } else {
                String msg = "JBIFW0049: Unknown event type (" + anEvent.getEventType() + ").";
                eventContext.log(msg);
                throw new JBIException(msg);
            }
            this.mLastEvent = anEvent.getEventType();
        }
        catch (Throwable ex) {
            throw new ServerLifecycleException(ex);
        }
    }

    public XAResource[] getXAResources() {
        this.mLogger.fine("JBI:getXAResources: " + (System.currentTimeMillis() - this.mStartTime));
        this.waitForPhase(2);
        if (this.mSyncProcessor != null) {
            try {
                if (this.mRegistryHelper.isActiveStartup()) {
                    this.mLogger.fine("JBI:XAActiveStartup");
                    super.prepare();
                    this.endPhase(3);
                    this.mLastEvent = 0;
                }
            }
            catch (Exception e) {
                this.mLogger.warning(this.mTranslator.getString("GET_XA_RESOURCES", e));
            }
        }
        return this.getEnvironment().getNormalizedMessageService().getXAResources();
    }

    private void bootstrapSystemComponents() {
        try {
            SystemComponentBootstrap bootstrap = new SystemComponentBootstrap(this.getEnvironment());
            bootstrap.configureHttpSoapDefaultPorts();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TransactionManager getTransactionManager() throws Exception {
        TransactionManager transactionManager = (TransactionManager)this.getEnvironment().getNamingContext().lookup("java:appserver/TransactionManager");
        return transactionManager;
    }

    public void recoveryStarted() {
        this.mLogger.fine("JBI:recoveryStarted: " + (System.currentTimeMillis() - this.mStartTime));
    }

    public void recoveryCompleted() {
        this.getEnvironment().getNormalizedMessageService().purgeXAResources();
        this.mLogger.fine("JBI:recoveryCompleted: " + (System.currentTimeMillis() - this.mStartTime));
    }

    private void ready() {
        String asyncEnabled = System.getProperty("com.sun.jbi.AsyncReadySync", "true");
        if (Boolean.parseBoolean(asyncEnabled)) {
            this.mSyncThread = new Thread((Runnable)this, "JBI-Ready-Sync");
            this.mSyncThread.setDaemon(true);
            this.mSyncThread.start();
        } else {
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSync() {
        if (this.mSyncThread != null) {
            if (this.mSyncProcessor != null) {
                this.mSyncProcessor.stop();
            }
            try {
                this.mSyncThread.join(60000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.mSyncThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            super.ready(true);
            String syncEnabled = System.getProperty("com.sun.jbi.SyncEnabled", "true");
            if (Boolean.parseBoolean(syncEnabled) && this.mSyncProcessor != null) {
                this.mSyncProcessor.start();
            } else {
                this.mLogger.warning(this.mTranslator.getString("JBI_SYNC_DISABLED"));
            }
            this.mSyncProcessor = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.mSyncThread = null;
        }
    }

    synchronized void endPhase(int phase) {
        this.mLogger.fine("JBI:endPhase-" + phase + ": " + (System.currentTimeMillis() - this.mStartTime));
        this.mPhase = phase;
        this.notifyAll();
    }

    synchronized void waitForPhase(int phase) {
        while (phase > this.mPhase) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mLogger.fine("JBI:waitForPhase-" + phase + ": " + (System.currentTimeMillis() - this.mStartTime));
    }
}

