/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.sun;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.sun.RegistryHelper;
import com.sun.jbi.framework.sun.SyncException;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.system.DeploymentService;
import com.sun.jbi.management.system.InstallationService;
import com.sun.jbi.management.system.ManagementContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncProcessor {
    private static final String STRING_TRANSLATOR_NAME = "com.sun.jbi.management.facade";
    private RegistryHelper mRegistryHelper;
    private ManagementContext mMgrCtx;
    private EnvironmentContext mEnvCtx;
    private Registry mRegistry;
    private Logger mLogger;
    private StringTranslator mTranslator;
    private InstallationService mIS;
    private DeploymentService mDS;
    private MBeanServer mMBeanServer;
    private MBeanServerConnection mDASMBeanServer;
    private Map<String, ObjectName> mCompLifeCycle;
    private volatile boolean mRunning;
    private String mConfigTemplate;
    private String mConfigPath;
    private static final String HTTP_LISTENER = "http-listener-1";
    private static final String HTTPS_LISTENER = "http-listener-2";
    private static final int PORT_OFFSET = 1000;
    private static final String HTTP_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_TOKEN = "${HttpsDefaultPort}";

    public SyncProcessor(EnvironmentContext envCtx, RegistryHelper registryHelper) {
        this.mEnvCtx = envCtx;
        this.mMgrCtx = envCtx.getManagementService().getManagementContext();
        this.mTranslator = this.mEnvCtx.getStringTranslator(STRING_TRANSLATOR_NAME);
        this.mLogger = Logger.getLogger("com.sun.jbi.management");
        SyncProcessor syncProcessor = this;
        this.mIS = syncProcessor.mMgrCtx.getInstallationServiceHandle();
        SyncProcessor syncProcessor2 = this;
        this.mDS = syncProcessor2.mMgrCtx.getDeploymentServiceHandle();
        this.mMBeanServer = envCtx.getMBeanServer();
        this.mCompLifeCycle = new HashMap<String, ObjectName>();
        this.mRegistryHelper = registryHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.mRegistryHelper.isSyncRequired()) {
            try {
                this.mLogger.fine("JBI-Synchronization started.");
                this.mRunning = true;
                this.mRegistry = (Registry)this.mEnvCtx.getRegistry();
                if (this.mRegistryHelper.diffRegistry()) {
                    this.mRegistryHelper.displayActions();
                    if (this.mRunning) {
                        this.applyRuntimeConfiguration();
                    }
                    if (this.mRunning) {
                        this.startComponentsForUndeploy();
                    }
                    if (this.mRunning) {
                        this.undeployOldServiceAssemblies();
                    }
                    if (this.mRunning) {
                        this.undeployEffectedServiceAssemblies();
                    }
                    if (this.mRunning) {
                        this.shutdownOldComponents();
                    }
                    if (this.mRunning) {
                        this.shutdownEffectedComponents();
                    }
                    if (this.mRunning) {
                        this.uninstallOldComponents();
                    }
                    if (this.mRunning) {
                        this.uninstallReplacedComponents();
                    }
                    if (this.mRunning) {
                        this.uninstallOldSharedLibraries();
                    }
                    if (this.mRunning) {
                        this.uninstallReplacedSharedLibraries();
                    }
                    if (this.mRunning) {
                        this.installNewSharedLibraries();
                    }
                    if (this.mRunning) {
                        this.installReplacedSharedLibraries();
                    }
                    if (this.mRunning) {
                        this.updateComponents();
                    }
                    if (this.mRunning) {
                        this.installNewComponents();
                    }
                    if (this.mRunning) {
                        this.installReplacedComponents();
                    }
                    if (this.mRunning) {
                        this.startComponentsForDeploy();
                    }
                    if (this.mRunning) {
                        this.deployNewServiceAssemblies();
                    }
                    if (this.mRunning) {
                        this.configureComponentLifeCycle();
                    }
                    if (this.mRunning) {
                        this.configureServiceAssemblyLifeCycle();
                    }
                }
            }
            catch (Exception ex) {
                this.mLogger.severe(this.mTranslator.getString("JBI_SYNC_FAILED", ex));
            }
            finally {
                if (this.mRegistryHelper != null) {
                    this.mRegistryHelper.cleanup();
                }
                this.mRunning = false;
            }
            this.mLogger.fine("JBI-Synchronization completed.");
        }
    }

    public void stop() {
        this.mLogger.fine("JBI-Synchronization stopped.");
        this.mRunning = false;
    }

    private void installNewSharedLibraries() throws SyncException {
        this.installSharedLibraries(this.mRegistryHelper.getNewSharedLibraries());
    }

    private void installReplacedSharedLibraries() throws SyncException {
        this.installSharedLibraries(this.mRegistryHelper.getReplacedSharedLibraries());
    }

    private void installSharedLibraries(List<String> libraries) throws SyncException {
        for (String slName : libraries) {
            String slFileName = "file://" + this.mRegistryHelper.downloadSharedLibraryArchive(slName);
            String newSlName = this.mIS.installSharedLibrary(slFileName);
        }
    }

    private void uninstallOldSharedLibraries() throws SyncException {
        this.uninstallSharedLibraries(this.mRegistryHelper.getOldSharedLibraries());
    }

    private void uninstallReplacedSharedLibraries() throws SyncException {
        this.uninstallSharedLibraries(this.mRegistryHelper.getReplacedSharedLibraries());
    }

    private void uninstallSharedLibraries(List<String> libraries) throws SyncException {
        for (String slName : libraries) {
            try {
                this.mIS.uninstallSharedLibrary(slName);
            }
            catch (Exception e) {
                throw new SyncException(this.mTranslator.getString("JBI_SYNC_UNINSTALL_SL", slName, e));
            }
        }
    }

    private void installNewComponents() throws SyncException {
        this.installComponents(this.mRegistryHelper.getNewComponents());
    }

    private void installReplacedComponents() throws SyncException {
        this.installComponents(this.mRegistryHelper.getReplacedComponents());
    }

    private void installComponents(List<String> components) throws SyncException {
        for (String compName : components) {
            try {
                String compFileName = "file://" + this.mRegistryHelper.downloadComponentArchive(compName);
                ComponentInfoImpl comp = (ComponentInfoImpl)this.mRegistryHelper.getNewComponentInfo(compName);
                ObjectName compInstaller = this.mIS.loadNewInstaller(compFileName);
                this.configureComponent(compInstaller, compName);
                ObjectName compLifecycle = this.installComponent(compInstaller);
                this.propertyHack(compName);
                this.mIS.unloadInstaller(compName, false);
                if (comp.getUpgradeNumber() != 0L) {
                    this.mIS.upgradeComponent(compName, comp.getUpgradeNumber());
                }
                this.mCompLifeCycle.put(compName, compLifecycle);
            }
            catch (Exception ex) {
                throw new SyncException(this.mTranslator.getString("JBI_SYNC_INSTALL_COMP", compName, ex));
            }
        }
    }

    private ObjectName installComponent(ObjectName installer) throws SyncException {
        JMException e;
        ObjectName compLifecycle = null;
        Object configuration = null;
        try {
            compLifecycle = (ObjectName)this.mMBeanServer.invoke(installer, "install", null, null);
            return compLifecycle;
        }
        catch (InstanceNotFoundException infEx) {
            e = infEx;
        }
        catch (MBeanException mbEx) {
            e = mbEx;
        }
        catch (ReflectionException rEx) {
            e = rEx;
        }
        throw new SyncException(this.mTranslator.getString("JBI_SYNC_INSTALL_COMP", compLifecycle, e));
    }

    private void updateComponents() throws SyncException {
        for (String compName : this.mRegistryHelper.getUpdatedComponents()) {
            try {
                String compFileName = "file://" + this.mRegistryHelper.downloadComponentArchive(compName);
                ComponentInfoImpl comp = (ComponentInfoImpl)this.mRegistryHelper.getNewComponentInfo(compName);
                String status = this.mIS.upgradeComponent(compName, compFileName);
                this.mIS.upgradeComponent(compName, comp.getUpgradeNumber());
            }
            catch (Exception ex) {
                throw new SyncException(this.mTranslator.getString("JBI_SYNC_INSTALL_COMP", compName, ex));
            }
        }
    }

    private void uninstallOldComponents() throws SyncException {
        this.uninstallComponents(this.mRegistryHelper.getOldComponents());
    }

    private void uninstallReplacedComponents() throws SyncException {
        this.uninstallComponents(this.mRegistryHelper.getReplacedComponents());
    }

    private void uninstallComponents(List<String> components) throws SyncException {
        for (String compName : components) {
            try {
                ObjectName compInstaller = this.mIS.loadInstaller(compName);
                this.uninstallComponent(compInstaller);
                this.mIS.unloadInstaller(compName, true);
            }
            catch (Exception ex) {
                throw new SyncException(this.mTranslator.getString("JBI_SYNC_UNINSTALL_COMP", compName, ex));
            }
        }
    }

    private void uninstallComponent(ObjectName installer) throws SyncException {
        JMException e;
        try {
            this.mMBeanServer.invoke(installer, "uninstall", null, null);
            return;
        }
        catch (InstanceNotFoundException infEx) {
            e = infEx;
        }
        catch (MBeanException mbEx) {
            e = mbEx;
        }
        catch (ReflectionException rEx) {
            e = rEx;
        }
        throw new SyncException(this.mTranslator.getString("JBI_SYNC_UNINSTALL_COMP", installer, e));
    }

    private String getComponentState(ObjectName compName) throws SyncException {
        JMException e;
        try {
            return (String)this.mMBeanServer.getAttribute(compName, "CurrentState");
        }
        catch (InstanceNotFoundException infEx) {
            e = infEx;
        }
        catch (MBeanException mbEx) {
            e = mbEx;
        }
        catch (ReflectionException rEx) {
            e = rEx;
        }
        catch (AttributeNotFoundException aEx) {
            e = aEx;
        }
        throw new SyncException(this.mTranslator.getString("JBI_SYNC_GET_COMP_STATE", compName, e));
    }

    private void setComponentState(ObjectName compName, String state) throws SyncException {
        JMException e;
        String operation;
        if (state.equals("Started")) {
            operation = "start";
        } else if (state.equals("Shutdown")) {
            operation = "shutDown";
        } else if (state.equals("Stopped")) {
            operation = "stop";
        } else {
            return;
        }
        try {
            this.mMBeanServer.invoke(compName, operation, null, null);
            return;
        }
        catch (InstanceNotFoundException infEx) {
            e = infEx;
        }
        catch (MBeanException mbEx) {
            e = mbEx;
        }
        catch (ReflectionException rEx) {
            e = rEx;
        }
        throw new SyncException(this.mTranslator.getString("JBI_SYNC_SET_COMP_STATE", compName, e));
    }

    private void configureComponent(ObjectName installer, String compName) throws SyncException {
        ComponentInfo comp = this.mRegistryHelper.getNewComponentInfo(compName);
        Map<String, String> props = comp.getProperties();
        if (!props.isEmpty()) {
            JMException e;
            AttributeList al = new AttributeList();
            for (Map.Entry<String, String> prop : props.entrySet()) {
                al.add(new Attribute(prop.getKey(), prop.getValue()));
            }
            try {
                ObjectName configuration = (ObjectName)this.mMBeanServer.invoke(installer, "getInstallerConfigurationMBean", null, null);
                if (configuration != null) {
                    this.mMBeanServer.setAttributes(configuration, al);
                }
                return;
            }
            catch (InstanceNotFoundException infEx) {
                e = infEx;
            }
            catch (MBeanException mbEx) {
                e = mbEx;
            }
            catch (ReflectionException rEx) {
                e = rEx;
            }
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_SET_COMP_CONFIGURATION", compName, e));
        }
    }

    private void configureComponentLifeCycle() throws SyncException {
        List comps;
        try {
            comps = this.mRegistry.getComponentQuery().getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        }
        catch (RegistryException rEx) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_FAILED", (Object)rEx));
        }
        for (String comp : comps) {
            String actual;
            String desired = ComponentState.getLifeCycleState(this.mRegistryHelper.getNewComponentInfo(comp).getStatus());
            if (desired.equals(actual = this.getComponentState(this.getComponentLifeCycle(comp)))) continue;
            this.setComponentState(this.getComponentLifeCycle(comp), desired);
        }
    }

    private void deployNewServiceAssemblies() throws SyncException {
        for (String saName : this.mRegistryHelper.getNewServiceAssemblies()) {
            String saFileName = "file://" + this.mRegistryHelper.downloadServiceAssemblyArchive(saName);
            try {
                this.mDS.deploy(saFileName);
            }
            catch (Exception ex) {
                throw new SyncException(this.mTranslator.getString("JBI_SYNC_DEPLOY_SA", saName, ex));
            }
        }
    }

    private void undeployOldServiceAssemblies() throws SyncException {
        for (String saName : this.mRegistryHelper.getOldServiceAssemblies()) {
            try {
                if (this.mDS.getState(saName).equals(ServiceAssemblyState.STARTED.toString())) {
                    this.mDS.stop(saName);
                }
                if (this.mDS.getState(saName).equals(ServiceAssemblyState.STOPPED.toString())) {
                    this.mDS.shutDown(saName);
                }
                this.mDS.undeploy(saName);
            }
            catch (Exception ex) {
                throw new SyncException(this.mTranslator.getString("JBI_SYNC_UNDEPLOY_SA", saName, ex));
            }
        }
    }

    private void undeployEffectedServiceAssemblies() throws SyncException {
        for (String saName : this.mRegistryHelper.getEffectedServiceAssemblies()) {
            try {
                if (this.mDS.getState(saName).equals(ServiceAssemblyState.STARTED.toString())) {
                    this.mDS.stop(saName);
                }
                if (this.mDS.getState(saName).equals(ServiceAssemblyState.STOPPED.toString())) {
                    this.mDS.shutDown(saName);
                }
                this.mDS.undeploy(saName);
            }
            catch (Exception ex) {
                throw new SyncException(this.mTranslator.getString("JBI_SYNC_UNDEPLOY_SA", saName, ex));
            }
        }
    }

    private String getServiceAssemblyState(String saName) throws SyncException {
        try {
            return this.mDS.getState(saName);
        }
        catch (Exception ex) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_GET_SA_STATE", saName, ex));
        }
    }

    private void setServiceAssemblyState(String saName, String state) throws SyncException {
        try {
            if (state.equals("Started")) {
                this.mDS.start(saName);
            } else if (state.equals("Shutdown")) {
                this.mDS.shutDown(saName);
            } else if (state.equals("Stopped")) {
                this.mDS.stop(saName);
            }
        }
        catch (Exception ex) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_SET_SA_STATE", saName, state, ex));
        }
    }

    private void configureServiceAssemblyLifeCycle() throws SyncException {
        List<String> sas;
        try {
            sas = this.mRegistry.getServiceAssemblyQuery().getServiceAssemblies();
        }
        catch (RegistryException rEx) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_FAILED", (Object)rEx));
        }
        for (String saName : sas) {
            String actual;
            String desired = ServiceAssemblyState.convertState(this.mRegistryHelper.getNewServiceAssemblyState(saName));
            if (desired.equals(actual = this.getServiceAssemblyState(saName))) continue;
            this.setServiceAssemblyState(saName, desired);
        }
    }

    private void applyRuntimeConfiguration() {
        this.applyGlobalConfiguration(ConfigurationCategory.System);
        this.applyGlobalConfiguration(ConfigurationCategory.Logger);
        this.applyGlobalConfiguration(ConfigurationCategory.Deployment);
        this.applyGlobalConfiguration(ConfigurationCategory.Installation);
        this.applyConfiguration(ConfigurationCategory.System);
        this.applyConfiguration(ConfigurationCategory.Logger);
        this.applyConfiguration(ConfigurationCategory.Deployment);
        this.applyConfiguration(ConfigurationCategory.Installation);
    }

    private void applyGlobalConfiguration(ConfigurationCategory category) {
        Map<String, String> map = this.mRegistryHelper.getGlobalConfigChanges(category.toString());
        if (map != null) {
            this.apply("domain", category, map);
        }
    }

    private void applyConfiguration(ConfigurationCategory category) {
        Map<String, String> map = this.mRegistryHelper.getConfigChanges(category.toString());
        if (map != null) {
            this.apply(this.mEnvCtx.getPlatformContext().getTargetName(), category, map);
        }
    }

    private void apply(String target, ConfigurationCategory category, Map<String, String> map) {
        AttributeList al = new AttributeList();
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (e.getValue() == null) continue;
            al.add(new Attribute(e.getKey(), e.getValue()));
        }
        if (al.size() == 0) {
            return;
        }
        try {
            MBeanNames.ServiceType st = MBeanNames.ServiceType.valueOf(category.toString());
            ObjectName mb = new ObjectName("com.sun.jbi:JbiName=" + target + "," + "ServiceName=ConfigurationService,ControlType=" + ConfigurationBuilder.getControlType(st) + ",ComponentType=System");
            this.mMBeanServer.setAttributes(mb, al);
        }
        catch (Exception e) {
            this.mLogger.fine("Sync: Apply Config: Exception: " + e.toString());
        }
    }

    private void startComponentsForDeploy() throws SyncException {
        List<String> comps = this.mRegistryHelper.componentsToStartForDeploy();
        for (String comp : comps) {
            this.setComponentState(this.getComponentLifeCycle(comp), "Started");
        }
    }

    private void startComponentsForUndeploy() throws SyncException {
        List<String> comps = this.mRegistryHelper.componentsToStartForUndeploy();
        for (String comp : comps) {
            this.setComponentState(this.getComponentLifeCycle(comp), "Started");
        }
    }

    private void shutdownOldComponents() throws SyncException {
        List<String> comps = this.mRegistryHelper.getOldComponents();
        for (String comp : comps) {
            this.setComponentState(this.getComponentLifeCycle(comp), "Shutdown");
        }
    }

    private void shutdownEffectedComponents() throws SyncException {
        List<String> comps = this.mRegistryHelper.getEffectedComponents();
        for (String comp : comps) {
            this.setComponentState(this.getComponentLifeCycle(comp), "Shutdown");
        }
    }

    private ObjectName getComponentLifeCycle(String compName) {
        ObjectName name = this.mCompLifeCycle.get(compName);
        if (name == null) {
            SyncProcessor syncProcessor = this;
            name = syncProcessor.mMgrCtx.getAdminServiceHandle().getComponentByName(compName);
        }
        return name;
    }

    private void propertyHack(String compName) {
        if (compName.equals("sun-http-binding")) {
            this.mConfigPath = this.mRegistryHelper.getNewComponentInfo("sun-http-binding").getWorkspaceRoot() + File.separator + "config.properties";
            this.setHttpSoapDefaultPorts(this.readHttpSoapConfig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readHttpSoapConfig() {
        Properties props = new Properties();
        FileInputStream fis = null;
        this.mConfigTemplate = this.mEnvCtx.getJbiInstallRoot() + File.separator + "lib" + File.separator + "install" + File.separator + "templates" + File.separator + "config.properties";
        try {
            fis = new FileInputStream(this.mConfigTemplate);
            props.load(fis);
        }
        catch (IOException ioEx) {
            this.mLogger.fine(this.mTranslator.getString("JBI_SYNC_HTTP_SOAP_CONFIG_READ_ERROR", this.mConfigTemplate, ioEx.getMessage()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHttpSoapDefaultPorts(Properties props) {
        HttpListener httpsListener;
        HttpListener httpListener;
        ConfigContext mServerConfig = ApplicationServer.getServerContext().getConfigContext();
        try {
            HttpService httpService = ServerBeansFactory.getHttpServiceBean((ConfigContext)mServerConfig);
            httpListener = httpService.getHttpListenerById(HTTP_LISTENER);
            httpsListener = httpService.getHttpListenerById(HTTPS_LISTENER);
        }
        catch (Exception ex) {
            this.mLogger.warning(this.mTranslator.getString("JBI_SYNC_APPSERVER_CONFIG_ERROR", this.mConfigTemplate, ex.getMessage()));
            return;
        }
        int httpPort = Integer.parseInt(httpListener.getPort()) + 1000;
        int httpsPort = Integer.parseInt(httpsListener.getPort()) + 1000;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (entry.getValue().equals(HTTP_TOKEN)) {
                entry.setValue(String.valueOf(httpPort));
                continue;
            }
            if (!entry.getValue().equals(HTTPS_TOKEN)) continue;
            entry.setValue(String.valueOf(httpsPort));
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.mConfigPath);
            props.store(fos, null);
        }
        catch (IOException ioEx) {
            this.mLogger.warning(this.mTranslator.getString("JBI_SYNC_HTTP_SOAP_CONFIG_WRITE_ERROR", this.mConfigPath, ioEx.getMessage()));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioEx) {}
            }
        }
    }
}

