/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceAssemblyInfo;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.registry.data.ServiceAssemblyInfoImpl;
import com.sun.jbi.management.registry.xml.ConfigCategoryType;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.registry.xml.PropertyType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryDiff {
    List<String> mAddComponents;
    List<String> mRemoveComponents;
    List<String> mReplaceComponents;
    List<String> mUpdateComponents;
    List<String> mAddSharedLibraries;
    List<String> mRemoveSharedLibraries;
    List<String> mReplaceSharedLibraries;
    List<String> mAddServiceAssemblies;
    List<String> mRemoveServiceAssemblies;
    List<String> mReplaceServiceAssemblies;
    List<String> mAllTargetComponents;
    List<String> mAllMasterComponents;
    List<String> mComponentsEffectedByChanges;
    List<String> mServiceAssembliesEffectedByChanges;
    List<String> mChangedLifecycleComponents;
    List<String> mChangedLifecycleServiceAssemblies;
    Map<String, ComponentInfo> mMasterSharedLibraries;
    Map<String, ComponentInfo> mTargetSharedLibraries;
    Map<String, ComponentInfo> mMasterComponents;
    Map<String, ComponentInfo> mTargetComponents;
    Map<String, ServiceAssemblyInfo> mMasterServiceAssemblies;
    Map<String, ServiceAssemblyInfo> mTargetServiceAssemblies;
    Map<String, HashMap> mDomainConfigChanges;
    Map<String, HashMap> mInstanceConfigChanges;
    Map<String, HashMap> mDomainConfigValues;
    ComponentQuery mMasterQuery;
    ComponentQuery mTargetQuery;
    ServiceAssemblyQuery mMasterSAQuery;
    ServiceAssemblyQuery mTargetSAQuery;
    GenericQueryImpl mMasterCQuery;
    GenericQueryImpl mTargetCQuery;
    String mTarget;
    boolean mChanges;

    public RegistryDiff(Registry master, Registry target, String targetName) {
        this.mTarget = targetName;
        this.mAddComponents = new LinkedList<String>();
        this.mAddSharedLibraries = new LinkedList<String>();
        this.mAddServiceAssemblies = new LinkedList<String>();
        this.mRemoveComponents = new LinkedList<String>();
        this.mRemoveSharedLibraries = new LinkedList<String>();
        this.mRemoveServiceAssemblies = new LinkedList<String>();
        this.mReplaceComponents = new LinkedList<String>();
        this.mReplaceSharedLibraries = new LinkedList<String>();
        this.mReplaceServiceAssemblies = new LinkedList<String>();
        this.mUpdateComponents = new LinkedList<String>();
        this.mAllTargetComponents = new LinkedList<String>();
        this.mAllMasterComponents = new LinkedList<String>();
        this.mComponentsEffectedByChanges = new LinkedList<String>();
        this.mServiceAssembliesEffectedByChanges = new LinkedList<String>();
        this.mChangedLifecycleComponents = new LinkedList<String>();
        this.mChangedLifecycleServiceAssemblies = new LinkedList<String>();
        this.mMasterComponents = new HashMap<String, ComponentInfo>();
        this.mTargetComponents = new HashMap<String, ComponentInfo>();
        this.mMasterSharedLibraries = new HashMap<String, ComponentInfo>();
        this.mTargetSharedLibraries = new HashMap<String, ComponentInfo>();
        this.mMasterServiceAssemblies = new HashMap<String, ServiceAssemblyInfo>();
        this.mTargetServiceAssemblies = new HashMap<String, ServiceAssemblyInfo>();
        this.mDomainConfigChanges = new HashMap<String, HashMap>();
        this.mInstanceConfigChanges = new HashMap<String, HashMap>();
        this.mDomainConfigValues = new HashMap<String, HashMap>();
        this.mChanges = false;
        try {
            this.mMasterQuery = master.getComponentQuery(targetName);
            this.mTargetQuery = target.getComponentQuery(targetName);
            this.mMasterSAQuery = master.getServiceAssemblyQuery(targetName);
            this.mTargetSAQuery = target.getServiceAssemblyQuery(targetName);
            this.mMasterCQuery = (GenericQueryImpl)master.getGenericQuery();
            this.mTargetCQuery = (GenericQueryImpl)target.getGenericQuery();
        }
        catch (RegistryException reX) {
            // empty catch block
        }
    }

    public boolean computeDiff() {
        this.diffSharedLibraries();
        this.diffComponents();
        this.diffServiceAssemblies();
        this.diffConfigs();
        this.analyzeSharedLibraries();
        this.analyzeComponents();
        this.analyzeServiceAssemblies();
        this.analyzeConfigs();
        return this.mChanges;
    }

    void diffComponents() {
        List masterIds = this.mMasterQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        List targetIds = this.mTargetQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        this.mAllMasterComponents = masterIds;
        this.mAllTargetComponents = targetIds;
        for (String component : masterIds) {
            if (!targetIds.contains(component)) {
                this.mAddComponents.add(component);
                this.mChanges = true;
                continue;
            }
            this.mReplaceComponents.add(component);
        }
        for (String component : targetIds) {
            if (masterIds.contains(component)) continue;
            this.mRemoveComponents.add(component);
            this.mChanges = true;
        }
    }

    void diffSharedLibraries() {
        List masterIds = this.mMasterQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        List targetIds = this.mTargetQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        for (String component : masterIds) {
            if (!targetIds.contains(component)) {
                this.mAddSharedLibraries.add(component);
                this.mChanges = true;
                continue;
            }
            this.mReplaceSharedLibraries.add(component);
        }
        for (String component : targetIds) {
            if (masterIds.contains(component)) continue;
            this.mRemoveSharedLibraries.add(component);
            this.mChanges = true;
        }
    }

    void diffServiceAssemblies() {
        List<String> masterIds = this.mMasterSAQuery.getServiceAssemblies();
        List<String> targetIds = this.mTargetSAQuery.getServiceAssemblies();
        for (String component : masterIds) {
            if (!targetIds.contains(component)) {
                this.mAddServiceAssemblies.add(component);
                this.mChanges = true;
                continue;
            }
            this.mReplaceServiceAssemblies.add(component);
        }
        for (String component : targetIds) {
            if (masterIds.contains(component)) continue;
            this.mRemoveServiceAssemblies.add(component);
            this.mChanges = true;
        }
    }

    void diffConfigs() {
        this.getConfigForCategory("domain", ConfigurationCategory.Deployment, this.mDomainConfigChanges, this.mDomainConfigValues);
        this.getConfigForCategory("domain", ConfigurationCategory.Installation, this.mDomainConfigChanges, this.mDomainConfigValues);
        this.getConfigForCategory("domain", ConfigurationCategory.System, this.mDomainConfigChanges, this.mDomainConfigValues);
        if (this.mDomainConfigChanges.size() != 0) {
            this.mChanges = true;
        }
        this.getConfigForCategory(this.mTarget, ConfigurationCategory.Deployment, this.mInstanceConfigChanges, null);
        this.getConfigForCategory(this.mTarget, ConfigurationCategory.Installation, this.mInstanceConfigChanges, null);
        this.getConfigForCategory(this.mTarget, ConfigurationCategory.System, this.mInstanceConfigChanges, null);
        if (this.mInstanceConfigChanges.size() != 0) {
            this.mChanges = true;
        }
    }

    private void getConfigForCategory(String target, ConfigurationCategory cc, Map<String, HashMap> map, Map<String, HashMap> valueMap) {
        ConfigCategoryType mcct = this.mMasterCQuery.getConfigCategory(target, cc);
        ConfigCategoryType tcct = this.mTargetCQuery.getConfigCategory(target, cc);
        List<PropertyType> mprop = null;
        LinkedList<PropertyType> tprop = null;
        HashMap<String, String> changes = new HashMap<String, String>();
        HashMap<String, String> values = new HashMap<String, String>();
        if (mcct != null) {
            mprop = mcct.getProperty();
        }
        if (tcct != null) {
            tprop = new LinkedList<PropertyType>();
            tprop.addAll(tcct.getProperty());
        }
        if (mprop != null) {
            for (PropertyType mp : mprop) {
                String name = mp.getName();
                String value = mp.getValue();
                PropertyType match = null;
                values.put(name, value);
                if (tprop != null) {
                    Iterator i = tprop.iterator();
                    while (i.hasNext()) {
                        PropertyType tp = (PropertyType)i.next();
                        if (!tp.getName().equals(name)) continue;
                        if (!value.equals(tp.getValue())) break;
                        i.remove();
                        match = tp;
                        break;
                    }
                }
                if (match != null) continue;
                changes.put(name, value);
            }
        }
        if (tprop != null) {
            for (PropertyType tp : tprop) {
                changes.put(tp.getName(), null);
            }
        }
        map.put(cc.name(), changes);
        if (valueMap != null) {
            valueMap.put(cc.name(), values);
        }
    }

    void analyzeSharedLibraries() {
        ComponentInfo master;
        LinkedList<String> noChange = new LinkedList<String>();
        for (String component : this.mAddSharedLibraries) {
            master = this.mMasterQuery.getSharedLibraryInfo(component);
            this.mMasterSharedLibraries.put(component, master);
        }
        for (String component : this.mRemoveSharedLibraries) {
            ComponentInfo target = this.mTargetQuery.getSharedLibraryInfo(component);
            this.mTargetSharedLibraries.put(component, target);
        }
        for (String component : this.mReplaceSharedLibraries) {
            master = this.mMasterQuery.getSharedLibraryInfo(component);
            ComponentInfo target = this.mTargetQuery.getSharedLibraryInfo(component);
            this.mMasterSharedLibraries.put(component, master);
            this.mTargetSharedLibraries.put(component, target);
            if (((ComponentInfoImpl)master).getTimestamp() == ((ComponentInfoImpl)target).getTimestamp()) {
                noChange.add(component);
                continue;
            }
            this.mChanges = true;
        }
        this.mReplaceSharedLibraries.removeAll(noChange);
    }

    void analyzeComponents() {
        ComponentInfo master;
        LinkedList<String> noChange = new LinkedList<String>();
        for (String component : this.mAddComponents) {
            master = this.mMasterQuery.getComponentInfo(component);
            this.mMasterComponents.put(component, master);
        }
        for (String component : this.mRemoveComponents) {
            ComponentInfo target = this.mTargetQuery.getComponentInfo(component);
            this.mTargetComponents.put(component, target);
        }
        for (String component : this.mReplaceComponents) {
            master = this.mMasterQuery.getComponentInfo(component);
            ComponentInfo target = this.mTargetQuery.getComponentInfo(component);
            this.mMasterComponents.put(component, master);
            this.mTargetComponents.put(component, target);
            if (((ComponentInfoImpl)master).getTimestamp() == ((ComponentInfoImpl)target).getTimestamp()) {
                noChange.add(component);
                if (((ComponentInfoImpl)master).getUpgradeNumber() != ((ComponentInfoImpl)target).getUpgradeNumber()) {
                    this.mUpdateComponents.add(component);
                    continue;
                }
                if (master.getStatus().equals((Object)target.getStatus())) continue;
                this.mChangedLifecycleComponents.add(component);
            }
            this.mChanges = true;
        }
        this.mReplaceComponents.removeAll(noChange);
        for (String component : this.mAllTargetComponents) {
            ComponentInfo comp = this.mTargetComponents.get(component);
            for (String sl : comp.getSharedLibraryNames()) {
                if (!this.mReplaceSharedLibraries.contains(sl) || this.mComponentsEffectedByChanges.contains(component)) continue;
                this.mComponentsEffectedByChanges.add(component);
            }
        }
    }

    void analyzeServiceAssemblies() {
        ServiceAssemblyInfo master;
        LinkedList<String> noChange = new LinkedList<String>();
        for (String sa : this.mAddServiceAssemblies) {
            master = this.mMasterSAQuery.getServiceAssemblyInfo(sa);
            this.mMasterServiceAssemblies.put(sa, master);
        }
        for (String sa : this.mRemoveServiceAssemblies) {
            ServiceAssemblyInfo target = this.mTargetSAQuery.getServiceAssemblyInfo(sa);
            this.mTargetServiceAssemblies.put(sa, target);
        }
        for (String assembly : this.mReplaceServiceAssemblies) {
            master = this.mMasterSAQuery.getServiceAssemblyInfo(assembly);
            ServiceAssemblyInfo target = this.mTargetSAQuery.getServiceAssemblyInfo(assembly);
            this.mMasterServiceAssemblies.put(assembly, master);
            this.mTargetServiceAssemblies.put(assembly, target);
            if (((ServiceAssemblyInfoImpl)master).getTimestamp() == ((ServiceAssemblyInfoImpl)target).getTimestamp()) {
                noChange.add(assembly);
                if (master.getStatus().equals((Object)target.getStatus())) continue;
                this.mChangedLifecycleServiceAssemblies.add(assembly);
            }
            this.mChanges = true;
        }
        this.mReplaceServiceAssemblies.removeAll(noChange);
        LinkedList<String> comps = new LinkedList<String>();
        comps.addAll(this.mReplaceComponents);
        comps.addAll(this.mComponentsEffectedByChanges);
        for (String compName : comps) {
            ComponentInfo comp = this.mTargetComponents.get(compName);
            for (ServiceUnitInfo sui : comp.getServiceUnitList()) {
                if (this.mServiceAssembliesEffectedByChanges.contains(sui.getServiceAssemblyName())) continue;
                this.mServiceAssembliesEffectedByChanges.add(sui.getServiceAssemblyName());
            }
        }
    }

    void analyzeConfigs() {
        for (Map.Entry<String, HashMap> m : this.mInstanceConfigChanges.entrySet()) {
            String category = m.getKey();
            Map props = m.getValue();
            for (Map.Entry entry : props.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue((String)this.mDomainConfigValues.get(category).get(entry.getKey()));
            }
        }
    }

    public List<String> componentsToStartForUndeploy() {
        LinkedList<String> componentsToStart = new LinkedList<String>();
        block0: for (String component : this.mAllTargetComponents) {
            ComponentInfo comp = this.mTargetComponents.get(component);
            for (ServiceUnitInfo su : comp.getServiceUnitList()) {
                if (!this.mRemoveServiceAssemblies.contains(su.getServiceAssemblyName()) && !this.mReplaceServiceAssemblies.contains(su.getServiceAssemblyName()) && !this.mServiceAssembliesEffectedByChanges.contains(su.getServiceAssemblyName())) continue;
                componentsToStart.add(component);
                continue block0;
            }
        }
        return componentsToStart;
    }

    public List<String> componentsToStartForDeploy() {
        LinkedList<String> componentsToStart = new LinkedList<String>();
        block0: for (String component : this.mAllMasterComponents) {
            ComponentInfo comp = this.mMasterComponents.get(component);
            for (ServiceUnitInfo su : comp.getServiceUnitList()) {
                if (!this.mAddServiceAssemblies.contains(su.getServiceAssemblyName())) continue;
                componentsToStart.add(component);
                continue block0;
            }
        }
        return componentsToStart;
    }

    public ServiceAssemblyState getNewServiceAssemblyState(String saName) {
        LinkedList componentsToStart = new LinkedList();
        LinkedList<ServiceUnitState> suStates = new LinkedList<ServiceUnitState>();
        block0: for (String component : this.mAllMasterComponents) {
            ComponentInfo comp = this.mMasterComponents.get(component);
            for (ServiceUnitInfo su : comp.getServiceUnitList()) {
                if (!su.getServiceAssemblyName().equals(saName)) continue;
                suStates.add(su.getState());
                continue block0;
            }
        }
        return ServiceAssemblyState.computeServiceAssemblyState(suStates);
    }

    public List<String> getNewSharedLibraries() {
        return this.mAddSharedLibraries;
    }

    public ComponentInfo getNewSharedLibraryInfo(String slName) {
        return this.mMasterSharedLibraries.get(slName);
    }

    public List<String> getOldSharedLibraries() {
        return this.mRemoveSharedLibraries;
    }

    public List<String> getReplacedSharedLibraries() {
        return this.mReplaceSharedLibraries;
    }

    public List<String> getNewComponents() {
        return this.mAddComponents;
    }

    public ComponentInfo getNewComponentInfo(String compName) {
        return this.mMasterComponents.get(compName);
    }

    public List<String> getOldComponents() {
        return this.mRemoveComponents;
    }

    public List<String> getEffectedComponents() {
        return this.mComponentsEffectedByChanges;
    }

    public List<String> getUpdatedComponents() {
        return this.mUpdateComponents;
    }

    public List<String> getReplacedComponents() {
        return this.mReplaceComponents;
    }

    public List<String> getChangedLifeCycleComponents() {
        return this.mChangedLifecycleComponents;
    }

    public ServiceAssemblyInfo getNewServiceAssemblyInfo(String saName) {
        return this.mMasterServiceAssemblies.get(saName);
    }

    public List<String> getNewServiceAssemblies() {
        return this.mAddServiceAssemblies;
    }

    public List<String> getOldServiceAssemblies() {
        return this.mRemoveServiceAssemblies;
    }

    public List<String> getEffectedServiceAssemblies() {
        return this.mServiceAssembliesEffectedByChanges;
    }

    public List<String> getChangedLifeCycleServiceAssemblies() {
        return this.mChangedLifecycleServiceAssemblies;
    }

    public Map<String, String> getGlobalConfigChanges(String category) {
        return this.mDomainConfigChanges.get(category);
    }

    public Map<String, String> getConfigChanges(String category) {
        return this.mInstanceConfigChanges.get(category);
    }

    public String toString() {
        Set x;
        StringBuilder sb = new StringBuilder();
        sb.append("Registry Differences for Target: " + this.mTarget + "\n  Remove Shared Libraries:\n");
        for (String string : this.mRemoveSharedLibraries) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Add Shared Libraries:\n");
        for (String string : this.mAddSharedLibraries) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Replace Shared Libraries:\n");
        for (String string : this.mReplaceSharedLibraries) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Remove Components:\n");
        for (String string : this.mRemoveComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Add Components:\n");
        for (String string : this.mAddComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Update Components:\n");
        for (String string : this.mUpdateComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Effected Components:\n");
        for (String string : this.mComponentsEffectedByChanges) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Replace Components:\n");
        for (String string : this.mReplaceComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Change Components Lifecycle:\n");
        for (String string : this.mChangedLifecycleComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Remove Service Assemblies:\n");
        for (String string : this.mRemoveServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Add Service Assemblies:\n");
        for (String string : this.mAddServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Replace Service Assemblies:\n");
        for (String string : this.mReplaceServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Change Service Assemblies Lifecycle:\n");
        for (String string : this.mChangedLifecycleServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Effected Service Assemblies:\n");
        for (String string : this.mServiceAssembliesEffectedByChanges) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Components to Start for Undeploy:\n");
        for (String string : this.componentsToStartForUndeploy()) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Components to Start for Deploy:\n");
        for (String string : this.componentsToStartForDeploy()) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Domain config changes:\n");
        for (Map.Entry entry : this.mDomainConfigChanges.entrySet()) {
            sb.append("    Category: " + (String)entry.getKey() + "\n");
            x = ((HashMap)entry.getValue()).entrySet();
            for (Map.Entry c : x) {
                if (c.getValue() == null) {
                    sb.append("      Delete Name(" + c.getKey() + ")\n");
                    continue;
                }
                sb.append("      Change Name(" + c.getKey() + ") Value(" + c.getValue() + ")\n");
            }
        }
        sb.append("  Instance config changes:\n");
        for (Map.Entry entry : this.mInstanceConfigChanges.entrySet()) {
            sb.append("    Category: " + (String)entry.getKey() + "\n");
            x = ((HashMap)entry.getValue()).entrySet();
            for (Map.Entry c : x) {
                if (c.getValue() == null) {
                    sb.append("      Delete Name(" + c.getKey() + ")\n");
                    continue;
                }
                sb.append("      Change Name(" + c.getKey() + ") Value(" + c.getValue() + ")\n");
            }
        }
        return sb.toString();
    }
}

