/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.support;

import com.sun.jbi.management.common.LoggerMBean;
import com.sun.jbi.management.support.DefaultLoggerMBeanImpl;
import com.sun.jbi.management.support.MBeanHelper;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistentLoggerMBeanImpl
extends DefaultLoggerMBeanImpl
implements LoggerMBean {
    public PersistentLoggerMBeanImpl(Logger aLogger) {
        this(aLogger, aLogger.getName());
    }

    public PersistentLoggerMBeanImpl(Logger aLogger, String aDisplayName) {
        super(aLogger, aDisplayName);
        Level level = MBeanHelper.getLogLevel(this.mLogger.getName(), EnvironmentAccess.getContext());
        if (level != null) {
            this.mLogger.setLevel(level);
        }
    }

    public int setAll() {
        super.setAll();
        this.persistLogLevel();
        return 0;
    }

    public int setConfig() {
        super.setConfig();
        this.persistLogLevel();
        return 0;
    }

    public int setDefault() {
        super.setDefault();
        this.revertToGlobalLogLevel();
        return 0;
    }

    public int setFine() {
        super.setFine();
        this.persistLogLevel();
        return 0;
    }

    public int setFiner() {
        super.setFiner();
        this.persistLogLevel();
        return 0;
    }

    public int setFinest() {
        super.setFinest();
        this.persistLogLevel();
        return 0;
    }

    public int setInfo() {
        super.setInfo();
        this.persistLogLevel();
        return 0;
    }

    public int setOff() {
        super.setOff();
        this.persistLogLevel();
        return 0;
    }

    public int setSevere() {
        super.setSevere();
        this.persistLogLevel();
        return 0;
    }

    public int setWarning() {
        super.setWarning();
        this.persistLogLevel();
        return 0;
    }

    private void persistLogLevel() {
        MBeanHelper.setLogLevel(this.getLoggerName(), this.mLogger.getLevel().toString(), EnvironmentAccess.getContext(), this.mLogger);
    }

    private void revertToGlobalLogLevel() {
        MBeanHelper.revertToGlobalLogLevel(this.getLoggerName(), EnvironmentAccess.getContext(), this.mLogger);
    }
}

