/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.ComponentQuery;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.JbiNameInfo;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.common.LoggerMBean;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.support.MBeanNamesImpl;
import com.sun.jbi.management.support.MBeanSet;
import com.sun.jbi.management.support.PersistentLoggerMBeanImpl;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.management.LifeCycleMBean;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class ModelSystemService
implements LifeCycleMBean,
LoggerMBean,
NotificationEmitter {
    protected ObjectName mAdminServiceMBeanName;
    protected ObjectName mConfigServiceMBeanName;
    protected ObjectName mInstallServiceMBeanName;
    protected ObjectName mLoggingServiceMBeanName;
    protected ObjectName mDeployServiceMBeanName;
    protected ObjectName mMessageServiceMBeanName;
    protected EnvironmentContext mEnv;
    protected MBeanSet mInitialMBeans;
    protected MBeanSet mStartMBeans;
    protected Logger mLogger;
    protected MBeanServer mMBeanServer;
    protected MBeanNames mMBeanNames;
    protected JbiNameInfo mJbiNameInfo;
    protected String mDisplayName;
    protected LoggerMBean mLoggerImpl;
    protected ObjectName mConfigMBeanName;
    protected ObjectName mLifeCycleMBeanName;
    protected ObjectName mLoggerMBeanName;
    protected ObjectName mStatisticsMBeanName;
    protected final String mModelName = "ModelSystemService";
    protected StringTranslator mTranslator;
    private NotificationBroadcasterSupport mEmitter = new NotificationBroadcasterSupport();

    protected void initModelSystemService(EnvironmentContext anEnv, JbiNameInfo aJbiName) {
        this.mLogger = Logger.getLogger(this.getClass().getName());
        this.initModelSystemService(anEnv, this.mLogger, aJbiName);
    }

    protected void initModelSystemService(EnvironmentContext anEnv, Logger aLogger, JbiNameInfo aJbiName) {
        this.mEnv = anEnv;
        this.mJbiNameInfo = aJbiName;
        this.mDisplayName = aJbiName.name();
        this.mLogger = aLogger;
        this.mLoggerImpl = new PersistentLoggerMBeanImpl(this.mLogger, this.mDisplayName);
        this.mMBeanServer = this.mEnv.getMBeanServer();
        try {
            MBeanNamesImpl mbnamesImpl = new MBeanNamesImpl(this.mEnv.getMBeanNames().getJmxDomainName(), this.mEnv.getPlatformContext().getInstanceName());
            this.mMBeanNames = mbnamesImpl;
            this.mInitialMBeans = new MBeanSet(this.mMBeanServer, this.mLogger);
            this.mStartMBeans = new MBeanSet(this.mMBeanServer, this.mLogger);
            this.initModelSystemMBeanNames();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.mTranslator = this.mEnv.getStringTranslator("com.sun.jbi.management");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mLogger.fine("initModelSystemService: Initialization complete for " + this.mJbiNameInfo.name());
    }

    protected void bootstrap() {
        this.mLogger.fine("ModelSystemService: START bootstrap for '" + this.mJbiNameInfo.name() + "'");
        this.mInitialMBeans.register();
        this.mLogger.fine("ModelSystemService: FINISH bootstrap for '" + this.mJbiNameInfo.name() + "'");
    }

    public void start() throws JBIException {
        this.mStartMBeans.register();
    }

    public void stop() throws JBIException {
        this.mStartMBeans.unregister();
    }

    public void shutDown() throws JBIException {
        try {
            this.mMBeanServer.invoke(this.mLifeCycleMBeanName, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.mLogger.warning(e.toString());
            e.printStackTrace();
        }
        try {
            this.mInitialMBeans.unregister();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCurrentState() {
        return "Unknown";
    }

    public String getDisplayName() {
        return this.mLoggerImpl.getDisplayName();
    }

    public String getLogLevel() {
        return this.mLoggerImpl.getLogLevel();
    }

    public String getLoggerName() {
        return this.mLoggerImpl.getLoggerName();
    }

    public int setAll() {
        return this.mLoggerImpl.setAll();
    }

    public int setConfig() {
        return this.mLoggerImpl.setConfig();
    }

    public int setDefault() {
        return this.mLoggerImpl.setDefault();
    }

    public int setFine() {
        return this.mLoggerImpl.setFine();
    }

    public int setFiner() {
        return this.mLoggerImpl.setFiner();
    }

    public int setFinest() {
        return this.mLoggerImpl.setFinest();
    }

    public int setInfo() {
        return this.mLoggerImpl.setInfo();
    }

    public int setOff() {
        return this.mLoggerImpl.setOff();
    }

    public int setSevere() {
        return this.mLoggerImpl.setSevere();
    }

    public int setWarning() {
        return this.mLoggerImpl.setWarning();
    }

    protected Registry getRegistry() {
        return (Registry)this.mEnv.getRegistry();
    }

    protected ComponentQuery getComponentQuery() {
        try {
            return this.getRegistry().getComponentQuery();
        }
        catch (RegistryException regEx) {
            throw new RuntimeException(regEx.getMessage());
        }
    }

    private void initModelSystemMBeanNames() {
        this.mLifeCycleMBeanName = this.mMBeanNames.getSystemServiceMBeanName(this.mJbiNameInfo.name(), "Lifecycle");
        this.mInitialMBeans.add(this.mLifeCycleMBeanName, LifeCycleMBean.class, this);
        this.mLoggerMBeanName = this.mMBeanNames.getSystemServiceLoggerMBeanName(this.mJbiNameInfo.name(), this.mLogger);
        this.mInitialMBeans.add(this.mLoggerMBeanName, LoggerMBean.class, this);
        this.mLoggerMBeanName = this.mMBeanNames.getSystemServiceMBeanName(this.mJbiNameInfo.name(), "Statistics");
        this.initSystemServiceMBeanNames();
    }

    private void initSystemServiceMBeanNames() {
        this.mAdminServiceMBeanName = this.mMBeanNames.getSystemServiceMBeanName("AdminService", "AdministrationService");
        this.mConfigServiceMBeanName = this.mMBeanNames.getSystemServiceMBeanName("ConfigurationService", "ConfigurationService");
        this.mDeployServiceMBeanName = this.mMBeanNames.getSystemServiceMBeanName("DeploymentService", "DeploymentService");
        this.mInstallServiceMBeanName = this.mMBeanNames.getSystemServiceMBeanName("InstallationService", "InstallationService");
        this.mLoggingServiceMBeanName = this.mMBeanNames.getSystemServiceMBeanName("LoggingService", "LoggingService");
        this.mMessageServiceMBeanName = this.mMBeanNames.getSystemServiceMBeanName("MessageService", "MessageService");
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.mEmitter.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.mEmitter.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.mEmitter.removeNotificationListener(listener, filter, handback);
    }

    public NotificationBroadcasterSupport getNotificationBroadcaster() {
        return this.mEmitter;
    }
}

