/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.system.ManagementContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LockManager {
    private ReentrantReadWriteLock mLock;
    private Logger mLogger;
    private String mLockName;
    private static long DEFAULT_LOCK_WAIT_INTERVAL = 60L;
    private StringTranslator mTranslator;
    private long mLockWaitInterval;
    static final String STRING_TRANSLATOR_NAME = "com.sun.jbi.management";

    public LockManager(ReentrantReadWriteLock lock, String lockName, ManagementContext ctx, String lockInterval) {
        this.mLock = lock;
        this.mLockName = lockName;
        this.mLogger = ctx.getLogger();
        this.mTranslator = ctx.getEnvironmentContext().getStringTranslator(STRING_TRANSLATOR_NAME);
        if (lockInterval == null) {
            this.mLockWaitInterval = DEFAULT_LOCK_WAIT_INTERVAL;
        } else {
            try {
                this.mLockWaitInterval = Long.parseLong(lockInterval);
            }
            catch (NumberFormatException nex) {
                this.mLockWaitInterval = DEFAULT_LOCK_WAIT_INTERVAL;
            }
        }
        this.mLogger.fine("Lock wait interval for lock " + lockName + " is " + this.mLockWaitInterval + " seconds.");
    }

    public void acquireReadLock() throws RegistryException {
        if (this.mLogger.getLevel() == Level.FINEST) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_ATTEMPT_READ_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
        boolean acquired = false;
        try {
            acquired = this.mLock.readLock().tryLock(this.mLockWaitInterval, TimeUnit.SECONDS);
        }
        catch (InterruptedException iex) {
            acquired = false;
        }
        if (!acquired) {
            if (this.mLogger.getLevel() == Level.FINEST) {
                this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_THREAD_FAILED_ACQUIRE_READ_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName, new Long(this.mLockWaitInterval).toString()));
            }
            throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_FAILED_ACQUIRE_READ_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
        if (this.mLogger.getLevel() == Level.FINEST) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_ACQUIRED_READ_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
    }

    public void acquireWriteLock() throws RegistryException {
        if (this.mLogger.getLevel() == Level.FINEST) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_ATTEMPT_WRITE_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
        boolean acquired = false;
        try {
            acquired = this.mLock.writeLock().tryLock(this.mLockWaitInterval, TimeUnit.SECONDS);
        }
        catch (InterruptedException iex) {
            acquired = false;
        }
        if (!acquired) {
            if (this.mLogger.getLevel() == Level.FINEST) {
                this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_THREAD_FAILED_ACQUIRE_WRITE_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName, new Long(this.mLockWaitInterval).toString()));
            }
            throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_FAILED_ACQUIRE_WRITE_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
        if (this.mLogger.getLevel() == Level.FINEST) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_ACQUIRED_WRITE_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
    }

    public void releaseReadLock() {
        this.mLock.readLock().unlock();
        if (this.mLogger.getLevel() == Level.FINEST) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_RELEASED_READ_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
    }

    public void releaseWriteLock() {
        if (this.mLock.isWriteLockedByCurrentThread()) {
            this.mLock.writeLock().unlock();
            if (this.mLogger.getLevel() == Level.FINEST) {
                this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_RELEASED_WRITE_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
            }
        }
    }

    public void downgradeWriteLock() throws RegistryException {
        if (this.mLogger.getLevel() == Level.FINEST) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_ATTEMPT_DOWNGRADE_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
        this.acquireReadLock();
        this.releaseWriteLock();
        if (this.mLogger.getLevel() == Level.FINEST) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_DOWNGRADED_LOCK", Thread.currentThread().getName(), this.getCallerInformation(), this.mLockName));
        }
    }

    private String getCallerInformation() {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer strBuf = new StringBuffer();
        if (callStack.length >= 5) {
            StackTraceElement top = callStack[4];
            strBuf.append("[ Class: ");
            strBuf.append(top.getClassName());
            strBuf.append(", Method: ");
            strBuf.append(top.getMethodName());
            strBuf.append(", Line: ");
            strBuf.append(top.getLineNumber());
            strBuf.append("]");
        }
        return strBuf.toString();
    }
}

