/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.Link;
import com.sun.jbi.messaging.RegisteredEndpoint;
import javax.xml.namespace.QName;

public class LinkedEndpoint
extends RegisteredEndpoint {
    private static final String OWNER_ID = "linked";
    private QName mServiceLink;
    private String mEndpointLink;
    private Link mLinkType;

    public LinkedEndpoint(QName fromService, String fromEndpoint, QName toService, String toEndpoint, Link linkType) {
        super(fromService, fromEndpoint, OWNER_ID);
        this.mLinkType = linkType;
        this.mServiceLink = toService;
        this.mEndpointLink = toEndpoint;
    }

    public int getType() {
        return 40;
    }

    public String getEndpointLink() {
        return this.mEndpointLink;
    }

    public QName getServiceLink() {
        return this.mServiceLink;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof LinkedEndpoint) {
            LinkedEndpoint le = (LinkedEndpoint)obj;
            isEqual = this.mLinkType == le.mLinkType && this.mEndpointLink.equals(le.mEndpointLink) && this.mServiceLink.equals(le.mServiceLink) && this.getEndpointName().equals(le.getEndpointName()) && this.getServiceName().equals(le.getServiceName()) && this.getOwnerId().equals(le.getOwnerId());
        }
        return isEqual;
    }

    public int hashCode() {
        return (this.mServiceLink.toString() + this.mEndpointLink + this.getServiceName()).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        EndPoint Type: Linked(Endpoint=");
        sb.append(this.mEndpointLink == null ? "Null" : this.mEndpointLink);
        sb.append(",Service=");
        sb.append(this.mServiceLink == null ? "Null" : this.mServiceLink);
        sb.append(")\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

