/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.DeliveryChannelImpl;
import com.sun.jbi.messaging.FaultImpl;
import com.sun.jbi.messaging.MessageExchange;
import com.sun.jbi.messaging.MessageExchangeImpl;
import com.sun.jbi.messaging.MessageImpl;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.util.Translator;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

public abstract class MessageExchangeProxy
implements MessageExchange {
    public static final int SET_TRANSACTION = 1;
    public static final int ADDRESS = 2;
    public static final int SET_PROPERTY = 16;
    public static final int SET_FAULT = 32;
    public static final int SET_DONE = 64;
    public static final int SET_ERROR = 128;
    public static final int SET_IN = 4096;
    public static final int SET_OUT = 8192;
    public static final int CREATE_FAULT = 16384;
    public static final int DO_SENDSYNCH = 32768;
    public static final int DO_SEND = 65536;
    public static final int DO_ACCEPT = 131072;
    public static final int SUSPEND_TX = 0x100000;
    public static final int RESUME_TX = 0x200000;
    public static final int MARK_DONE = 0x400000;
    public static final int MARK_ACTIVE = 0x800000;
    public static final int CHECK_STATUS_OR_FAULT = 0x1000000;
    public static final int ACTION_MASK = 0;
    public static final int ACTION_SEND = 1;
    public static final int ACTION_ACCEPT = 2;
    public static final int ACTION_STATUS = 3;
    public static final int ACTION_FAULT = 4;
    static final String IN_MSG = new String("in");
    static final String OUT_MSG = new String("out");
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private MessageExchangeImpl mMEI;
    private int[][] mState;
    private int mStateIndex;
    private MessageExchangeProxy mTwin;
    private DeliveryChannelImpl mSendChannel;
    private ServiceEndpoint mEndpointLink;
    private int mSynchState;
    static final int NONE = 0;
    static final int WAIT = 1;
    static final int WAIT_TIMEOUT = 2;
    static final int HALF_DONE = 3;
    static final int DONE = 4;
    static final int ERROR = 5;

    MessageExchangeProxy(int[][] states) {
        this.mState = states;
        this.mStateIndex = 0;
        this.mSynchState = 0;
    }

    abstract MessageExchangeProxy newTwin();

    public String getExchangeId() {
        return this.mMEI.getExchangeId();
    }

    public ExchangeStatus getStatus() {
        return this.mMEI.getStatus();
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        boolean isDone = status.equals(ExchangeStatus.DONE);
        boolean isError = status.equals(ExchangeStatus.ERROR);
        if (isDone && this.can(64) || isError && this.can(128)) {
            if (isDone) {
                if (this.can(8192) && this.getMessage(OUT_MSG) != null) {
                    throw new MessagingException(Translator.translate("STATUS_ON_MSG", this.getPattern().toString()));
                }
                if (this.mMEI.getStatus().equals(ExchangeStatus.ERROR)) {
                    throw new MessagingException(Translator.translate("ERROR_STATUS", this.getPattern().toString()));
                }
            } else {
                this.mMEI.setMessage(null, OUT_MSG);
            }
            this.mMEI.setStatus(status);
            this.nextState(3);
            return;
        }
        throw new MessagingException(Translator.translate("PATTERN_INCONSISTENT", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex));
    }

    public Exception getError() {
        return this.mMEI.getError();
    }

    public void setError(Exception error) {
        this.mMEI.setMessage(null, OUT_MSG);
        this.mMEI.setStatus(ExchangeStatus.ERROR);
        this.mMEI.setError(error);
        this.nextState(3);
    }

    public Fault getFault() {
        return this.mMEI.getFault();
    }

    public void setFault(Fault fault) throws MessagingException {
        if (!this.can(32)) {
            throw new MessagingException(Translator.translate("FAULT_NOT_SUPPORTED", this.getPattern().toString()));
        }
        if (this.can(4096) && this.getMessage(IN_MSG) != null || this.can(8192) && this.getMessage(OUT_MSG) != null) {
            throw new MessagingException(Translator.translate("FAULT_ON_MSG", this.getPattern().toString()));
        }
        this.mMEI.setFault(fault);
        this.nextState(4);
    }

    public ServiceEndpoint getEndpoint() {
        if (this.mEndpointLink != null && this.getRole().equals(MessageExchange.Role.CONSUMER)) {
            return this.mEndpointLink;
        }
        return this.mMEI.getEndpoint();
    }

    public void setEndpoint(ServiceEndpoint endPoint) {
        if (this.can(2)) {
            this.mMEI.setEndpoint(endPoint);
        }
    }

    public QName getService() {
        return this.mMEI.getService();
    }

    public void setService(QName service) {
        if (this.can(2)) {
            this.mMEI.setService(service);
        }
    }

    public QName getOperation() {
        return this.mMEI.getOperation();
    }

    public void setOperation(QName operation) {
        if (this.can(2)) {
            this.mMEI.setOperation(operation);
        }
    }

    public QName getInterfaceName() {
        return this.mMEI.getInterfaceName();
    }

    public void setInterfaceName(QName interfaceName) {
        if (this.can(2)) {
            this.mMEI.setInterfaceName(interfaceName);
        }
    }

    public NormalizedMessage getMessage(String name) {
        return this.mMEI.getMessage(name);
    }

    public void setMessage(NormalizedMessage message, String name) throws MessagingException {
        if (!(this.can(4096) && name.equals(IN_MSG) || this.can(8192) && name.equals(OUT_MSG))) {
            throw new MessagingException(Translator.translate("PATTERN_INCONSISTENT", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex));
        }
        this.mMEI.setMessage(message, name);
    }

    public Object getProperty(String name) {
        return this.mMEI.getProperty(name);
    }

    public void setProperty(String name, Object object) {
        if (this.can(16)) {
            if (name.equals("javax.jbi.transaction.jta")) {
                if (this.can(1)) {
                    this.mMEI.setProperty(name, object);
                }
            } else {
                this.mMEI.setProperty(name, object);
            }
        }
    }

    public Set getPropertyNames() {
        return this.mMEI.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        return (this.mState[0][0] & 0x20000) == 0 ? MessageExchange.Role.CONSUMER : MessageExchange.Role.PROVIDER;
    }

    public boolean isTransacted() {
        return this.mMEI.isTransacted();
    }

    public Fault createFault() throws MessagingException {
        if (!this.can(16384)) {
            throw new MessagingException(Translator.translate("FAULT_NOT_SUPPORTED"));
        }
        return new FaultImpl();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new MessageImpl();
    }

    void setTwin(MessageExchangeProxy mep) {
        this.mTwin = mep;
    }

    MessageExchangeProxy getTwin() {
        return this.mTwin;
    }

    void setSynchState(int state) {
        this.mSynchState = state;
    }

    int getSynchState() {
        return this.mSynchState;
    }

    void setMessageExchange(MessageExchangeImpl me) {
        this.mMEI = me;
    }

    MessageExchangeImpl getMessageExchange() {
        return this.mMEI;
    }

    boolean isSource() {
        return this == this.mMEI.getSource();
    }

    void validate(DeliveryChannelImpl channel, boolean isSynch) throws MessagingException {
        String message = null;
        if (this.mSendChannel == null) {
            ServiceEndpoint endpoint = this.getEndpoint();
            if (endpoint == null) {
                message = Translator.translate("ADDR_NO_ENDPOINT");
            } else if (!((RegisteredEndpoint)endpoint).isActive()) {
                message = Translator.translate("INACTIVE_ENDPOINT", endpoint);
            }
        }
        if (message == null) {
            if (!this.can(65536)) {
                message = Translator.translate("SEND_NOT_LEGAL", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex);
            } else if (isSynch && !this.can(32768)) {
                message = Translator.translate("SENDSYNCH_NOT_LEGAL", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex);
            }
        }
        if (message != null) {
            throw new MessagingException(message);
        }
        if (this.mSendChannel == null) {
            this.setupChannels(channel);
        }
    }

    private void setupChannels(DeliveryChannelImpl dc) throws MessagingException {
        boolean invertedTwin = false;
        RegisteredEndpoint endpoint = (RegisteredEndpoint)this.mMEI.getEndpoint();
        String target = endpoint.getOwnerId();
        DeliveryChannelImpl targetDc = dc.getChannel(target);
        if (targetDc == null) {
            throw new MessagingException(Translator.translate("INVALID_DESTINATION"));
        }
        this.bindChannels(dc, targetDc);
    }

    DeliveryChannelImpl getSendChannel() {
        return this.mSendChannel;
    }

    void bindChannels(DeliveryChannelImpl source, DeliveryChannelImpl target) {
        MessageExchangeProxy twin = this.newTwin();
        twin.setMessageExchange(this.mMEI);
        twin.mTwin = this;
        this.mTwin = twin;
        this.mTwin.mSendChannel = source;
        this.mSendChannel = target;
    }

    private boolean can(int operation) {
        return this.mStateIndex >= 0 && (this.mState[this.mStateIndex][0] & operation) != 0;
    }

    public synchronized boolean terminate() {
        boolean terminated;
        if (this.can(128)) {
            this.mStateIndex = this.mState[this.mStateIndex][3];
            this.mMEI.setStatus(ExchangeStatus.ERROR);
        } else if (this.can(131072)) {
            this.mMEI.setStatus(ExchangeStatus.ERROR);
        }
        boolean bl = terminated = !this.can(65536);
        while (!this.can(0x400000)) {
            ++this.mStateIndex;
        }
        this.mSynchState = 5;
        return terminated;
    }

    private void nextState(int state) {
        int newStateIndex = this.mState[this.mStateIndex][state];
        if (newStateIndex > 0) {
            if (this.can(0x800000)) {
                this.mMEI.setStatus(ExchangeStatus.ACTIVE);
            }
        } else {
            throw new IllegalStateException(Translator.translate("ILLEGAL_STATE_CHANGE", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex));
        }
        this.mStateIndex = newStateIndex;
    }

    boolean handleAccept(DeliveryChannelImpl channel) throws MessagingException {
        this.mSynchState = 0;
        if (channel.isTransactional() && this.can(0x200000)) {
            this.mMEI.resumeTX();
        }
        if (this.can(0x1000000)) {
            if (this.getFault() != null) {
                this.nextState(4);
            } else if (!this.getStatus().equals(ExchangeStatus.ACTIVE)) {
                this.nextState(3);
            } else {
                this.nextState(2);
            }
        } else {
            this.nextState(2);
        }
        boolean done = this.can(0x400000);
        if (done) {
            this.mTwin = null;
            this.mSendChannel = null;
        }
        return done;
    }

    void setEndpointLink(ServiceEndpoint se) {
        this.mEndpointLink = se;
    }

    ServiceEndpoint getEndpointLink() {
        return this.mEndpointLink;
    }

    boolean handleSend(DeliveryChannelImpl channel) throws MessagingException {
        this.mSynchState = 0;
        if (channel.isTransactional() && this.can(0x100000)) {
            this.mMEI.suspendTX();
        }
        this.nextState(1);
        boolean done = this.can(0x400000);
        if (done) {
            this.mTwin = null;
            this.mSendChannel = null;
        }
        return done;
    }

    void beforeCapabilityCheck(ServiceEndpoint se) {
        this.mStateIndex = -1;
        this.mMEI.setEndpoint(se);
    }

    void afterCapabilityCheck() {
        this.mStateIndex = 0;
        this.mMEI.setEndpoint(null);
    }

    public boolean isRemoteInvocation() {
        return this.mMEI.isRemote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTimeout() {
        boolean timedout = false;
        MessageExchangeProxy messageExchangeProxy = this;
        synchronized (messageExchangeProxy) {
            if (this.mSynchState == 0) {
                this.mSynchState = 5;
                timedout = true;
            }
        }
        return timedout;
    }

    public Set getDeltaProperties() {
        return this.mMEI.getDeltaProperties();
    }

    public void mergeProperties() {
        this.mMEI.mergeProperties();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("      ExchangeId: ");
        sb.append(this.mMEI.getExchangeId());
        sb.append("\n        Pattern: ");
        sb.append(this.getPattern());
        sb.append("\n        SendChannel: ");
        sb.append(this.mSendChannel == null ? "Null" : this.mSendChannel.getChannelId());
        sb.append("\n        Role: ");
        sb.append(this.getRole().equals(MessageExchange.Role.CONSUMER) ? "Consumer" : "Provider");
        sb.append("  Index: ");
        sb.append(this.mStateIndex);
        sb.append("  SynchState: ");
        sb.append(this.mSynchState == 0 ? "NONE" : (this.mSynchState == 1 ? "WAIT" : (this.mSynchState == 2 ? "WAIT_TIMEOUT" : (this.mSynchState == 3 ? "HALF_DONE" : (this.mSynchState == 4 ? "DONE" : "ERROR")))));
        sb.append("\n        EndpointLink: ");
        sb.append(this.mEndpointLink == null ? "Null" : this.mEndpointLink.toString());
        sb.append(this.mMEI.toString());
        return sb.toString();
    }
}

