/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class StringTranslator {
    private static final String LOGGER_NAME = "com.sun.jbi.util";
    public static final String RESOURCE_BUNDLE_NAME = "LocalStrings";
    private static final String LOG_NEW_INSTANCE = "New StringTranslator for package {0}, classLoader is {1}";
    private static final String LOG_CURRENT_LOCALE = "Current locale is {0}";
    private static final String LOG_UNABLE_TO_LOAD_BUNDLE = "Unable to load resource bundle {0} for locale {1}: {2}";
    private static final String LOG_USING_BUNDLE = "Using resource bundle for locale {0} instead.";
    private static final String LOG_TRANSLATION_USING_FALLBACK = "No translation for key={0} found in resource bundle for locale {1}, using locale {2} instead.";
    private static final String LOG_NO_TRANSLATION_FOR_KEY = "No translation for key={0} found in any resource bundle. Insert data is [{1}].";
    private static final String LOG_NO_TRANSLATION_FOR_KEY_IN_BUNDLE = "No translation for key={0} found in resource bundle for locale {1}. Insert data is [{2}].";
    private static final String MSG_NO_TRANSLATION = "No translation available for message with key={0} and inserts=[{1}].";
    private static Logger sLog = Logger.getLogger("com.sun.jbi.util");
    private static Locale sDefaultLocale = Locale.getDefault();
    private ResourceBundle mResourceBundle;

    public StringTranslator(String packageName, ClassLoader classLoader) {
        sLog.finest(MessageFormat.format(LOG_NEW_INSTANCE, packageName, classLoader));
        String bundleName = packageName + "." + RESOURCE_BUNDLE_NAME;
        try {
            this.mResourceBundle = null == classLoader ? ResourceBundle.getBundle(bundleName) : ResourceBundle.getBundle(bundleName, sDefaultLocale, classLoader);
        }
        catch (MissingResourceException mrEx) {
            sLog.warning(MessageFormat.format(LOG_UNABLE_TO_LOAD_BUNDLE, bundleName, sDefaultLocale, mrEx));
        }
    }

    public String getString(String key) {
        Object[] inserts = new Object[]{};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1) {
        Object[] inserts = new Object[]{insert1};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1, Object insert2) {
        Object[] inserts = new Object[]{insert1, insert2};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1, Object insert2, Object insert3) {
        Object[] inserts = new Object[]{insert1, insert2, insert3};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1, Object insert2, Object insert3, Object insert4) {
        Object[] inserts = new Object[]{insert1, insert2, insert3, insert4};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1, Object insert2, Object insert3, Object insert4, Object insert5) {
        Object[] inserts = new Object[]{insert1, insert2, insert3, insert4, insert5};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object[] inserts) {
        String translated = null;
        if (null != this.mResourceBundle) {
            try {
                translated = this.mResourceBundle.getString(key);
                translated = MessageFormat.format(translated, inserts);
            }
            catch (MissingResourceException mrEx) {
                String fi = this.formatInserts(inserts);
                translated = MessageFormat.format(MSG_NO_TRANSLATION, key, fi);
                sLog.warning(MessageFormat.format(LOG_NO_TRANSLATION_FOR_KEY_IN_BUNDLE, key, sDefaultLocale, fi));
            }
        } else {
            translated = MessageFormat.format(MSG_NO_TRANSLATION, key, this.formatInserts(inserts));
        }
        return translated;
    }

    private String formatInserts(Object[] inserts) {
        StringBuffer formatted = new StringBuffer("");
        for (int i = 0; i < inserts.length; ++i) {
            if (i > 0) {
                formatted.append(",");
            }
            formatted.append(inserts[i].toString());
        }
        return formatted.toString();
    }

    static {
        sLog.finest(MessageFormat.format(LOG_CURRENT_LOCALE, sDefaultLocale));
    }
}

