/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.logging.Logging;
import net.jxta.util.SimpleSelectable;
import net.jxta.util.SimpleSelector;

public class ListenerAdaptor
implements Runnable {
    private static final transient Logger LOG = Logger.getLogger(ListenerAdaptor.class.getName());
    private final Map<SimpleSelectable.IdentityReference, ListenerContainer> inprogress = new HashMap<SimpleSelectable.IdentityReference, ListenerContainer>(32);
    private Thread bgThread = null;
    private final SimpleSelector selector = new SimpleSelector();
    private volatile boolean shutdown = false;
    private final Executor executor;
    private final ThreadGroup threadGroup;

    public ListenerAdaptor(ThreadGroup threadGroup) {
        this(threadGroup, null);
    }

    public ListenerAdaptor(ThreadGroup threadGroup, Executor executor) {
        this.executor = executor;
        this.threadGroup = threadGroup;
    }

    private synchronized void init() {
        assert (!this.shutdown);
        if (this.bgThread != null) {
            return;
        }
        this.bgThread = new Thread(this.threadGroup, this, "Listener Adaptor");
        this.bgThread.setDaemon(true);
        this.bgThread.start();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        Thread bg = this.bgThread;
        if (bg != null) {
            bg.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetSelectable(SimpleSelectable ts) {
        ts.unregister(this.selector);
        ListenerAdaptor listenerAdaptor = this;
        synchronized (listenerAdaptor) {
            this.inprogress.remove(ts.getIdentityReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean watchMessage(OutgoingMessageEventListener listener, Message message) {
        ListenerAdaptor listenerAdaptor = this;
        synchronized (listenerAdaptor) {
            if (this.shutdown) {
                return false;
            }
            if (listener == null) {
                return true;
            }
            this.init();
            MessageListenerContainer allListeners = (MessageListenerContainer)this.inprogress.get(message.getIdentityReference());
            if (allListeners == null) {
                allListeners = new MessageListenerContainer();
                this.inprogress.put(message.getIdentityReference(), allListeners);
            }
            allListeners.add(listener);
        }
        message.register(this.selector);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean watchMessenger(MessengerEventListener listener, Messenger messenger) {
        ListenerAdaptor listenerAdaptor = this;
        synchronized (listenerAdaptor) {
            if (this.shutdown) {
                return false;
            }
            if (listener == null) {
                return true;
            }
            this.init();
            MessengerListenerContainer allListeners = (MessengerListenerContainer)this.inprogress.get(messenger.getIdentityReference());
            if (allListeners == null) {
                allListeners = new MessengerListenerContainer();
                this.inprogress.put(messenger.getIdentityReference(), allListeners);
            }
            allListeners.add(listener);
        }
        messenger.register(this.selector);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block25: {
            block24: {
                while (!this.shutdown) {
                    try {
                        Collection<SimpleSelectable> changed = this.selector.select();
                        for (SimpleSelectable simpleSelectable : changed) {
                            ListenerContainer listeners;
                            ListenerAdaptor listenerAdaptor = this;
                            synchronized (listenerAdaptor) {
                                listeners = this.inprogress.get(simpleSelectable.getIdentityReference());
                            }
                            if (listeners == null) {
                                simpleSelectable.unregister(this.selector);
                                continue;
                            }
                            if (this.executor == null) {
                                listeners.process(simpleSelectable);
                                continue;
                            }
                            this.executor.execute(new ListenerProcessor(listeners, simpleSelectable));
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                }
                Object var9_10 = null;
                try {
                    IOException failed = new IOException("Endpoint interface terminated");
                    for (Map.Entry<SimpleSelectable.IdentityReference, ListenerContainer> entry : this.inprogress.entrySet()) {
                        SimpleSelectable simpleSelectable = entry.getKey().getObject();
                        ListenerContainer listeners = entry.getValue();
                        simpleSelectable.unregister(this.selector);
                        if (listeners == null) continue;
                        listeners.giveUp(simpleSelectable, failed);
                    }
                    this.inprogress.clear();
                }
                catch (Throwable anyOther2) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block24;
                    LOG.log(Level.SEVERE, "Uncaught Throwable while shutting down background thread", anyOther2);
                }
            }
            this.bgThread = null;
            {
                break block25;
                catch (Throwable anyOther) {
                    block26: {
                        if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                            LOG.log(Level.SEVERE, "Uncaught Throwable in background thread", anyOther);
                        }
                        ListenerAdaptor listenerAdaptor = this;
                        synchronized (listenerAdaptor) {
                            this.shutdown = true;
                        }
                        Object var9_11 = null;
                        try {
                            IOException failed = new IOException("Endpoint interface terminated");
                            for (Map.Entry<SimpleSelectable.IdentityReference, ListenerContainer> entry : this.inprogress.entrySet()) {
                                SimpleSelectable simpleSelectable = entry.getKey().getObject();
                                ListenerContainer listeners = entry.getValue();
                                simpleSelectable.unregister(this.selector);
                                if (listeners == null) continue;
                                listeners.giveUp(simpleSelectable, failed);
                            }
                            this.inprogress.clear();
                        }
                        catch (Throwable anyOther2) {
                            if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block26;
                            LOG.log(Level.SEVERE, "Uncaught Throwable while shutting down background thread", anyOther2);
                        }
                    }
                    this.bgThread = null;
                }
            }
            catch (Throwable throwable) {
                block27: {
                    Object var9_12 = null;
                    try {
                        IOException failed = new IOException("Endpoint interface terminated");
                        for (Map.Entry<SimpleSelectable.IdentityReference, ListenerContainer> entry : this.inprogress.entrySet()) {
                            SimpleSelectable simpleSelectable = entry.getKey().getObject();
                            ListenerContainer listeners = entry.getValue();
                            simpleSelectable.unregister(this.selector);
                            if (listeners == null) continue;
                            listeners.giveUp(simpleSelectable, failed);
                        }
                        this.inprogress.clear();
                    }
                    catch (Throwable anyOther2) {
                        if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block27;
                        LOG.log(Level.SEVERE, "Uncaught Throwable while shutting down background thread", anyOther2);
                    }
                }
                this.bgThread = null;
                throw throwable;
            }
        }
    }

    private class ListenerProcessor
    implements Runnable {
        private SimpleSelectable simpleSelectable;
        private ListenerContainer listeners;

        ListenerProcessor(ListenerContainer listeners, SimpleSelectable simpleSelectable) {
            this.listeners = listeners;
            this.simpleSelectable = simpleSelectable;
        }

        public void run() {
            this.listeners.process(this.simpleSelectable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MessengerListenerContainer
    extends ListenerContainer<Messenger, MessengerEventListener> {
        MessengerListenerContainer() {
        }

        private void messengerDone(Messenger messenger) {
            MessengerEvent event = new MessengerEvent(ListenerAdaptor.this, messenger, null);
            for (MessengerEventListener eachListener : this) {
                try {
                    eachListener.messengerReady(event);
                }
                catch (Throwable any) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Uncaught throwable in listener", any);
                }
            }
        }

        @Override
        protected void process(Messenger messenger) {
            if ((messenger.getState() & 0x7DBCC) == 0) {
                return;
            }
            ListenerAdaptor.this.forgetSelectable(messenger);
            if ((messenger.getState() & 0x3FF) == 0) {
                messenger = null;
            }
            this.messengerDone(messenger);
        }

        @Override
        protected void giveUp(Messenger m, Throwable how) {
            this.messengerDone(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MessageListenerContainer
    extends ListenerContainer<Message, OutgoingMessageEventListener> {
        MessageListenerContainer() {
        }

        private void messageDone(Message message, OutgoingMessageEvent event) {
            if (event == OutgoingMessageEvent.SUCCESS) {
                event = new OutgoingMessageEvent(message, null);
                for (OutgoingMessageEventListener eachListener : this) {
                    try {
                        eachListener.messageSendSucceeded(event);
                    }
                    catch (Throwable any) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "Uncaught throwable from listener", any);
                    }
                }
            } else {
                if (event == OutgoingMessageEvent.OVERFLOW) {
                    event = new OutgoingMessageEvent(message, null);
                }
                for (OutgoingMessageEventListener eachListener : this) {
                    try {
                        eachListener.messageSendFailed(event);
                    }
                    catch (Throwable any) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "Uncaught throwable in listener", any);
                    }
                }
            }
        }

        @Override
        protected void process(Message message) {
            OutgoingMessageEvent event = (OutgoingMessageEvent)message.getMessageProperty(Messenger.class);
            if (event == null) {
                return;
            }
            ListenerAdaptor.this.forgetSelectable(message);
            this.messageDone(message, event);
        }

        @Override
        protected void giveUp(Message m, Throwable how) {
            this.messageDone(m, new OutgoingMessageEvent(m, how));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ListenerContainer<S extends SimpleSelectable, L extends EventListener>
    extends ArrayList<L> {
        public ListenerContainer() {
            super(1);
        }

        protected abstract void giveUp(S var1, Throwable var2);

        protected abstract void process(S var1);
    }
}

