/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.access.pse;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.access.AccessService;
import net.jxta.credential.Credential;
import net.jxta.credential.PrivilegedOperation;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;

public class PSEAccessService
implements AccessService {
    private static final Logger LOG = Logger.getLogger(PSEAccessService.class.getName());
    public static final ModuleSpecID PSE_ACCESS_SPEC_ID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000100306"));
    PeerGroup group;
    ModuleImplAdvertisement implAdvertisement;
    PSEMembershipService pseMembership;
    final boolean allowNullCredentialForNullOperation = false;

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        this.group = group;
        this.implAdvertisement = (ModuleImplAdvertisement)implAdv;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring PSE Access Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            LOG.config(configInfo.toString());
        }
    }

    public int startApp(String[] args) {
        MembershipService membership = this.group.getMembershipService();
        if (null == membership) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a membership service");
            }
            return 2;
        }
        ModuleImplAdvertisement membershipImplAdv = (ModuleImplAdvertisement)membership.getImplAdvertisement();
        if (null == membershipImplAdv || !PSEMembershipService.pseMembershipSpecID.equals(membershipImplAdv.getModuleSpecID()) || !(membership instanceof PSEMembershipService)) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("PSE Access Service requires a PSE Membership Service.");
            }
            return -1;
        }
        this.pseMembership = (PSEMembershipService)membership;
        return 0;
    }

    public void stopApp() {
        this.pseMembership = null;
    }

    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public Service getInterface() {
        return this;
    }

    public AccessService.AccessResult doAccessCheck(PrivilegedOperation op, Credential cred) {
        if (null == op && null == cred) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (null == cred || !(cred instanceof PSECredential)) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (!cred.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (null == op) {
            return AccessService.AccessResult.PERMITTED;
        }
        if (!(op instanceof PSEOperation)) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (op.getSourceService() != this) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (!op.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        PSECredential offerer = ((PSEOperation)op).getOfferer();
        X509Certificate[] opCerts = offerer.getCertificateChain();
        X509Certificate[] credCerts = ((PSECredential)cred).getCertificateChain();
        for (X509Certificate credCert : Arrays.asList(credCerts)) {
            for (X509Certificate opCert : Arrays.asList(opCerts)) {
                if (!credCert.getPublicKey().equals(opCert.getPublicKey())) continue;
                return AccessService.AccessResult.PERMITTED;
            }
        }
        return AccessService.AccessResult.DISALLOWED;
    }

    public PrivilegedOperation newPrivilegedOperation(Object subject, Credential offerer) {
        if (!(subject instanceof PSECredential)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports PSECredential subjects.");
        }
        if (subject != offerer) {
            throw new IllegalArgumentException("PSE Access Service requires operation and offerer to be the same object.");
        }
        if (!offerer.isValid()) {
            throw new IllegalArgumentException("offerer is not a valid credential");
        }
        return new PSEOperation((PSEAccessService)this.getInterface(), (PSECredential)offerer);
    }

    public PrivilegedOperation newPrivilegedOperation(Element source) {
        return new PSEOperation((PSEAccessService)this.getInterface(), source);
    }

    PeerGroup getPeerGroup() {
        return this.group;
    }

    private static class PSEOperation
    implements PrivilegedOperation {
        final PSEAccessService source;
        PSECredential op;

        protected PSEOperation(PSEAccessService source, PSECredential op) {
            this.source = source;
            this.op = op;
        }

        protected PSEOperation(PSEAccessService source, Element root) {
            this.source = source;
            this.initialize(root);
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return null;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public PSECredential getSubject() {
            return this.op;
        }

        public Service getSourceService() {
            return this.source;
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
                ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
                ((Attributable)((Object)doc)).addAttribute("type", "jxta:PSEOp");
            }
            Object e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("Operation", this.op);
            doc.appendChild(e);
            return doc;
        }

        public PSECredential getOfferer() {
            return null;
        }

        protected boolean handleElement(TextElement elem) {
            if (elem.getName().equals("PeerGroupID")) {
                try {
                    URI gID = new URI(elem.getTextValue().trim());
                    ID pgid = IDFactory.fromURI(gID);
                    if (!pgid.equals(this.getPeerGroupID())) {
                        throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                    }
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("Operation")) {
                this.op = (PSECredential)this.source.pseMembership.makeCredential(elem);
                return true;
            }
            return false;
        }

        protected void initialize(Element root) {
            String doctype;
            Attribute itsType;
            if (!TextElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
            }
            TextElement doc = (TextElement)root;
            String typedoctype = "";
            if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
                typedoctype = itsType.getValue();
            }
            if (!(doctype = doc.getName()).equals("jxta:PSEOp") && !typedoctype.equals("jxta:PSEOp")) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
            }
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                TextElement elem = (TextElement)elements.nextElement();
                if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled element '" + elem.getName() + "' in " + doc.getName());
            }
            if (null == this.op) {
                throw new IllegalArgumentException("operation was never initialized.");
            }
        }
    }
}

