/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Attribute;
import net.jxta.document.XMLElement;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteXMLElement
implements XMLElement<LiteXMLElement> {
    private static final transient Logger LOG = Logger.getLogger(LiteXMLElement.class.getName());
    protected static final transient boolean paranoidConsistencyChecking = false;
    protected final transient LiteXMLDocument doc;
    protected transient LiteXMLElement parent;
    protected transient tagRange loc;
    private transient StringBuilder uninserted = null;
    private transient List<LiteXMLElement> children;

    protected LiteXMLElement(LiteXMLDocument doc, tagRange loc) {
        this.doc = doc;
        this.loc = loc;
    }

    public LiteXMLElement(LiteXMLDocument doc, String name, String val) {
        this(doc, new tagRange());
        for (int eachChar = name.length() - 1; eachChar >= 0; --eachChar) {
            if (!Character.isWhitespace(name.charAt(eachChar))) continue;
            throw new IllegalArgumentException("Element names may not contain spaces.");
        }
        if (null == val || 0 == val.length()) {
            this.uninserted = new StringBuilder("<" + name + "/>");
        } else {
            this.uninserted = new StringBuilder(val);
            this.encodeEscaped(this.uninserted);
            this.uninserted.insert(0, "<" + name + ">");
            this.uninserted.append("</").append(name).append(">");
        }
    }

    public boolean equals(Object element2) {
        if (this == element2) {
            return true;
        }
        if (!(element2 instanceof LiteXMLElement)) {
            return false;
        }
        LiteXMLElement liteElement = (LiteXMLElement)element2;
        if (this.getDocument() != liteElement.getDocument()) {
            return false;
        }
        if (!this.getName().equals(liteElement.getName())) {
            return false;
        }
        String val1 = null != this.uninserted ? this.uninserted.toString() : this.getTextValue();
        String val2 = liteElement.getTextValue();
        if (null == val1 && null == val2) {
            return true;
        }
        return null != val1 && null != val2 && val1.equals(val2);
    }

    public String toString() {
        String value;
        String name = this.getName();
        if (name == null) {
            name = "<<null name>>";
        }
        if ((value = this.getTextValue()) == null) {
            value = "<<null value>>";
        }
        if (value.length() + name.length() >= 60) {
            int len = Math.max(20, 60 - name.length());
            value = value.substring(0, Math.min(len, value.length()));
        }
        return super.toString() + " / " + name + " = " + value;
    }

    @Override
    public LiteXMLDocument getRoot() {
        return this.getDocument();
    }

    @Override
    public LiteXMLElement getParent() {
        return this.parent;
    }

    @Override
    public Enumeration<LiteXMLElement> getChildren() {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null == this.children) {
            List empty = Collections.emptyList();
            return Collections.enumeration(empty);
        }
        return Collections.enumeration(this.children);
    }

    @Override
    public String getName() {
        char inTagName;
        int current;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.getDocument().docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        return this.getDocument().docContent.substring(this.loc.startTag.start + 1, current);
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public String getValue() {
        return this.getTextValue();
    }

    @Override
    public void appendChild(LiteXMLElement element2) {
        if (element2.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("Wrong document");
        }
        if (null != element2.parent) {
            throw new IllegalArgumentException("New element is already in document");
        }
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null != element2.uninserted) {
            if (this.loc.startTag.equals(this.loc.endTag)) {
                char inTagName;
                int current;
                this.getDocument().docContent.deleteCharAt(this.loc.endTag.end - 1);
                --this.loc.startTag.end;
                for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.getDocument().docContent.charAt(current)) && '>' != inTagName; ++current) {
                }
                String tagName = this.getDocument().docContent.substring(this.loc.startTag.start + 1, current);
                this.getDocument().docContent.insert(this.loc.startTag.end + 1, "</" + tagName + ">");
                this.getDocument().adjustLocations(this.loc.startTag.end + 1, tagName.length() + 2);
                this.loc.endTag = new charRange(this.loc.startTag.end + 1, this.loc.startTag.end + 3 + tagName.length());
                this.loc.body = new charRange(this.loc.startTag.end + 1, this.loc.startTag.end);
            }
            this.getDocument().docContent.insert(this.loc.endTag.start, element2.uninserted);
            element2.loc.startTag.start = this.loc.endTag.start;
            element2.loc.startTag.end = this.getDocument().docContent.indexOf(">", element2.loc.startTag.start);
            if ('/' != element2.uninserted.charAt(element2.uninserted.length() - 2)) {
                element2.loc.body.start = element2.loc.startTag.end + 1;
                element2.loc.endTag.end = element2.loc.startTag.start + element2.uninserted.length() - 1;
                element2.loc.endTag.start = this.getDocument().docContent.lastIndexOf("<", element2.loc.endTag.end);
                element2.loc.body.end = element2.loc.endTag.start - 1;
            } else {
                element2.loc.body = new charRange(element2.loc.startTag.start, element2.loc.startTag.end);
                element2.loc.endTag = new charRange(element2.loc.startTag.start, element2.loc.startTag.end);
            }
            if (0 != this.loc.body.length()) {
                this.getDocument().adjustLocations(this.loc.endTag.start, element2.uninserted.length());
            } else {
                --this.loc.body.start;
                this.getDocument().adjustLocations(this.loc.endTag.start, element2.uninserted.length());
                ++this.loc.body.start;
            }
            this.loc.body.end += element2.uninserted.length();
            element2.uninserted = null;
        }
        element2.parent = this;
        if (null == this.children) {
            this.children = new ArrayList<LiteXMLElement>();
        }
        this.children.add(element2);
    }

    @Override
    public Enumeration<LiteXMLElement> getChildren(Object key) {
        if (key instanceof String) {
            return this.getChildren((String)key);
        }
        throw new ClassCastException(key.getClass().getName() + " not supported by getChildren.");
    }

    @Override
    public Enumeration<LiteXMLElement> getChildren(String name) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null == this.children) {
            List empty = Collections.emptyList();
            return Collections.enumeration(empty);
        }
        ArrayList<LiteXMLElement> result = new ArrayList<LiteXMLElement>();
        for (LiteXMLElement aChild : this.children) {
            if (!name.equals(aChild.getName())) continue;
            result.add(aChild);
        }
        return Collections.enumeration(result);
    }

    @Override
    public String getTextValue() {
        return this.getTextValue(false, true);
    }

    protected String getTextValue(boolean getEncoded, boolean trim) {
        int firstNonWhiteSpace;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        StringBuilder building = new StringBuilder();
        ArrayList<charRange> ranges = new ArrayList<charRange>();
        Enumeration<LiteXMLElement> eachChild = this.getChildren();
        while (eachChild.hasMoreElements()) {
            LiteXMLElement aChild = eachChild.nextElement();
            charRange childsRange = new charRange(aChild.loc.startTag.start, aChild.loc.endTag.end);
            for (int eachRange = 0; eachRange < ranges.size(); ++eachRange) {
                charRange rangeChild = (charRange)ranges.get(eachRange);
                if (1 != rangeChild.compareTo(childsRange)) continue;
                ranges.set(eachRange, childsRange);
                childsRange = rangeChild;
            }
            ranges.add(childsRange);
        }
        int current = this.loc.body.start;
        for (charRange aRange : ranges) {
            building.append(this.getDocument().docContent.substring(current, aRange.start));
            current = aRange.end + 1;
        }
        building.append(this.getDocument().docContent.substring(current, this.loc.endTag.start));
        if (!getEncoded) {
            building = this.decodeEscaped(building);
        }
        int lastNonWhiteSpace = building.length() - 1;
        if (trim) {
            char possibleSpace;
            for (firstNonWhiteSpace = 0; firstNonWhiteSpace < building.length() && Character.isWhitespace(possibleSpace = building.charAt(firstNonWhiteSpace)); ++firstNonWhiteSpace) {
            }
            if (firstNonWhiteSpace >= building.length()) {
                return null;
            }
            while (lastNonWhiteSpace >= firstNonWhiteSpace && Character.isWhitespace(possibleSpace = building.charAt(lastNonWhiteSpace))) {
                --lastNonWhiteSpace;
            }
        }
        String result = building.substring(firstNonWhiteSpace, lastNonWhiteSpace + 1);
        return result;
    }

    protected void printNice(Writer into, int indent, boolean recurse) throws IOException {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        StringBuilder start = new StringBuilder();
        if (-1 != indent) {
            for (int eachTab = 0; eachTab < indent; ++eachTab) {
                start.append('\t');
            }
        }
        start.append(this.getDocument().docContent.substring(this.loc.startTag.start, this.loc.startTag.end + 1));
        if (-1 != indent) {
            start.append('\n');
        }
        into.write(start.toString());
        if (!this.loc.startTag.equals(this.loc.endTag)) {
            String itsValue = this.getTextValue(true, -1 != indent);
            if (null != itsValue) {
                if (-1 != indent) {
                    for (int eachTab = 0; eachTab < indent + 1; ++eachTab) {
                        into.write("\t");
                    }
                }
                into.write(itsValue);
                if (-1 != indent) {
                    into.write(10);
                }
            }
            if (recurse) {
                Enumeration<LiteXMLElement> childrens = this.getChildren();
                Attribute space = this.getAttribute("xml:space");
                int childIndent = null != space ? ("preserve".equals(space.getValue()) ? -1 : indent + 1) : (-1 != indent ? indent + 1 : -1);
                while (childrens.hasMoreElements()) {
                    LiteXMLElement aChild = childrens.nextElement();
                    aChild.printNice(into, childIndent, recurse);
                }
            }
            StringBuilder end = new StringBuilder();
            if (-1 != indent) {
                for (int eachTab = 0; eachTab < indent; ++eachTab) {
                    end.append('\t');
                }
            }
            end.append(this.getDocument().docContent.substring(this.loc.endTag.start, this.loc.endTag.end + 1));
            if (-1 != indent) {
                end.append('\n');
            }
            into.write(end.toString());
        }
    }

    protected tagRange getTagRanges(StringBuilder source, String tag, charRange range) {
        int foundTagText;
        boolean emptyTag;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added to the document.");
        }
        tagRange result = new tagRange();
        int start = range.start;
        int end = source.length() - 1;
        boolean foundStartTag = false;
        boolean foundEndTag = false;
        boolean bl = emptyTag = null == tag || 0 == tag.length();
        if (-1 == start || start >= end) {
            throw new IllegalArgumentException("Illegal start value");
        }
        if (-1 != range.end && end > range.end) {
            end = range.end;
        }
        if (null == tag) {
            tag = "";
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Searching for \"" + tag + "\" in range [" + start + "," + end + "]");
        }
        int current = start;
        if (emptyTag) {
            foundTagText = source.indexOf("<", current);
            if (-1 == foundTagText) {
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("No Tags Found");
                }
                return result;
            }
            for (int afterTagText = ++foundTagText; afterTagText <= end; ++afterTagText) {
                char inTagName = source.charAt(afterTagText);
                if (!Character.isWhitespace(inTagName) && '/' != inTagName && '>' != inTagName) {
                    continue;
                }
                tag = source.substring(foundTagText, afterTagText);
                boolean bl2 = emptyTag = null == tag || 0 == tag.length();
                break;
            }
            if (emptyTag) {
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("No tag found");
                }
                return result;
            }
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Search for \"" + tag + "\" [" + start + "," + end + "]");
        }
        while (!foundStartTag && current < end) {
            foundTagText = source.indexOf(tag, current + 1);
            int afterTagText = foundTagText + tag.length();
            if (-1 == foundTagText || afterTagText > end) {
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Tag \"" + tag + "\" Not Found(1)");
                }
                return result;
            }
            char checkChar = source.charAt(afterTagText);
            if ('<' != source.charAt(foundTagText - 1) || !Character.isWhitespace(checkChar) && '/' != checkChar && '>' != checkChar) {
                current = afterTagText;
                continue;
            }
            int foundTagTerminator = source.indexOf(">", afterTagText);
            int foundNextTagStart = source.indexOf("<", afterTagText + 1);
            if (-1 == foundTagTerminator || foundTagTerminator > end || -1 != foundNextTagStart && foundNextTagStart < foundTagTerminator) {
                current = afterTagText;
                continue;
            }
            foundStartTag = true;
            result.startTag.start = foundTagText - 1;
            result.startTag.end = foundTagTerminator;
        }
        if (!foundStartTag) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Tag \"" + tag + "\" Not Found(2)");
            }
            return result;
        }
        if ('/' == source.charAt(result.startTag.end - 1)) {
            result.body = new charRange(result.startTag.start, result.startTag.end);
            result.endTag = new charRange(result.startTag.start, result.startTag.end);
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Empty Element \"" + tag + "\" Start : " + result.startTag);
            }
            return result;
        }
        current = result.startTag.end + 1;
        if (current >= end) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("End not found \"" + tag + "\" Start : " + result.startTag);
            }
            return result;
        }
        String endTag = "</" + tag + ">";
        int searchFrom = result.startTag.end + 1;
        while (!foundEndTag && current < end && searchFrom < end) {
            int foundTagText2;
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Searching for \"" + endTag + "\" in range [" + current + "," + end + "]");
            }
            if (-1 == (foundTagText2 = source.indexOf(endTag, current)) || foundTagText2 + endTag.length() - 1 > end) break;
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Prospective tag pair for \"" + tag + "\" " + result.startTag + ":[" + foundTagText2 + "," + (foundTagText2 + endTag.length() - 1) + "]");
            }
            charRange subRange = new charRange(searchFrom, foundTagText2 - 1);
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Recursing to search for \"" + tag + "\" in " + subRange);
            }
            tagRange subElement = this.getTagRanges(source, tag, subRange);
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Recursion result \"" + tag + "\" " + subElement);
            }
            if (subElement.startTag.isValid()) {
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Found sub-tag \"" + tag + "\" at " + subElement + " within " + subRange);
                }
                if (subElement.endTag.isValid()) {
                    if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Complete sub-tag \"" + tag + "\" at " + subElement + " within " + subRange);
                    }
                    current = subElement.endTag.end + 1;
                    searchFrom = subElement.endTag.end + 1;
                    continue;
                }
                current = foundTagText2 + endTag.length();
                continue;
            }
            foundEndTag = true;
            result.endTag.start = foundTagText2;
            result.endTag.end = foundTagText2 + endTag.length() - 1;
            if (!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER)) continue;
            LOG.finer("Prospective tag \"" + tag + "\" " + result.endTag + " is confirmed.");
        }
        result.body.start = result.startTag.end + 1;
        result.body.end = foundEndTag ? result.endTag.start - 1 : end;
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Found element : \"" + tag + "\" " + result);
        }
        return result;
    }

    protected void addChildTags(charRange scanRange, LiteXMLElement addTo) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added to the document.");
        }
        int current = scanRange.start;
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Scanning for children in range " + scanRange);
        }
        do {
            tagRange aSubtag;
            if ((aSubtag = this.getTagRanges(this.getDocument().docContent, null, new charRange(current, scanRange.end))).isValid()) {
                LiteXMLElement newChild = this.getDocument().createElement(aSubtag);
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Adding child tag \"" + this.getDocument().docContent.substring(aSubtag.endTag.start + 2, aSubtag.endTag.end) + "\" " + aSubtag);
                }
                addTo.appendChild(newChild);
                if (!aSubtag.startTag.equals(aSubtag.endTag)) {
                    this.addChildTags(aSubtag.body, newChild);
                }
                current = aSubtag.endTag.end + 1;
                continue;
            }
            current = -1;
        } while (-1 != current && current < scanRange.end);
    }

    protected void adjustLocations(int beginningAt, int by) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (this.loc.endTag.end < beginningAt && this.loc.endTag.start < beginningAt) {
            return;
        }
        if (this.loc.startTag.end >= beginningAt || this.loc.startTag.start >= beginningAt && this.loc.startTag.end + 1 == this.loc.startTag.start) {
            this.loc.startTag.end += by;
        }
        if (this.loc.startTag.start >= beginningAt) {
            this.loc.startTag.start += by;
        }
        if (this.loc.body.end >= beginningAt || this.loc.body.start >= beginningAt && this.loc.body.end + 1 == this.loc.body.start) {
            this.loc.body.end += by;
        }
        if (this.loc.body.start >= beginningAt) {
            this.loc.body.start += by;
        }
        if (this.loc.endTag.end >= beginningAt || this.loc.endTag.start >= beginningAt && this.loc.endTag.end + 1 == this.loc.endTag.start) {
            this.loc.endTag.end += by;
        }
        if (this.loc.endTag.start >= beginningAt) {
            this.loc.endTag.start += by;
        }
        Enumeration<LiteXMLElement> eachChild = this.getChildren();
        while (eachChild.hasMoreElements()) {
            LiteXMLElement aChild = eachChild.nextElement();
            aChild.adjustLocations(beginningAt, by);
        }
    }

    protected StringBuilder decodeEscaped(StringBuilder target) {
        int current = 0;
        StringBuilder result = new StringBuilder(target.length());
        while (current < target.length()) {
            int terminusAt;
            if ('\r' == target.charAt(current)) {
                result.append('\n');
                if (++current >= target.length() || '\n' != target.charAt(current)) continue;
                ++current;
                continue;
            }
            if ('&' != target.charAt(current)) {
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            for (terminusAt = current + 1; terminusAt < target.length() && terminusAt - current < 6 && ';' != target.charAt(terminusAt); ++terminusAt) {
            }
            if (terminusAt >= target.length() || ';' != target.charAt(terminusAt)) {
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            char[] sub = new char[terminusAt - current + 1];
            target.getChars(current, terminusAt + 1, sub, 0);
            String escaped = new String(sub);
            if ("&amp;".equals(escaped)) {
                result.append('&');
                current += 4;
            } else if ("&lt;".equals(escaped)) {
                result.append('<');
                current += 3;
            } else if ("&gt;".equals(escaped)) {
                result.append('>');
                current += 3;
            } else {
                if (escaped.startsWith("&#")) {
                    String numericChar = escaped.substring(2, escaped.length() - 1);
                    if (numericChar.length() < 1) {
                        result.append(target.charAt(current));
                        ++current;
                        continue;
                    }
                    if (numericChar.charAt(0) == 'x') {
                        if ((numericChar = numericChar.substring(1)).length() < 1) {
                            result.append(target.charAt(current));
                            ++current;
                            continue;
                        }
                        try {
                            char asChar = (char)Integer.parseInt(numericChar.toLowerCase(), 16);
                            result.append(asChar);
                            current += escaped.length();
                        }
                        catch (NumberFormatException badref) {
                            result.append(target.charAt(current));
                            ++current;
                        }
                        continue;
                    }
                    try {
                        char asChar = (char)Integer.parseInt(numericChar, 10);
                        result.append(asChar);
                        current += escaped.length();
                    }
                    catch (NumberFormatException badref) {
                        result.append(target.charAt(current));
                        ++current;
                    }
                    continue;
                }
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            ++current;
        }
        return result;
    }

    protected void encodeEscaped(StringBuilder target) {
        int current = 0;
        while (current < target.length()) {
            if ('&' == target.charAt(current)) {
                target.insert(current + 1, "amp;");
                current += 5;
                continue;
            }
            if ('<' == target.charAt(current)) {
                target.setCharAt(current, '&');
                target.insert(current + 1, "lt;");
                current += 4;
                continue;
            }
            ++current;
        }
    }

    @Override
    public Enumeration<Attribute> getAttributes() {
        tagRange nextAttr;
        char inTagName;
        int current;
        ArrayList<Attribute> results = new ArrayList<Attribute>();
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.getDocument().docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        while (current < this.loc.startTag.end && (nextAttr = this.getAttributeLoc(null, new charRange(current, this.loc.startTag.end))).isValid()) {
            results.add(new Attribute(this, this.getDocument().docContent.substring(nextAttr.startTag.start, nextAttr.startTag.end + 1), this.getDocument().docContent.substring(nextAttr.body.start, nextAttr.body.end + 1)));
            current = nextAttr.endTag.end + 1;
        }
        return Collections.enumeration(results);
    }

    protected tagRange getAttributeLoc(String name, charRange inRange) {
        tagRange result = new tagRange();
        int current = inRange.start;
        while (true) {
            char inTagName;
            if (current <= inRange.end && (Character.isWhitespace(inTagName = this.getDocument().docContent.charAt(current)) || '/' == inTagName || '>' == inTagName)) {
                ++current;
                continue;
            }
            int equalsAt = this.getDocument().docContent.indexOf("=", current);
            if (-1 == equalsAt || equalsAt >= inRange.end) {
                return result;
            }
            result.startTag.start = current;
            result.startTag.end = equalsAt - 1;
            String requiredQuote = this.getDocument().docContent.substring(equalsAt + 1, equalsAt + 2);
            if ('\'' != requiredQuote.charAt(0) && '\"' != requiredQuote.charAt(0)) {
                return result;
            }
            int nextQuote = this.getDocument().docContent.indexOf(requiredQuote, equalsAt + 2);
            if (-1 == nextQuote || nextQuote >= inRange.end) {
                return result;
            }
            result.body.start = equalsAt + 2;
            result.body.end = nextQuote - 1;
            result.endTag.start = nextQuote;
            result.endTag.end = nextQuote;
            if (null != name && !name.equals(this.getDocument().docContent.substring(result.startTag.start, result.startTag.end + 1))) {
                result.startTag.start = -1;
            }
            if ((current = nextQuote + 1) >= inRange.end || result.isValid()) break;
        }
        return result;
    }

    @Override
    public String addAttribute(String name, String value) {
        char usingQuote;
        char inTagName;
        int current;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null == name) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (null == value) {
            throw new IllegalArgumentException("value must not be null");
        }
        for (int eachChar = name.length() - 1; eachChar >= 0; --eachChar) {
            if (!Character.isWhitespace(name.charAt(eachChar))) continue;
            throw new IllegalArgumentException("Attribute names may not contain spaces.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.getDocument().docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        String oldValue = null;
        tagRange oldAttr = this.getAttributeLoc(name, new charRange(current, this.loc.startTag.end));
        char c = usingQuote = -1 != value.indexOf(34) ? (char)'\'' : '\"';
        if ('\'' == usingQuote && -1 != value.indexOf(39)) {
            throw new IllegalArgumentException("Value contains both \" and '");
        }
        StringBuilder newStuff = new StringBuilder(" ");
        newStuff.append(name);
        newStuff.append("=");
        newStuff.append(usingQuote);
        newStuff.append(value);
        newStuff.append(usingQuote);
        if (!oldAttr.isValid()) {
            this.getDocument().docContent.insert(current, newStuff.toString());
            this.getDocument().adjustLocations(current, newStuff.length());
        } else {
            oldValue = this.getDocument().docContent.substring(oldAttr.body.start, oldAttr.body.end + 1);
            this.getDocument().docContent.delete(oldAttr.body.start, oldAttr.body.end + 1);
            this.getDocument().docContent.insert(oldAttr.body.start, value);
            int delta = value.length() - (oldAttr.body.end - oldAttr.body.start + 1);
            this.getDocument().adjustLocations(this.loc.startTag.start + 1, delta);
        }
        return oldValue;
    }

    @Override
    public String addAttribute(Attribute newAttrib) {
        return this.addAttribute(newAttrib.getName(), newAttrib.getValue());
    }

    @Override
    public Attribute getAttribute(String name) {
        char inTagName;
        int current;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.getDocument().docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        tagRange attr = this.getAttributeLoc(name, new charRange(current, this.loc.startTag.end));
        if (!attr.isValid()) {
            return null;
        }
        return new Attribute(this, this.getDocument().docContent.substring(attr.startTag.start, attr.startTag.end + 1), this.getDocument().docContent.substring(attr.body.start, attr.body.end + 1));
    }

    protected boolean checkConsistency() {
        assert (this.loc.isValid());
        charRange elementRange = new charRange(this.loc.startTag.start, this.loc.endTag.end);
        assert (elementRange.contains(this.loc.startTag));
        assert (elementRange.contains(this.loc.body));
        assert (elementRange.contains(this.loc.endTag));
        if (null != this.children) {
            Iterator<LiteXMLElement> eachChild = this.children.iterator();
            Iterator<LiteXMLElement> nextChilds = this.children.iterator();
            if (nextChilds.hasNext()) {
                nextChilds.next();
            }
            while (eachChild.hasNext()) {
                LiteXMLElement aChild = eachChild.next();
                assert (this.loc.contains(aChild.loc));
                if (nextChilds.hasNext()) {
                    LiteXMLElement nextChild = nextChilds.next();
                    assert (aChild.loc.compareTo(nextChild.loc) < 0);
                } else assert (!eachChild.hasNext());
                aChild.checkConsistency();
            }
        }
        return true;
    }

    LiteXMLDocument getDocument() {
        return this.doc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class tagRange
    implements Comparable<tagRange> {
        public charRange startTag;
        public charRange body;
        public charRange endTag;

        public tagRange() {
            this.startTag = new charRange();
            this.body = new charRange();
            this.endTag = new charRange();
        }

        public tagRange(charRange startTag, charRange body, charRange endTag) {
            this.startTag = startTag;
            this.body = body;
            this.endTag = endTag;
        }

        public boolean equals(Object aRange) {
            if (this == aRange) {
                return true;
            }
            if (!(aRange instanceof tagRange)) {
                return false;
            }
            tagRange likeMe = (tagRange)aRange;
            return this.startTag.equals(likeMe.startTag) && this.body.equals(likeMe.body) && this.endTag.equals(likeMe.endTag);
        }

        @Override
        public int compareTo(tagRange someRange) {
            if (this == someRange) {
                return 0;
            }
            int compared = this.startTag.compareTo(someRange.startTag);
            if (0 != compared) {
                return compared;
            }
            return this.endTag.compareTo(someRange.endTag);
        }

        public String toString() {
            return this.startTag + ":" + this.body + ":" + this.endTag;
        }

        public boolean contains(tagRange someRange) {
            return this.isValid() && someRange.isValid() && this.body.start <= someRange.startTag.start && this.body.end >= someRange.endTag.end;
        }

        public boolean contains(charRange someRange) {
            return this.isValid() && someRange.isValid() && this.body.start <= someRange.start && this.body.end >= someRange.end;
        }

        public boolean isEmptyElement() {
            return this.isValid() && this.startTag.equals(this.body) && this.startTag.equals(this.endTag);
        }

        public boolean isValid() {
            return null != this.startTag && null != this.body && null != this.endTag && this.startTag.isValid() && this.body.isValid() && this.endTag.isValid();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class charRange
    implements Comparable<charRange> {
        public int start;
        public int end;

        public charRange() {
            this.start = -1;
            this.end = -1;
        }

        public charRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object aRange) {
            if (this == aRange) {
                return true;
            }
            if (!(aRange instanceof charRange)) {
                return false;
            }
            charRange someRange = (charRange)aRange;
            return this.start == someRange.start && this.end == someRange.end;
        }

        @Override
        public int compareTo(charRange someRange) {
            if (this == someRange) {
                return 0;
            }
            if (this.start < someRange.start) {
                return -1;
            }
            if (this.start > someRange.start) {
                return 1;
            }
            if (this.end < someRange.end) {
                return -1;
            }
            if (this.end > someRange.end) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "]";
        }

        public boolean contains(charRange someRange) {
            return this.isValid() && someRange.isValid() && this.start <= someRange.start && this.end >= someRange.end;
        }

        public boolean contains(tagRange someRange) {
            return this.isValid() && someRange.isValid() && this.start <= someRange.startTag.start && this.end >= someRange.endTag.end;
        }

        public boolean contains(int someLoc) {
            return this.isValid() && someLoc >= 0 && this.start <= someLoc && this.end >= someLoc;
        }

        public boolean isValid() {
            return this.length() >= 0;
        }

        public int length() {
            if (-1 == this.start || -1 == this.end) {
                return -1;
            }
            return this.end - this.start + 1;
        }
    }
}

