/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.cbjx;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageFilterListener;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.JxtaMessageMessageElement;
import net.jxta.impl.endpoint.cbjx.CbJxMessageInfo;
import net.jxta.impl.endpoint.cbjx.CbJxMessenger;
import net.jxta.impl.id.CBID.PeerID;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;

public class CbJxTransport
implements Module,
MessageSender,
MessageReceiver,
EndpointListener {
    private static final Logger LOG = Logger.getLogger(CbJxTransport.class.getName());
    public static final String CBJX_MSG_NS = "cbjx";
    static final String CBJX_MSG_INFO = "CryptoInfo";
    static final String CBJX_MSG_BODY = "Body";
    static final String CBJX_MSG_SIG = "Signature";
    static final String cbjxProtocolName = "cbjx";
    static final String cbjxServiceName = "CbJxTransport";
    static net.jxta.peer.PeerID localPeerID = null;
    static EndpointAddress localPeerAddr = null;
    PeerGroup group = null;
    EndpointService endpoint = null;
    PSEMembershipService membership = null;

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = group;
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)impl;
        localPeerID = group.getPeerID();
        localPeerAddr = new EndpointAddress("cbjx", group.getPeerID().getUniqueValue().toString(), null, null);
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring CBJX Message Transport : " + assignedID);
            if (implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tPublic Address : ").append(localPeerAddr);
            LOG.config(configInfo.toString());
        }
    }

    public int startApp(String[] arg) {
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        MembershipService groupMembership = this.group.getMembershipService();
        if (null == groupMembership) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a membership service");
            }
            return 2;
        }
        if (!(groupMembership instanceof PSEMembershipService)) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("CBJX Transport requires PSE Membership Service");
            }
            return -1;
        }
        this.membership = (PSEMembershipService)groupMembership;
        if (this.endpoint.addMessageTransport(this) == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Transport registration refused");
            }
            return -1;
        }
        this.endpoint.addIncomingMessageListener(this, cbjxServiceName, null);
        this.endpoint.addIncomingMessageFilterListener(new CbJxInputFilter(), null, null);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("CbJxTransport started");
        }
        return 0;
    }

    public void stopApp() {
        if (this.endpoint != null) {
            this.endpoint.removeMessageTransport(this);
            this.endpoint = null;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("CbJxTransport stopped");
        }
    }

    public EndpointAddress getPublicAddress() {
        return localPeerAddr;
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowsRouting() {
        return false;
    }

    public EndpointService getEndpointService() {
        return (EndpointService)this.endpoint.getInterface();
    }

    public Object transportControl(Object operation, Object value) {
        return null;
    }

    public Iterator getPublicAddresses() {
        return Collections.singletonList(this.getPublicAddress()).iterator();
    }

    public String getProtocolName() {
        return "cbjx";
    }

    public Messenger getMessenger(EndpointAddress dest, Object hintIgnored) {
        try {
            return new CbJxMessenger(this, dest, hintIgnored);
        }
        catch (IOException failed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to create cbjx messenger", failed);
            }
            return null;
        }
    }

    @Deprecated
    public boolean ping(EndpointAddress addr) {
        boolean reachable;
        Messenger messenger = this.getMessenger(addr, null);
        boolean bl = reachable = null != messenger;
        if (messenger != null) {
            messenger.close();
        }
        return reachable;
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block11: {
            MessageElement cryptoElement;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("processIncomingMessage : Received message from: " + srcAddr);
            }
            if ((cryptoElement = message.getMessageElement("cbjx", CBJX_MSG_INFO)) == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("processIncomingMessage : No 'CryptoInfo' in the message");
                }
                return;
            }
            message.removeMessageElement(cryptoElement);
            CbJxMessageInfo cryptoInfo = null;
            try {
                cryptoInfo = new CbJxMessageInfo(cryptoElement.getStream(), cryptoElement.getMimeType());
            }
            catch (Throwable e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "processIncomingMessage : Couldn't retrieve CbJxMessageInfo from 'CryptoInfo' element", e);
                }
                return;
            }
            Message submessage = this.checkCryptoInfo(message, cryptoElement, cryptoInfo);
            if (null == submessage) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("processIncomingMessage : discarding message from " + srcAddr);
                }
                return;
            }
            try {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("processIncomingMessage: delivering " + submessage + " to: " + cryptoInfo.getDestinationAddress());
                }
                this.endpoint.processIncomingMessage(submessage, cryptoInfo.getSourceAddress(), cryptoInfo.getDestinationAddress());
            }
            catch (Throwable all) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block11;
                LOG.log(Level.WARNING, "processIncomingMessage: endpoint failed to demux message", all);
            }
        }
    }

    public Message addCryptoInfo(Message submessage, EndpointAddress destAddress) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Building CBJX wrapper for " + submessage);
        }
        Message.ElementIterator eachCbJxElement = submessage.getMessageElementsOfNamespace("cbjx");
        while (eachCbJxElement.hasNext()) {
            MessageElement aMessageElement = (MessageElement)eachCbJxElement.next();
            eachCbJxElement.remove();
        }
        Message message = new Message();
        CbJxMessageInfo cryptoInfo = new CbJxMessageInfo();
        cryptoInfo.setSourceID(localPeerID);
        cryptoInfo.setSourceAddress(localPeerAddr);
        cryptoInfo.setDestinationAddress(destAddress);
        PSECredential cred = (PSECredential)this.membership.getDefaultCredential();
        if (null == cred) {
            throw new IOException("No authentication available for message signing.");
        }
        X509Certificate cert = cred.getCertificate();
        cryptoInfo.setPeerCert(cert);
        TextDocument infoDoc = (TextDocument)cryptoInfo.getDocument(MimeMediaType.XMLUTF8);
        byte[] infoSignature = null;
        try {
            infoSignature = PSEUtils.computeSignature("SHA1WITHRSA", cred.getPrivateKey(), infoDoc.getStream());
        }
        catch (Throwable e) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "failed to sign " + submessage, e);
            }
            return null;
        }
        ByteArrayMessageElement infoSigElement = new ByteArrayMessageElement(CBJX_MSG_SIG, MimeMediaType.AOS, infoSignature, null);
        TextDocumentMessageElement cryptoInfoElement = new TextDocumentMessageElement(CBJX_MSG_INFO, infoDoc, (MessageElement)infoSigElement);
        message.addMessageElement("cbjx", cryptoInfoElement);
        WireFormatMessage subserial = WireFormatMessageFactory.toWire(submessage, WireFormatMessageFactory.DEFAULT_WIRE_MIME, null);
        byte[] bodySignature = null;
        try {
            bodySignature = PSEUtils.computeSignature("SHA1WITHRSA", cred.getPrivateKey(), subserial.getStream());
        }
        catch (Throwable e) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "failed to sign" + submessage, e);
            }
            return null;
        }
        subserial = null;
        ByteArrayMessageElement bodySigElement = new ByteArrayMessageElement(CBJX_MSG_SIG, MimeMediaType.AOS, bodySignature, null);
        message.addMessageElement("cbjx", new JxtaMessageMessageElement(CBJX_MSG_BODY, new MimeMediaType("application/x-jxta-msg"), submessage, bodySigElement));
        return message;
    }

    public Message checkCryptoInfo(Message message, MessageElement cryptoElement, CbJxMessageInfo cryptoInfo) {
        boolean valid;
        JxtaMessageMessageElement bodyElement = (JxtaMessageMessageElement)message.getMessageElement("cbjx", CBJX_MSG_BODY);
        if (null == bodyElement) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No 'Body' in " + message);
            }
            return null;
        }
        message.removeMessageElement(bodyElement);
        Certificate peerCert = cryptoInfo.getPeerCert();
        RSAPublicKey publicKey = (RSAPublicKey)peerCert.getPublicKey();
        try {
            peerCert.verify(publicKey);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Invalid peer cert", e);
            }
            return null;
        }
        try {
            PeerID srcPeerID = (PeerID)cryptoInfo.getSourceID();
            byte[] pub_der = peerCert.getPublicKey().getEncoded();
            PeerID genID = (PeerID)IDFactory.newPeerID(this.group.getPeerGroupID(), pub_der);
            if (!srcPeerID.getUUID().equals(genID.getUUID())) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("CBID of " + message + " is not valid : " + srcPeerID + " != " + genID);
                }
                return null;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("CBID of the message is valid");
            }
        }
        catch (Throwable e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to verify cbid", e);
            }
            return null;
        }
        try {
            valid = PSEUtils.verifySignature("SHA1WITHRSA", peerCert, cryptoElement.getSignature().getBytes(false), cryptoElement.getStream());
            if (!valid) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Failed to verify the signature of cryptinfo for " + message);
                }
                return null;
            }
        }
        catch (Throwable e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to verify the signature of cryptinfo for " + message, e);
            }
            return null;
        }
        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("verifying signature");
        }
        try {
            valid = PSEUtils.verifySignature("SHA1WITHRSA", peerCert, bodyElement.getSignature().getBytes(false), bodyElement.getStream());
            if (!valid) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("failed to verify the signature of " + message);
                }
                return null;
            }
        }
        catch (Throwable e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to verify the signature of " + message, e);
            }
            return null;
        }
        return bodyElement.getMessage();
    }

    public class CbJxOutputFilter
    implements MessageFilterListener {
        public Message filterMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            Message msg = message.clone();
            if (null == msg.getMessageElement("cbjx", CbJxTransport.CBJX_MSG_INFO)) {
                try {
                    msg = CbJxTransport.this.addCryptoInfo(msg, dstAddr);
                }
                catch (IOException failed) {
                    return null;
                }
            }
            return msg;
        }
    }

    public class CbJxInputFilter
    implements MessageFilterListener {
        public Message filterMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            if (dstAddr.getProtocolAddress().equals(CbJxTransport.this.getProtocolName())) {
                MessageElement cryptoElement = message.getMessageElement("cbjx", CbJxTransport.CBJX_MSG_INFO);
                if (cryptoElement == null) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("No 'CryptoInfo' in the message");
                    }
                    return null;
                }
                message.removeMessageElement(cryptoElement);
                CbJxMessageInfo cryptoInfo = null;
                try {
                    cryptoInfo = new CbJxMessageInfo(cryptoElement.getStream(), cryptoElement.getMimeType());
                }
                catch (Throwable e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Couldn't retrieve CbJxMessageInfo from 'CryptoInfo' element", e);
                    }
                    return null;
                }
                return CbJxTransport.this.checkCryptoInfo(message, cryptoElement, cryptoInfo);
            }
            return message;
        }
    }
}

